/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.brush;

import cn.hutool.json.JSONUtil;
import com.digiwin.athena.ania.aspect.Lock;
import com.digiwin.athena.ania.common.ImConstants;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.mongo.domain.AgileDataResultLog;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.Conversation;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.domain.MessageFeedback;
import com.digiwin.athena.ania.mongo.repository.AgileDataResultLogMgDao;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.mongo.repository.AssistantDao;
import com.digiwin.athena.ania.mongo.repository.ConversationMessageDao;
import com.digiwin.athena.ania.mongo.repository.ConversationMessageSearchMgDao;
import com.digiwin.athena.ania.mongo.repository.MessageFeedbackMgDao;
import com.digiwin.athena.ania.service.conversation.ConversationIndexService;
import com.digiwin.athena.ania.service.conversation.ConversationMessageService;
import com.digiwin.athena.ania.service.message.HisConversationMessageService;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.EventMessageUtils;
import com.digiwin.athena.ania.util.RedisUtils;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component
public class HisMgsMigrateConversationComponent {
    private static final Logger log = LoggerFactory.getLogger(HisMgsMigrateConversationComponent.class);
    private static final String COLLECTION_NAME = "ania_message";
    private static final String MSG_TIMES_TAMP = "msgTimestamp";
    public static final String HIS_MGS_MIGRATE_KEY = "ANIA:MessageMigrateAgoraService:Migrate:STATUS";
    @Resource
    private AssistantDao assistantDao;
    @Resource
    private MongoTemplate semcMessageMongoTemplate;
    @Resource
    private ConversationMessageDao conversationMessageDao;
    @Resource
    private ConversationMessageService conversationMessageService;
    @Resource
    private HisConversationMessageService hisConversationMessageService;
    @Resource
    private ConversationIndexService conversationIndexService;
    @Resource
    private ConversationMessageSearchMgDao conversationMessageSearchMgDao;
    @Resource
    private AgileDataResultLogMgDao agileDataResultLogMgDao;
    @Resource
    private MessageFeedbackMgDao messageFeedbackMgDao;
    @Resource
    private AsaKnowledgeMessageDao asaKnowledgeMessageDao;
    @Value(value="${assistant.designerLegworkCode}")
    private String legworkCode;
    private static final int PAGE_SIZE = 200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Lock(key="MessageMigrateAgoraService:Migrate", expire=300000L)
    public void migrate(String assistantCode, Long startTimestamp) {
        try {
            RedisUtils.cacheStrData((String)HIS_MGS_MIGRATE_KEY, (String)"1", (long)2L, (TimeUnit)TimeUnit.HOURS);
            long timestamp = System.currentTimeMillis();
            List assistantList = StringUtils.isNotBlank((CharSequence)assistantCode) ? this.assistantDao.findAllByAssistantCode(assistantCode) : this.assistantDao.findAll();
            Map assistantMap = assistantList.stream().filter(assistant -> StringUtils.isNotBlank((CharSequence)assistant.getAccid()) && Objects.equals(1, assistant.getStatus())).collect(Collectors.toMap(Assistant::getAssistantCode, Function.identity(), (key1, key2) -> key2));
            log.info("migrate start assistantMap:{}", assistantMap);
            long totalCount = 0L;
            for (Assistant assistant2 : assistantMap.values()) {
                if (Objects.equals(this.legworkCode, assistant2.getAssistantCode()) || "asadatest".equals(assistant2.getAssistantCode())) continue;
                long migrateNum = this.assistantMigrateConversationMessage(assistant2, startTimestamp, timestamp);
                totalCount += migrateNum;
            }
            log.info("HisMgsMigrateConversationComponent.migrate end totalCount:{}", (Object)totalCount);
        }
        catch (Exception e) {
            log.error("HisMgsMigrateConversationComponent.migrate is error", (Throwable)e);
        }
        finally {
            RedisUtils.deleteCacheStrData((String)HIS_MGS_MIGRATE_KEY);
        }
    }

    private long assistantMigrateConversationMessage(Assistant assistant, Long startTimestamp, long endTime) {
        Set assistantAllAccId = this.getAssistantAllAccId(assistant);
        long totalCount = 0L;
        if (CollectionUtils.isNotEmpty((Collection)assistantAllAccId)) {
            for (String userAccount : assistantAllAccId) {
                long startTime = 0L;
                if (Objects.nonNull(startTimestamp)) {
                    startTime = startTimestamp;
                }
                if (startTime > endTime) continue;
                long count = this.count(assistant.getAccid(), userAccount, startTime, endTime);
                log.info("migrate ing assistantCode:{},userAccount:{}, serviceAccId:{},count:{}", new Object[]{assistant.getAssistantCode(), userAccount, assistant.getAccid(), count});
                if (count <= 0L) continue;
                long migrateNum = this.syncMigrateConversationMessage(assistant, userAccount, count, startTime, endTime);
                totalCount += migrateNum;
            }
        }
        return totalCount;
    }

    public Set<String> findDuplicateMessageIds(String serviceAccId, String userAccId, long startTime, long endTime) {
        Criteria criteria = Criteria.where((String)MSG_TIMES_TAMP).lt((Object)endTime).gt((Object)startTime);
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)userAccId), Criteria.where((String)"toAccount").is((Object)userAccId)});
        Criteria criteria2 = new Criteria();
        criteria2.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)serviceAccId), Criteria.where((String)"toAccount").is((Object)serviceAccId)});
        criteria.andOperator(new Criteria[]{criteria1, criteria2});
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"msgidServer"}).count().as("count"), Aggregation.match((Criteria)Criteria.where((String)"count").gt((Object)1)), Aggregation.project((String[])new String[0]).and("_id").as("msgidServer")});
        AggregationResults results = this.semcMessageMongoTemplate.aggregate(aggregation, COLLECTION_NAME, Document.class);
        if (CollectionUtils.isNotEmpty((Collection)results.getMappedResults())) {
            return results.getMappedResults().stream().map(doc -> doc.getString((Object)"msgidServer")).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private long syncMigrateConversationMessage(Assistant assistant, String userAccount, long count, long startTime, long endTime) {
        Conversation conversation = this.getConversation(assistant, userAccount);
        if (Objects.isNull(conversation)) {
            return 0L;
        }
        long num = this.conversationMessageDao.countMessageByConversationId(conversation.getConversationId());
        boolean existMessage = num > 0L;
        long maxIndex = count + num;
        this.conversationIndexService.resetMaxIndex(conversation.getUserId(), new Long(maxIndex).intValue(), conversation.getConversationId());
        boolean repeatedMigration = false;
        if (existMessage) {
            long source = this.conversationMessageDao.count(new Query((CriteriaDefinition)Criteria.where((String)"source").is((Object)1).and("conversationId").is((Object)conversation.getConversationId())));
            repeatedMigration = source > 0L;
        }
        Set duplicateMessageIds = this.findDuplicateMessageIds(assistant.getAccid(), userAccount, startTime, endTime);
        long page = count / 200L + 1L;
        long runMaxIndex = maxIndex;
        long queryEndTime = endTime;
        int i = 0;
        while ((long)i < page) {
            Pair lastMessage = this.syncMigrateMessage(duplicateMessageIds, assistant, conversation, runMaxIndex, repeatedMigration, userAccount, startTime, queryEndTime);
            queryEndTime = (Long)lastMessage.getKey();
            runMaxIndex = (Long)lastMessage.getValue();
            ++i;
        }
        long migrateNum = maxIndex - runMaxIndex;
        log.info("syncMigrateConversationMessage end assistantCode:{},userAccount:{}, serviceAccId:{},count:{},migrateCount:{}", new Object[]{assistant.getAssistantCode(), userAccount, assistant.getAccid(), count, migrateNum});
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"conversationId").is((Object)conversation.getConversationId()));
        num = this.conversationMessageDao.count(query);
        if (num > 0L) {
            this.conversationIndexService.resetMaxIndex(conversation.getUserId(), new Long(num).intValue(), conversation.getConversationId());
            this.conversationIndexService.resetReadIndex(conversation.getUserId(), conversation.getConversationId(), new Long(num).intValue());
        }
        if (existMessage || count != num) {
            this.resetMessageIndex(conversation, maxIndex, num);
        }
        return migrateNum;
    }

    private void resetMessageIndex(Conversation conversation, long maxIndex, long num) {
        long page = num / 200L + 1L;
        long currentTimeMillis = System.currentTimeMillis();
        long index = num;
        int i = 0;
        while ((long)i < page) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"conversationId").is((Object)conversation.getConversationId()).and("createTime").lt((Object)currentTimeMillis).and("index").lte((Object)maxIndex));
            query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
            query.limit(200);
            List conversationMessages = this.conversationMessageDao.findList(query);
            for (ConversationMessage message : conversationMessages) {
                currentTimeMillis = message.getCreateTime();
                if ((int)index != message.getIndex()) {
                    message.setIndex(Integer.valueOf((int)index));
                    this.conversationMessageDao.save((Object)message);
                    this.conversationMessageSearchMgDao.update(new Query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)message.getMessageId())), new Update().set("index", (Object)message.getIndex()));
                }
                --index;
            }
            ++i;
        }
    }

    private Set<String> getAssistantAllAccId(Assistant assistant) {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)assistant.getAccid()), Criteria.where((String)"toAccount").is((Object)assistant.getAccid())})), Aggregation.group((String[])new String[]{"fromAccount", "toAccount"}), Aggregation.project((String[])new String[]{"fromAccount", "toAccount"})});
        AggregationResults results = this.semcMessageMongoTemplate.aggregate(agg, COLLECTION_NAME, Document.class);
        HashSet<String> allAccIds = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)results.getMappedResults())) {
            for (Document doc : results) {
                String fromAccount = doc.getString((Object)"fromAccount");
                String toAccount = doc.getString((Object)"toAccount");
                if (assistant.getAccid().equals(fromAccount)) {
                    allAccIds.add(toAccount);
                    continue;
                }
                allAccIds.add(fromAccount);
            }
            allAccIds.remove(assistant.getAccid());
        }
        return allAccIds;
    }

    private Conversation getConversation(Assistant assistant, String userAccount) {
        Criteria criteria = Criteria.where((String)"msgExt.userId").exists(true).ne((Object)"integration");
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)userAccount), Criteria.where((String)"toAccount").is((Object)userAccount)});
        Criteria criteria2 = new Criteria();
        criteria2.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)assistant.getAccid()), Criteria.where((String)"toAccount").is((Object)assistant.getAccid())});
        Criteria tenant = new Criteria();
        tenant.orOperator(new Criteria[]{Criteria.where((String)"msgExt.tenantId").exists(true), Criteria.where((String)"msgExt.targetTenantId").exists(true), Criteria.where((String)"msgExt.routerKey").exists(true)});
        criteria.andOperator(new Criteria[]{criteria1, criteria2, tenant});
        Query query = new Query((CriteriaDefinition)criteria);
        ImMessageLog messageLog = (ImMessageLog)this.semcMessageMongoTemplate.findOne(query, ImMessageLog.class, COLLECTION_NAME);
        String finaUserId = null;
        String finaTenantId = null;
        if (Objects.nonNull(messageLog)) {
            finaUserId = MapUtils.getString((Map)messageLog.getMsgExt(), (Object)"userId");
            finaTenantId = MapUtils.getString((Map)messageLog.getMsgExt(), (Object)"tenantId");
            if (StringUtils.isBlank((CharSequence)finaTenantId)) {
                finaTenantId = MapUtils.getString((Map)messageLog.getMsgExt(), (Object)"targetTenantId");
            }
            if (StringUtils.isBlank((CharSequence)finaTenantId)) {
                finaTenantId = MapUtils.getString((Map)messageLog.getMsgExt(), (Object)"routerKey");
            }
        }
        if (StringUtils.isNotBlank(finaUserId) && StringUtils.isNotBlank(finaTenantId)) {
            Conversation conversation = this.hisConversationMessageService.queryConversation(assistant.getAssistantCode(), finaUserId, finaTenantId);
            if (Objects.isNull(conversation)) {
                conversation = this.hisConversationMessageService.creatConversation(assistant, finaUserId, finaTenantId);
            }
            return conversation;
        }
        return null;
    }

    private long count(String serviceAccId, String userAccId, long startTime, long endTime) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)userAccId), Criteria.where((String)"toAccount").is((Object)userAccId)});
        Criteria criteria2 = new Criteria();
        criteria2.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)serviceAccId), Criteria.where((String)"toAccount").is((Object)serviceAccId)});
        criteria.andOperator(new Criteria[]{criteria1, criteria2});
        Query query = new Query((CriteriaDefinition)criteria);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)MSG_TIMES_TAMP).lt((Object)endTime).gt((Object)startTime));
        return this.semcMessageMongoTemplate.count(query, COLLECTION_NAME);
    }

    private Pair<Long, Long> syncMigrateMessage(Set<String> duplicateMessageIds, Assistant assistant, Conversation conversation, long maxIndex, boolean repeatedMigration, String userAccount, long startTime, long endTime) {
        long index;
        long indexTime;
        block7: {
            Criteria criteria = new Criteria();
            Criteria criteria1 = new Criteria();
            criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)userAccount), Criteria.where((String)"toAccount").is((Object)userAccount)});
            Criteria criteria2 = new Criteria();
            criteria2.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)assistant.getAccid()), Criteria.where((String)"toAccount").is((Object)assistant.getAccid())});
            criteria.andOperator(new Criteria[]{criteria1, criteria2});
            Query query = new Query((CriteriaDefinition)criteria);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)MSG_TIMES_TAMP).lt((Object)endTime).gt((Object)startTime));
            query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{MSG_TIMES_TAMP}));
            query.limit(200);
            List messageLogList = this.semcMessageMongoTemplate.find(query, ImMessageLog.class, COLLECTION_NAME);
            indexTime = -1L;
            index = maxIndex;
            if (!CollectionUtils.isNotEmpty((Collection)messageLogList)) break block7;
            indexTime = ((ImMessageLog)messageLogList.get(messageLogList.size() - 1)).getMsgTimestamp();
            if (repeatedMigration) {
                for (ImMessageLog imMessageLog : messageLogList) {
                    ConversationMessage conversationMessage = null;
                    if (CollectionUtils.isNotEmpty(duplicateMessageIds) && duplicateMessageIds.contains(imMessageLog.getMsgidServer())) {
                        this.conversationMessageDao.delete(new Query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)imMessageLog.getMsgidServer())));
                    } else {
                        conversationMessage = this.conversationMessageDao.findByMessageId(conversation.getConversationId(), imMessageLog.getMsgidServer());
                    }
                    if (Objects.isNull(conversationMessage)) {
                        conversationMessage = this.saveHisConversationMessage(assistant, conversation, imMessageLog, Long.valueOf(index));
                        index = conversationMessage.getIndex() - 1;
                        continue;
                    }
                    this.buildStreamContent(conversationMessage);
                    this.conversationMessageService.updateMessage(conversationMessage);
                }
            } else {
                for (ImMessageLog imMessageLog : messageLogList) {
                    ConversationMessage conversationMessage;
                    if (CollectionUtils.isNotEmpty(duplicateMessageIds) && duplicateMessageIds.contains(imMessageLog.getMsgidServer()) && Objects.nonNull(conversationMessage = this.conversationMessageDao.findByMessageId(conversation.getConversationId(), imMessageLog.getMsgidServer()))) continue;
                    conversationMessage = this.saveHisConversationMessage(assistant, conversation, imMessageLog, Long.valueOf(index));
                    index = conversationMessage.getIndex() - 1;
                }
            }
        }
        return Pair.of((Object)indexTime, (Object)index);
    }

    private ConversationMessage saveHisConversationMessage(Assistant assistant, Conversation conversation, ImMessageLog imMessageLog, Long index) {
        ConversationMessage conversationMessage = ConversationMessage.builder().conversationId(conversation.getConversationId()).agentId(conversation.getAgentId()).messageId(imMessageLog.getMsgidServer()).userId(conversation.getUserId()).tenantId(conversation.getTenantId()).userType(imMessageLog.getFromAccount().equals(assistant.getAccid()) ? 2 : 1).msgType(imMessageLog.getMsgType()).msgBody(imMessageLog.getMsgBody()).ext((Map)imMessageLog.getMsgExt()).msgExt(JSONUtil.toJsonStr((Object)imMessageLog.getMsgExt())).status(Integer.valueOf(1)).sectionId(conversation.getSectionId()).source(Integer.valueOf(1)).index(Integer.valueOf(index.intValue())).createTime(imMessageLog.getMsgTimestamp()).build();
        this.buildStreamContent(conversationMessage);
        this.hisConversationMessageService.sendMessage(conversationMessage);
        return conversationMessage;
    }

    private void buildStreamContent(ConversationMessage conversationMessage) {
        try {
            String text;
            if (CollectionUtils.isNotEmpty((Collection)conversationMessage.getContent())) {
                return;
            }
            if (ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar().equalsIgnoreCase(conversationMessage.getMsgType())) {
                String contentId = MapUtils.getString((Map)conversationMessage.getMsgBody(), (Object)"contentId");
                if (StringUtils.isNotBlank((CharSequence)contentId)) {
                    Optional knowledgeMessage = this.asaKnowledgeMessageDao.findById((Object)contentId);
                    knowledgeMessage.ifPresent(message -> EventMessageUtils.buildStreamContent((ConversationMessage)conversationMessage, (AsaKnowledgeMessage)message));
                }
            } else if (ImConstants.ImMsgTypeEnum.TEXT.getTypeChar().equalsIgnoreCase(conversationMessage.getMsgType()) && StringUtils.isNotBlank((CharSequence)(text = MapUtils.getString((Map)conversationMessage.getMsgBody(), (Object)"text")))) {
                HashMap<String, String> textContent = new HashMap<String, String>(2);
                textContent.put("type", SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType());
                textContent.put(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), text);
                conversationMessage.setContent((List)Lists.newArrayList((Object[])new Map[]{textContent}));
            }
        }
        catch (Exception e) {
            log.error("buildStreamContent is error", (Throwable)e);
        }
    }

    public void migrateFeedBack(ConversationMessage hisConversationMessage) {
        try {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"msgidServer").is((Object)hisConversationMessage.getMessageId()));
            AgileDataResultLog dataResultLogMgDaoOne = (AgileDataResultLog)this.agileDataResultLogMgDao.findOne(query);
            if (Objects.nonNull(dataResultLogMgDaoOne)) {
                MessageFeedback messageFeedback = MessageFeedback.builder().feedbackType(Integer.valueOf(1)).conversationId(hisConversationMessage.getConversationId()).messageId(hisConversationMessage.getMessageId()).build();
                if (Objects.equals(0, dataResultLogMgDaoOne.getFeedbackType())) {
                    messageFeedback.setFeedbackType(Integer.valueOf(1));
                } else if (Objects.equals(1, dataResultLogMgDaoOne.getFeedbackType())) {
                    messageFeedback.setFeedbackType(Integer.valueOf(2));
                    String answerOpinion = dataResultLogMgDaoOne.getAnswerOpinion();
                    String checkOpinions = dataResultLogMgDaoOne.getCheckOpinions();
                    if (StringUtils.isNotBlank((CharSequence)checkOpinions)) {
                        Object[] split = checkOpinions.split(",");
                        HashMap<String, Object> feedbackDetail = new HashMap<String, Object>();
                        if (ArrayUtils.isNotEmpty((Object[])split)) {
                            List collect = Arrays.stream(split).map(Integer::valueOf).collect(Collectors.toList());
                            feedbackDetail.put("feedbackDetailTypes", collect);
                        }
                        if (StringUtils.isNotBlank((CharSequence)answerOpinion)) {
                            feedbackDetail.put("feedbackDetailContent", answerOpinion);
                        }
                        messageFeedback.setFeedbackDetail(feedbackDetail);
                    }
                }
                if (Objects.nonNull(messageFeedback.getFeedbackType())) {
                    hisConversationMessage.setFeedback(messageFeedback.getFeedbackType());
                    this.conversationMessageDao.save((Object)hisConversationMessage);
                    if (MapUtils.isNotEmpty((Map)messageFeedback.getFeedbackDetail())) {
                        this.messageFeedbackMgDao.save((Object)messageFeedback);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("migrateFeedBack is error hisConversationMessage:{}", (Object)BaseUseUtils.toJsonString((Object)hisConversationMessage), (Object)e);
        }
    }
}

