/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.command;

import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.configuration.RedisLock;
import com.digiwin.athena.ania.dto.command.CommandChainDto;
import com.digiwin.athena.ania.dto.command.CommandChainPageVo;
import com.digiwin.athena.ania.dto.command.CommandChainQueryDto;
import com.digiwin.athena.ania.dto.command.CommandChainVo;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.mongo.domain.CommandChain;
import com.digiwin.athena.ania.mongo.repository.CommandChainDao;
import com.digiwin.athena.ania.service.assistant.FusionAssistantService;
import com.digiwin.athena.ania.service.command.CommandChainService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class CommandChainServiceImpl
implements CommandChainService {
    private static final String LOCK_KEY = "ANIA:COMMAND:CHAIN:";
    private static final long COMMAND_CHAIN_LOCK = 5000L;
    @Resource
    private CommandChainDao commandChainDao;
    @Resource
    private FusionAssistantService fusionAssistantService;
    @Resource
    private RedisLock redisLock;

    public List<CommandChainVo> queryAssistantCommandChain(AuthoredUser authoredUser, String assistantId) {
        List commandChains = this.commandChainDao.queryAssistantCommandChain(authoredUser.getUserId(), authoredUser.getTenantId(), assistantId);
        if (CollectionUtils.isNotEmpty((Collection)commandChains)) {
            return commandChains.stream().map(CommandChainVo::convert).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public CommandChainPageVo queryCommandChain(AuthoredUser authoredUser, CommandChainQueryDto query) {
        CommandChainPageVo commandChainPageVo = new CommandChainPageVo();
        query.setPageSize(query.getPageSize() + 1);
        List commandChains = this.commandChainDao.queryCommandChain(authoredUser.getUserId(), authoredUser.getTenantId(), query);
        List commandChainVos = Collections.emptyList();
        if (CollectionUtils.isNotEmpty((Collection)commandChains)) {
            if (commandChains.size() == query.getPageSize()) {
                commandChains.remove(query.getPageSize() - 1);
                commandChainPageVo.setHasMore(true);
            }
            HashSet assistants = new HashSet();
            for (CommandChain commandChain : commandChains) {
                assistants.addAll(commandChain.getAssistants());
            }
            Map fusionAssistantMap = assistants.stream().map(assistantId -> this.fusionAssistantService.assistantBaseInfo(new FusionAssistantInfoDto(null, assistantId, null, Boolean.valueOf(false)), authoredUser)).filter(Objects::isNull).collect(Collectors.toMap(assistant -> assistant.getAssistantId(), Function.identity()));
            commandChainVos = commandChains.stream().map(item -> {
                CommandChainVo commandChainVo = CommandChainVo.convert((CommandChain)item);
                commandChainVo.setAssistantInfo(commandChainVo.getAssistants().stream().map(id -> {
                    FusionAssistantVo fusionAssistantVo = (FusionAssistantVo)fusionAssistantMap.get(id);
                    HashMap<String, String> info = null;
                    if (Objects.nonNull(fusionAssistantVo)) {
                        info = new HashMap<String, String>();
                        info.put("assistantId", (String)id);
                        info.put("assistantName", fusionAssistantVo.getAssistantName());
                        info.put("iconUrl", fusionAssistantVo.getIconUrl());
                    }
                    return info;
                }).collect(Collectors.toList()));
                return commandChainVo;
            }).collect(Collectors.toList());
        }
        commandChainPageVo.setCommands(commandChainVos);
        return commandChainPageVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultBean<CommandChainVo> addCommandChain(AuthoredUser authoredUser, CommandChainDto commandChain) {
        ResultBean check = commandChain.check();
        if (!check.succeeded()) {
            return ResultBean.fail((String)check.getErrorMessage());
        }
        commandChain.setAssistants(commandChain.getAssistants().stream().distinct().collect(Collectors.toList()));
        String tryLock = null;
        String key = "ANIA:COMMAND:CHAIN:ANIA_" + authoredUser.getTenantId() + authoredUser.getUserId();
        try {
            tryLock = this.redisLock.tryLock(key, 5000L);
            if (Objects.isNull(tryLock)) {
                ResultBean resultBean = ResultBean.fail((String)"\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                return resultBean;
            }
            for (String assistantId : commandChain.getAssistants()) {
                FusionAssistantInfoDto query = new FusionAssistantInfoDto(null, assistantId, null, Boolean.valueOf(false));
                FusionAssistantInfoDto param = FusionAssistantInfoDto.builder().assistantId(assistantId).auth(Boolean.valueOf(false)).build();
                FusionAssistantVo fusionAssistantVo = this.fusionAssistantService.assistantBaseInfo(param, authoredUser);
                if (Objects.isNull(fusionAssistantVo)) {
                    ResultBean resultBean = ResultBean.fail((String)(assistantId + " Is NOT Exist"));
                    return resultBean;
                }
                Criteria baseQuery = Criteria.where((String)"tenantId").is((Object)authoredUser.getTenantId()).and("userId").is((Object)authoredUser.getUserId()).and("status").is((Object)1).and("assistants").in(new Object[]{assistantId});
                long count = this.commandChainDao.count(new Query((CriteriaDefinition)baseQuery));
                if (count > 50L) {
                    ResultBean resultBean = ResultBean.fail((String)"\u52a9\u7406\u6307\u4ee4\u94fe\u6570\u91cf\u8d85\u8fc7\u6700\u592750\u9650\u5236");
                    return resultBean;
                }
                baseQuery.and("name").is((Object)commandChain.getName());
                long nameCount = this.commandChainDao.count(new Query((CriteriaDefinition)baseQuery));
                if (nameCount <= 1L) continue;
                ResultBean resultBean = ResultBean.fail((String)" name Exist");
                return resultBean;
            }
            CommandChain addCommandChain = CommandChain.builder().userId(authoredUser.getUserId()).tenantId(authoredUser.getTenantId()).assistants(commandChain.getAssistants()).commands(commandChain.getCommands()).createTime(Long.valueOf(System.currentTimeMillis())).updateTime(Long.valueOf(System.currentTimeMillis())).build();
            this.commandChainDao.save((Object)addCommandChain);
            ResultBean resultBean = ResultBean.successful((Object)CommandChainVo.convert((CommandChain)addCommandChain));
            return resultBean;
        }
        finally {
            if (Objects.nonNull(tryLock)) {
                this.redisLock.unlock(key, tryLock);
            }
        }
    }

    public ResultBean<CommandChainVo> updateCommandChain(AuthoredUser authoredUser, CommandChainDto updateCommandChain) {
        ResultBean check = updateCommandChain.check();
        if (!check.succeeded()) {
            return ResultBean.fail((String)check.getErrorMessage());
        }
        CommandChain commandChain = (CommandChain)this.commandChainDao.findById((Object)updateCommandChain.getId());
        for (String assistantId : commandChain.getAssistants()) {
            Criteria baseQuery = Criteria.where((String)"tenantId").is((Object)authoredUser.getTenantId()).and("userId").is((Object)authoredUser.getUserId()).and("status").is((Object)1).and("assistants").in(new Object[]{assistantId});
            baseQuery.and("name").is((Object)commandChain.getName());
            long nameCount = this.commandChainDao.count(new Query((CriteriaDefinition)baseQuery));
            if (nameCount <= 1L) continue;
            return ResultBean.fail((String)"name Exist");
        }
        commandChain.setName(updateCommandChain.getName());
        commandChain.setCommands(updateCommandChain.getCommands());
        this.commandChainDao.save((Object)commandChain);
        return ResultBean.successful((Object)CommandChainVo.convert((CommandChain)commandChain));
    }

    public boolean deleteCommandChain(AuthoredUser authoredUser, String id) {
        return this.commandChainDao.deleteCommandChain(authoredUser.getUserId(), authoredUser.getTenantId(), id);
    }
}

