/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.conversation.impl;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ania.mapper.mysql.ConversationMaxIndexMapper;
import com.digiwin.athena.ania.mapper.mysql.ConversationReadIndexMapper;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.repository.ConversationMessageDao;
import com.digiwin.athena.ania.mysql.domain.ConversationMaxIndex;
import com.digiwin.athena.ania.mysql.domain.ConversationReadIndex;
import com.digiwin.athena.ania.service.conversation.ConversationIndexService;
import com.digiwin.athena.ania.util.RedisUtils;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConversationIndexServiceImpl
implements ConversationIndexService {
    private static final Logger log = LoggerFactory.getLogger(ConversationIndexServiceImpl.class);
    private static final String SCRIPT = "local current = redis.call('GET', KEYS[1])\nif current == false then\n    return redis.call('SET', KEYS[1], ARGV[1], 'EX', 86400)\nelseif tonumber(ARGV[1]) > tonumber(current) then\n    return redis.call('SET', KEYS[1], ARGV[1], 'EX', 86400)\nelse\n    return 0\nend";
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private ConversationMessageDao conversationMessageDao;
    @Resource
    private ConversationMaxIndexMapper conversationMaxIndexMapper;
    @Resource
    private ConversationReadIndexMapper conversationReadIndexMapper;

    @Transactional
    public void initConversationIndex(String conversationId) {
        ConversationMaxIndex newIndex = new ConversationMaxIndex();
        newIndex.setConversationId(conversationId);
        newIndex.setMaxIndex(Integer.valueOf(0));
        this.conversationMaxIndexMapper.insert((Object)newIndex);
        ConversationReadIndex conversationReadIndex = new ConversationReadIndex();
        conversationReadIndex.setConversationId(conversationId);
        conversationReadIndex.setReadIndex(Integer.valueOf(0));
        this.conversationReadIndexMapper.insert((Object)conversationReadIndex);
    }

    @Transactional
    public Integer incrementIndex(String userId, String conversationId) {
        for (int i = 0; i < 3; ++i) {
            ConversationMaxIndex conversationMaxIndex = this.conversationMaxIndexMapper.selectForUpdate(conversationId);
            if (conversationMaxIndex == null) {
                ConversationMaxIndex newIndex = new ConversationMaxIndex();
                newIndex.setConversationId(conversationId);
                newIndex.setMaxIndex(Integer.valueOf(1));
                try {
                    this.conversationMaxIndexMapper.insert((Object)newIndex);
                    return 1;
                }
                catch (DuplicateKeyException e) {
                    continue;
                }
            }
            Integer current = conversationMaxIndex.getMaxIndex();
            conversationMaxIndex.setMaxIndex(Integer.valueOf(current + 1));
            int updated = this.conversationMaxIndexMapper.updateById((Object)conversationMaxIndex);
            if (updated <= 0) continue;
            return conversationMaxIndex.getMaxIndex();
        }
        throw new RuntimeException("\u89d2\u6807\u751f\u6210\u5931\u8d25\uff1a\u5e76\u53d1\u51b2\u7a81\u8fc7\u591a");
    }

    @Transactional
    public void resetMaxIndex(String userId, int maxIndex, String conversationId) {
        ConversationMaxIndex conversationMaxIndex = this.conversationMaxIndexMapper.selectForUpdate(conversationId);
        if (conversationMaxIndex == null) {
            try {
                conversationMaxIndex = new ConversationMaxIndex();
                conversationMaxIndex.setConversationId(conversationId);
                conversationMaxIndex.setMaxIndex(Integer.valueOf(maxIndex));
                this.conversationMaxIndexMapper.insert((Object)conversationMaxIndex);
            }
            catch (DuplicateKeyException e) {
                conversationMaxIndex = this.conversationMaxIndexMapper.selectForUpdate(conversationId);
                conversationMaxIndex.setMaxIndex(Integer.valueOf(maxIndex));
                this.conversationMaxIndexMapper.updateById((Object)conversationMaxIndex);
            }
        } else {
            conversationMaxIndex.setMaxIndex(Integer.valueOf(maxIndex));
            this.conversationMaxIndexMapper.updateById((Object)conversationMaxIndex);
        }
        String maxIndexCacheKey = "CONVERSATION_MAX_INDEX:" + userId + ":" + conversationId;
        this.redisTemplate.opsForValue().set((Object)maxIndexCacheKey, (Object)conversationMaxIndex.getMaxIndex());
    }

    public Integer getMaxIndex(String userId, String conversationId, Integer agentType) {
        String key = "CONVERSATION_MAX_INDEX:" + userId + ":" + conversationId;
        String cache = RedisUtils.getCacheStrData((String)key);
        if (cache != null) {
            return Integer.valueOf(cache);
        }
        ConversationMessage lastMessage = this.conversationMessageDao.getLastMessageByConversationId(conversationId);
        if (Objects.nonNull(lastMessage)) {
            this.updateConversationMaxIndex(lastMessage.getUserId(), lastMessage.getConversationId(), lastMessage.getIndex().intValue());
            return lastMessage.getIndex();
        }
        return 0;
    }

    public Integer getReadIndex(String userId, String conversationId) {
        String key = "CONVERSATION_READ_MSG_INDEX:" + userId + ":" + conversationId;
        String cache = RedisUtils.getCacheStrData((String)key);
        if (StrUtil.isNotBlank((CharSequence)cache)) {
            return Integer.valueOf(cache);
        }
        ConversationReadIndex dbValue = this.conversationReadIndexMapper.selectByConversationId(conversationId);
        if (Objects.nonNull(dbValue)) {
            this.updateConversationIndex(dbValue.getReadIndex().intValue(), key);
            return dbValue.getReadIndex();
        }
        return 0;
    }

    public void updateConversationMaxIndex(String userId, String conversationId, int index) {
        String maxIndexCacheKey = "CONVERSATION_MAX_INDEX:" + userId + ":" + conversationId;
        this.updateConversationIndex(index, maxIndexCacheKey);
    }

    @Transactional
    public void updateConversationReadIndex(String userId, String conversationId, int readIndex) {
        ConversationReadIndex conversationReadIndex = this.conversationReadIndexMapper.selectForUpdate(conversationId);
        if (conversationReadIndex == null) {
            conversationReadIndex = new ConversationReadIndex();
            conversationReadIndex.setConversationId(conversationId);
            conversationReadIndex.setReadIndex(Integer.valueOf(readIndex));
            try {
                this.conversationReadIndexMapper.insert((Object)conversationReadIndex);
            }
            catch (DuplicateKeyException e) {
                conversationReadIndex = this.conversationReadIndexMapper.selectForUpdate(conversationId);
                if (readIndex > conversationReadIndex.getReadIndex()) {
                    conversationReadIndex.setReadIndex(Integer.valueOf(readIndex));
                    this.conversationReadIndexMapper.updateById((Object)conversationReadIndex);
                }
            }
        } else if (readIndex > conversationReadIndex.getReadIndex()) {
            conversationReadIndex.setReadIndex(Integer.valueOf(readIndex));
            this.conversationReadIndexMapper.updateById((Object)conversationReadIndex);
        }
        String readIndexCacheKey = "CONVERSATION_READ_MSG_INDEX:" + userId + ":" + conversationId;
        this.updateConversationIndex(conversationReadIndex.getReadIndex().intValue(), readIndexCacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConversationIndex(int readMax, String indexCacheKey) {
        byte[][] keysAndArgs = new byte[][]{indexCacheKey.getBytes(StandardCharsets.UTF_8), String.valueOf(readMax).getBytes(StandardCharsets.UTF_8)};
        RedisConnectionFactory factory = this.redisTemplate.getConnectionFactory();
        assert (factory != null);
        RedisConnection conn = factory.getConnection();
        try {
            conn.scriptingCommands().eval(SCRIPT.getBytes(StandardCharsets.UTF_8), ReturnType.INTEGER, 1, (byte[][])keysAndArgs);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)conn, (RedisConnectionFactory)factory);
        }
    }

    public void resetReadIndex(String userId, String conversationId, int readIndex) {
        ConversationReadIndex conversationReadIndex = this.conversationReadIndexMapper.selectForUpdate(conversationId);
        if (Objects.nonNull(conversationReadIndex)) {
            conversationReadIndex.setReadIndex(Integer.valueOf(readIndex));
            this.conversationReadIndexMapper.updateById((Object)conversationReadIndex);
        }
        String readIndexCacheKey = "CONVERSATION_READ_MSG_INDEX:" + userId + ":" + conversationId;
        this.redisTemplate.opsForValue().set((Object)readIndexCacheKey, (Object)readIndex);
    }
}

