/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.conversation.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.configuration.RedisLock;
import com.digiwin.athena.ania.dto.ConversationReceiveDto;
import com.digiwin.athena.ania.dto.conversation.ChatMessageQueryDto;
import com.digiwin.athena.ania.dto.conversation.ConversationMsgListVo;
import com.digiwin.athena.ania.dto.conversation.ConversationMsgQueryDto;
import com.digiwin.athena.ania.dto.conversation.MessageQueryDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.eventbus.message.ConversationMessageEvent;
import com.digiwin.athena.ania.mongo.domain.Conversation;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.repository.ConversationDao;
import com.digiwin.athena.ania.mongo.repository.ConversationMessageDao;
import com.digiwin.athena.ania.service.assistant.FusionAssistantService;
import com.digiwin.athena.ania.service.conversation.ConversationIndexService;
import com.digiwin.athena.ania.service.conversation.ConversationMessageService;
import com.digiwin.athena.ania.service.conversation.ConversationService;
import com.digiwin.athena.ania.util.RedisUtils;
import com.digiwin.athena.ania.vo.ChatMessageListVo;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ConversationMessageServiceImpl
implements ConversationMessageService {
    @Resource
    private RedisLock redisLock;
    @Resource
    private ConversationDao conversationDao;
    @Resource
    private AsyncEventBus asyncEventBus;
    @Resource
    private ConversationMessageDao conversationMessageDao;
    @Resource
    private ConversationIndexService conversationIndexService;
    @Resource
    private ConversationService conversationService;
    @Resource
    private FusionAssistantService fusionAssistantService;

    public void sendMessage(ConversationMessage message) {
        message.initData();
        if (Objects.isNull(message.getCreateTime())) {
            message.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        }
        message.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        if (Objects.isNull(message.getIndex())) {
            Integer maxIndex = this.conversationIndexService.incrementIndex(message.getUserId(), message.getConversationId());
            message.setIndex(maxIndex);
        }
        this.sendMessageRetry(message, 3);
        this.asyncEventBus.post((Object)new ConversationMessageEvent(message, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConversationMessage sendMessageRetry(ConversationMessage message, int retry) {
        String tryLock = null;
        String key = "ANIA_" + message.getConversationId();
        try {
            tryLock = this.redisLock.tryLock(key, 5000L);
            if (Objects.isNull(tryLock)) {
                if (--retry > 0) {
                    ConversationMessage conversationMessage = this.sendMessageRetry(message, retry);
                    return conversationMessage;
                }
                throw BusinessException.create((String)"send Message fail");
            }
            ConversationMessage conversationMessage = (ConversationMessage)this.conversationMessageDao.insert((Object)message);
            return conversationMessage;
        }
        finally {
            if (Objects.nonNull(tryLock)) {
                this.redisLock.unlock(key, tryLock);
            }
        }
    }

    public void updateMessage(ConversationMessage message) {
        if (StringUtils.isBlank((CharSequence)message.getId())) {
            throw new IllegalArgumentException("id to update must not be null!");
        }
        message.initData();
        this.conversationMessageDao.save((Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationMessage conversationReceive(ConversationReceiveDto dto) {
        String lockKey;
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (StrUtil.isBlank((CharSequence)dto.getTenantId())) {
            dto.setTenantId(authoredUser.getTenantId());
        }
        Conversation conversation = null;
        if (StrUtil.isNotBlank((CharSequence)dto.getConversationId())) {
            conversation = this.conversationService.getConversation(dto.getConversationId(), null, dto.getTenantId(), dto.getUserId());
            if (Objects.isNull(conversation)) {
                throw new ServiceException("Conversation Is Not Exist");
            }
            lockKey = "ANIA:ASYNC:SEND:MESSAGE:" + dto.getConversationId();
        } else {
            lockKey = "ANIA:ASYNC:SEND:MESSAGE::" + dto.getTenantId() + ":" + dto.getUserId() + ":" + dto.getAssistantId();
        }
        String lockValue = UUID.randomUUID().toString();
        boolean locked = this.redisLock.acquireLock(lockKey, lockValue, 10000L, 10000L);
        if (!locked) {
            throw new ServiceException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        try {
            if (Objects.isNull(conversation) && Objects.isNull(conversation = this.conversationDao.queryLatestConversationByAgentId(dto.getTenantId(), dto.getUserId(), dto.getAssistantId()))) {
                FusionAssistantVo fusionAssistant = this.fusionAssistantService.assistantBaseInfo(new FusionAssistantInfoDto(null, dto.getAssistantId(), null, Boolean.valueOf(false)), authoredUser);
                if (Objects.isNull(fusionAssistant)) {
                    throw new ServiceException("Assistant Is Not Exist");
                }
                conversation = this.conversationService.creatConversation(fusionAssistant.getAssistantName(), fusionAssistant, dto.getUserId(), dto.getTenantId());
            }
            ConversationMessage conversationMessage = this.externalSendMessage(dto, conversation);
            return conversationMessage;
        }
        finally {
            this.redisLock.releaseLock(lockKey);
        }
    }

    private ConversationMessage externalSendMessage(ConversationReceiveDto param, Conversation conversation) {
        ConversationMessage message = ConversationMessage.conversationReceive((ConversationReceiveDto)param, (Conversation)conversation);
        String key = "ANIA:ASSISTANT:CHAT:" + message.getConversationId();
        String chatMessageId = RedisUtils.getCacheStrData((String)key);
        if (StringUtils.isNotBlank((CharSequence)chatMessageId)) {
            RedisUtils.convertAndSend((String)(Objects.equals(conversation.getAgentType(), AssistantType.HISTORY_ASSISTANT.getType()) ? "ANIA_SSE_DISCONNECT" : "ANIA_AGENT_SSE_STOP"), (Object)chatMessageId);
        }
        if (RedisUtils.noKey((String)key, (long)5000L)) {
            this.sendMessage(message);
            return message;
        }
        throw new ServiceException("\u6b63\u5728\u5bf9\u8bdd\u4e2d\uff0c\u53d1\u9001\u9891\u7387\u8fc7\u9ad8\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    public ConversationMsgListVo list(ConversationMsgQueryDto conversationMsgQuery) {
        ConversationMessage conversationMessage;
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String conversationId = conversationMsgQuery.getConversationId();
        if (StringUtils.isBlank((CharSequence)conversationId)) {
            String assistantId = conversationMsgQuery.getAssistantId();
            if (StringUtils.isBlank((CharSequence)assistantId)) {
                new ServiceException("conversation Not exist");
            }
            Conversation conversation = this.conversationDao.queryLatestConversationByAgentId(authoredUser.getTenantId(), authoredUser.getUserId(), assistantId);
            Assert.notNull((Object)conversation, () -> new ServiceException("conversation Not exist"));
            conversationMsgQuery.setConversationId(conversation.getConversationId());
        }
        if (StrUtil.isNotBlank((CharSequence)conversationMsgQuery.getAfterId())) {
            conversationMessage = this.conversationMessageDao.findByMessageId(conversationId, conversationMsgQuery.getAfterId());
            Assert.notNull((Object)conversationMessage, () -> new ServiceException("afterId\u4e0d\u5b58\u5728\u8bf7\u6838\u5bf9\u6570\u636e"));
            conversationMsgQuery.setEndIndex(conversationMessage.getIndex());
        }
        if (StrUtil.isNotBlank((CharSequence)conversationMsgQuery.getBeforeId())) {
            conversationMessage = this.conversationMessageDao.findByMessageId(conversationId, conversationMsgQuery.getBeforeId());
            Assert.notNull((Object)conversationMessage, () -> new ServiceException("beforeId\u4e0d\u5b58\u5728\u8bf7\u6838\u5bf9\u6570\u636e"));
            conversationMsgQuery.setStartIndex(conversationMessage.getIndex());
        }
        List lately = this.conversationMessageDao.findLatelyConversationMessage(conversationMsgQuery, authoredUser);
        return ConversationMsgListVo.map((ConversationMsgQueryDto)conversationMsgQuery, (List)lately);
    }

    public ResultBean<ChatMessageListVo> queryMessage(ChatMessageQueryDto messageQuery, AuthoredUser authoredUser) {
        ChatMessageListVo hisChatMessageVo = new ChatMessageListVo();
        List conversationMessages = this.conversationMessageDao.queryMessage(messageQuery, authoredUser, Integer.valueOf(messageQuery.getPageSize() + 1));
        if (CollectionUtils.isNotEmpty((Collection)conversationMessages) && conversationMessages.size() > messageQuery.getPageSize()) {
            conversationMessages.remove(messageQuery.getPageSize());
            hisChatMessageVo.setHasMore(true);
        }
        hisChatMessageVo.setMessages(conversationMessages);
        return ResultBean.success((Integer)0, (Object)hisChatMessageVo);
    }

    public List<ConversationMessage> queryMessage(MessageQueryDto messageQueryDto, AuthoredUser authoredUser) {
        return this.conversationMessageDao.queryMessage(messageQueryDto.getMessageIds(), authoredUser.getUserId(), authoredUser.getTenantId());
    }
}

