/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.impl;

import com.digiwin.athena.ania.configuration.AgoraConfig;
import com.digiwin.athena.ania.configuration.YunXinConfig;
import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.helper.ChatFileHelper;
import com.digiwin.athena.ania.helper.UserMessageActionContext;
import com.digiwin.athena.ania.service.IGptService;
import com.digiwin.athena.ania.service.impl.IntentTypeHandlerStrategy;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GptServiceImpl
implements IGptService {
    private static final Logger log = LoggerFactory.getLogger(GptServiceImpl.class);
    @Autowired
    private IntentTypeHandlerStrategy intentTypeHandlerStrategy;
    @Autowired
    private YunXinConfig yunXinConfig;
    @Autowired
    private ChatFileHelper chatFileHelper;
    @Autowired
    private AgoraConfig agoraConfig;

    public void dialogueToGpt(ImMessageLog imMessageLog) {
        UserMessageActionContext userMessageActionContext = this.buildActionContext(imMessageLog);
        this.templateCommand(userMessageActionContext);
    }

    public void syncFileInfoToChatFile(String dmcId, AuthoredUser authoredUser) {
        try {
            this.chatFileHelper.syncFileInfoToChatFile(authoredUser, dmcId);
        }
        catch (Exception e) {
            log.info("\u4e0a\u4f20\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\u4fe1\u606f\u662f\uff1a{}", (Object)e.getMessage());
        }
    }

    private UserMessageActionContext buildActionContext(ImMessageLog imMessageLog) {
        UserMessageActionContext userMessageActionContext = new UserMessageActionContext();
        userMessageActionContext.setImMessageLog(imMessageLog);
        return userMessageActionContext;
    }

    private void templateCommand(UserMessageActionContext userMessageActionContext) {
        try {
            String skillType = (String)userMessageActionContext.getImMessageLog().getMsgExt().get((Object)"skillType");
            this.intentTypeHandlerStrategy.handler(skillType, userMessageActionContext);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7b2c\u4e09\u65b9\u6280\u80fd\u65b9\u83b7\u53d6\u4e91\u4fe1\u53d1\u6d88\u606f\u5931\u8d25:{}", (Throwable)e);
        }
    }
}

