/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.message;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ImConstants;
import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.common.enums.ConvMsgContentTypeEnum;
import com.digiwin.athena.ania.dto.conversation.ConversationSearchDto;
import com.digiwin.athena.ania.dto.conversation.MessageSearchLatelyDto;
import com.digiwin.athena.ania.entity.MessageSearch;
import com.digiwin.athena.ania.mapper.mongo.MessageSearchMongoMapper;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.domain.ConversationMessageSearch;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.mongo.repository.ConversationMessageSearchMgDao;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import com.digiwin.athena.ania.service.message.ConversationMessageSearchService;
import com.digiwin.athena.ania.vo.ChatMessageSearchListVo;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class ConversationMessageSearchServiceImpl
implements ConversationMessageSearchService {
    private static final Logger log = LoggerFactory.getLogger(ConversationMessageSearchServiceImpl.class);
    @Resource
    private ConversationMessageSearchMgDao conversationMessageSearchMgDao;
    @Resource
    private AssistantService assistantService;
    @Resource
    private AsaKnowledgeMessageDao asaKnowledgeMessageDao;
    @Resource
    protected MessageSearchMongoMapper messageSearchMongoMapper;

    public void addMessageSearch(ConversationMessage conversationMessage) {
        try {
            String keyWord = this.buildKeyWord(conversationMessage);
            if (StringUtils.isNotBlank((CharSequence)keyWord)) {
                ConversationMessageSearch messageSearch = ConversationMessageSearch.builder().messageId(conversationMessage.getMessageId()).conversationId(conversationMessage.getConversationId()).index(Long.valueOf(conversationMessage.getIndex().intValue())).userId(conversationMessage.getUserId()).tenantId(conversationMessage.getTenantId()).createTime(conversationMessage.getCreateTime()).agentId(conversationMessage.getAgentId()).keyword(keyWord).build();
                this.conversationMessageSearchMgDao.insert((Object)messageSearch);
            }
        }
        catch (Exception e) {
            log.error("addMessageSearch is error", (Throwable)e);
        }
    }

    private String buildKeyWord(ConversationMessage conversationMessage) {
        String keyWord = null;
        if (Objects.equals(1, conversationMessage.getSource())) {
            MessageSearch messageSearch = this.messageSearchMongoMapper.findOne(conversationMessage.getMessageId());
            if (Objects.nonNull(messageSearch)) {
                this.conversationMessageSearchMgDao.delete(new Query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)conversationMessage.getMessageId())));
                keyWord = messageSearch.getKeyword();
            }
            return keyWord;
        }
        JSONObject msgBody = conversationMessage.getMsgBody();
        if (ImConstants.ImMsgTypeEnum.TEXT.getTypeChar().equalsIgnoreCase(conversationMessage.getMsgType())) {
            keyWord = MapUtils.getString((Map)msgBody, (Object)"text");
        } else if (ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar().equalsIgnoreCase(conversationMessage.getMsgType())) {
            if (CollectionUtils.isNotEmpty((Collection)conversationMessage.getContent())) {
                keyWord = conversationMessage.getContent().stream().filter(content -> ConvMsgContentTypeEnum.TEXT.getCode().equals(content.get("type"))).map(content -> (String)content.get("text")).filter(Objects::nonNull).collect(Collectors.joining());
            } else if (MapUtils.isNotEmpty((Map)msgBody)) {
                Assistant assistant = this.assistantService.getAssistant(conversationMessage.getAgentId(), "1.0");
                if (Objects.isNull(assistant)) {
                    return keyWord;
                }
                if (AssistantSubTypeEnum.KNOWLEAGE.getType().equals(assistant.getAssistantSubType())) {
                    String contentId = MapUtils.getString((Map)msgBody, (Object)"contentId");
                    keyWord = this.getKeyWord(contentId);
                } else if (Objects.equals(AssistantSubTypeEnum.COMPOSITE.getType(), assistant.getAssistantSubType())) {
                    if (msgBody.containsKey((Object)"agileDataMessageType")) {
                        String scrumbi0uestion = msgBody.getString("scrumbi0uestion");
                        if (StringUtils.isNotBlank((CharSequence)scrumbi0uestion)) {
                            keyWord = scrumbi0uestion;
                        }
                    } else if (msgBody.containsKey((Object)"contentId") && msgBody.containsKey((Object)"knowledgeAssistantCode")) {
                        String contentId = msgBody.getString("contentId");
                        keyWord = this.getKeyWord(contentId);
                    } else {
                        keyWord = MapUtils.getString((Map)msgBody, (Object)"title");
                    }
                } else if (AssistantSubTypeEnum.BUSINESS.getType().equals(assistant.getAssistantSubType())) {
                    keyWord = MapUtils.getString((Map)msgBody, (Object)"title");
                }
            }
        } else if (CollectionUtils.isNotEmpty((Collection)conversationMessage.getContent())) {
            keyWord = conversationMessage.getContent().stream().filter(content -> ConvMsgContentTypeEnum.TEXT.getCode().equals(content.get("type"))).map(content -> (String)content.get("text")).filter(Objects::nonNull).collect(Collectors.joining());
        }
        return keyWord;
    }

    public ChatMessageSearchListVo search(ConversationSearchDto dto) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        List conversationMessageSearches = this.conversationMessageSearchMgDao.find(dto, authoredUser);
        ChatMessageSearchListVo chatMessageListVo = new ChatMessageSearchListVo();
        if (CollectionUtils.isNotEmpty((Collection)conversationMessageSearches) && conversationMessageSearches.size() > dto.getPageSize()) {
            conversationMessageSearches.remove(dto.getPageSize());
            chatMessageListVo.setHasMore(true);
        }
        chatMessageListVo.setMessages(conversationMessageSearches);
        return chatMessageListVo;
    }

    public List<ConversationMessageSearch> latelySearchMessage(MessageSearchLatelyDto dto) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        return this.conversationMessageSearchMgDao.findLately(dto.getLimit(), authoredUser);
    }

    private String getKeyWord(String contentId) {
        Optional byId = this.asaKnowledgeMessageDao.findById((Object)contentId);
        if (byId.isPresent()) {
            AsaKnowledgeMessage asaKnowledgeMessage = (AsaKnowledgeMessage)byId.get();
            return asaKnowledgeMessage.getMsg();
        }
        return null;
    }
}

