/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.notice.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.athena.ania.configuration.mqtt.MqttProperties;
import com.digiwin.athena.ania.configuration.mqtt.MqttPublisher;
import com.digiwin.athena.ania.dto.mqtt.EventMessageData;
import com.digiwin.athena.ania.service.notice.MqttService;
import com.digiwin.athena.ania.service.notice.dto.EventMessage;
import com.digiwin.athena.ania.util.IdSnowflake;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MqttServiceImpl
implements MqttService {
    private static final Logger log = LoggerFactory.getLogger(MqttServiceImpl.class);
    @Autowired
    private MqttPublisher mqttPublisher;
    @Autowired
    private MqttProperties mqttProperties;

    public void pushEvent(EventMessageData<?> eventData) {
        if (Objects.isNull(eventData.getMessageCategory())) {
            log.error("pushEvent is fail messageCategory is null");
            return;
        }
        String eventType = Objects.isNull(eventData.getActionEnum()) ? eventData.getMessageCategory().getCategory() : eventData.getMessageCategory().getCategory() + ":" + eventData.getActionEnum().getAction();
        EventMessage message = new EventMessage();
        message.setUserId(eventData.getUserId());
        message.setTenantId(eventData.getTenantId());
        message.setEventType(eventType);
        message.setContent(eventData.getContent());
        if (StrUtil.isNotBlank((CharSequence)eventData.getEventId())) {
            message.setEventId(eventData.getEventId());
        } else {
            message.setEventId(IdSnowflake.snowflakeIdStr());
        }
        this.pushEvent(message);
    }

    private void pushEvent(EventMessage message) {
        try {
            message.setEventTime(System.currentTimeMillis());
            String str = JSONUtil.toJsonStr((Object)message);
            String topic = this.getTopic(message);
            this.mqttPublisher.publish(topic, str);
            log.info("MqttService.pushEvent\u6d88\u606f\u63a8\u9001\u6210\u529f,topic:{},message:{}", (Object)topic, (Object)JSONUtil.toJsonStr((Object)message));
        }
        catch (Exception e) {
            log.error("mqtt\u6d88\u606f\u63a8\u9001\u5931\u8d25,message:{}", (Object)JSONUtil.toJsonStr((Object)message), (Object)e);
        }
    }

    private String getTopic(EventMessage message) {
        String baseTopic = this.mqttProperties.getServerName() + "/nnaAgent";
        if (StringUtils.isNotBlank((CharSequence)message.getTenantId())) {
            baseTopic = baseTopic + "/" + message.getTenantId();
        }
        if (StringUtils.isNotBlank((CharSequence)message.getUserId())) {
            baseTopic = baseTopic + "/" + message.getUserId();
        }
        return baseTopic;
    }
}

