/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.scene;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.MessageTypeEnum;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.knowledge.client.sse.EventStreamClient;
import com.digiwin.athena.ania.knowledge.client.sse.ForecastEventSourceListener;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.HisAssistantChatDto;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.proxy.dmc.service.DmcService;
import com.digiwin.athena.ania.service.scene.AssistantSceneStrategy;
import com.digiwin.athena.ania.util.LanguageUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GptSceneService
extends AssistantSceneStrategy {
    private static final Logger log = LoggerFactory.getLogger(GptSceneService.class);
    @Resource
    private DmcService dmcService;
    @Resource
    protected EnvProperties envProperties;
    @Resource
    protected SseEventDataService sseEventDataService;

    public GptSceneService() {
        super(Integer.valueOf(103));
    }

    public void intentRequestAction(SseEventParams sseEventParam) {
        try {
            Assistant assistant = sseEventParam.getAssistant();
            JSONObject methodConfig = assistant.getMethodConfig();
            JSONObject dataJsonObject = methodConfig.getJSONObject("data");
            String url = this.envProperties.getAirh() + "/api/ai/RH";
            String token = sseEventParam.getUser().getToken();
            String language = LanguageUtils.processSseLanguage();
            JSONObject param = new JSONObject();
            param.put("key", (Object)0);
            JSONObject firstData = new JSONObject();
            firstData.put("topic", (Object)MapUtil.getStr((Map)methodConfig, (Object)"topic", (String)"AI"));
            firstData.put("method", (Object)MapUtil.getStr((Map)methodConfig, (Object)"method", (String)"GPT4o"));
            firstData.put("timeout", (Object)"240");
            JSONObject secondData = new JSONObject();
            secondData.put("stream", (Object)true);
            secondData.put("temperature", (Object)MapUtil.getDouble((Map)dataJsonObject, (Object)"temperature", (Double)0.7));
            secondData.put("top_p", (Object)MapUtil.getInt((Map)dataJsonObject, (Object)"top_p", (Integer)1));
            secondData.put("max_tokens", (Object)MapUtil.getInt((Map)dataJsonObject, (Object)"max_tokens", (Integer)800));
            JSONArray prompts = new JSONArray();
            JSONArray userPrompts = this.getPrompts(sseEventParam);
            JSONArray systemPrompt = dataJsonObject.getJSONArray("prompt");
            if (null != systemPrompt && !systemPrompt.isEmpty()) {
                prompts.addAll((Collection)systemPrompt);
            }
            if (null != userPrompts && !userPrompts.isEmpty()) {
                prompts.addAll((Collection)userPrompts);
            }
            secondData.put("prompt", (Object)prompts);
            firstData.put("data", (Object)secondData);
            param.put("data", (Object)firstData);
            log.info("GptSceneService.intentRequestAction.param:{}", (Object)JSONUtil.toJsonStr((Object)param));
            ForecastEventSourceListener sseListener = new ForecastEventSourceListener(sseEventParam, this.sseEventDataService);
            EventStreamClient.executeSSE((String)url, null, (String)token, (EventSourceListener)sseListener, (JSONObject)param, (String)language, (Map)this.getExecuteFunctions(sseEventParam.getUser().getTenantId()));
        }
        catch (Exception e) {
            log.error("GptSceneService.intentRequestAction error SseEventParams:{}", (Object)JSONUtil.toJsonStr((Object)sseEventParam), (Object)e);
            String errorMsg = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u9884\u6d4b\u52a9\u7406\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u9810\u6e2c\u52a9\u7406\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
            this.errorStop(sseEventParam, errorMsg);
        }
    }

    private JSONArray getPrompts(SseEventParams sseEventParams) {
        JSONArray prompts = new JSONArray();
        String type = sseEventParams.getQuestion().getMessage().getType();
        String contentStr = sseEventParams.getQuestion().getMessage().getContent();
        HisAssistantChatDto question = sseEventParams.getQuestion();
        ConversationMessage questionMessage = sseEventParams.getQuestionMessage();
        List historyMessage = this.hisConversationMessageService.queryMessage(questionMessage.getUserId(), questionMessage.getTenantId(), questionMessage.getConversationId(), questionMessage.getSectionId(), questionMessage.getIndex(), 10);
        if (CollUtil.isNotEmpty((Collection)historyMessage)) {
            for (int i = 0; i < historyMessage.size(); ++i) {
                List textMap;
                String quest;
                ConversationMessage imMessageLog = (ConversationMessage)historyMessage.get(i);
                if (MessageTypeEnum.NEW_CONVERSATION.getType().equals(MapUtils.getInteger((Map)imMessageLog.getExt(), (Object)"messageType"))) break;
                if (null == imMessageLog.getMsgBody() || imMessageLog.getMsgBody().isEmpty() || !StrUtil.isNotBlank((CharSequence)(quest = imMessageLog.getMsgBody().getString("text")))) continue;
                String text = "";
                if (CollectionUtils.isNotEmpty((Collection)imMessageLog.getContent()) && CollectionUtils.isNotEmpty(textMap = imMessageLog.getContent().stream().filter(item -> "text".equalsIgnoreCase(MapUtils.getString((Map)item, (Object)"type"))).collect(Collectors.toList()))) {
                    text = MapUtils.getString((Map)((Map)textMap.get(0)), (Object)"text");
                }
                prompts.add((Object)new JSONObject().fluentPut("role", (Object)"assistant").fluentPut("content", (Object)text));
                prompts.add((Object)new JSONObject().fluentPut("role", (Object)"user").fluentPut("content", (Object)quest));
            }
        }
        CollUtil.reverse((List)prompts);
        JSONObject content = (JSONObject)JSONUtil.toBean((String)contentStr, JSONObject.class);
        JSONArray contentJsonArray = new JSONArray();
        if (Objects.nonNull(content) && !content.isEmpty() && "custom".equals(type)) {
            JSONArray files = content.getJSONArray("data");
            for (int i = 0; i < files.size(); ++i) {
                JSONObject file = files.getJSONObject(i);
                if (!"true".equals(file.getString("isPic"))) continue;
                String fileId = file.getString("fileId");
                Pair shareFile = this.dmcService.shareFile(fileId);
                String fileUrl = (String)shareFile.getKey();
                contentJsonArray.add((Object)new JSONObject().fluentPut("type", (Object)"image_url").fluentPut("image_url", (Object)new JSONObject().fluentPut("url", (Object)fileUrl)));
            }
            JSONObject textJsonObject = new JSONObject().fluentPut("type", (Object)"text").fluentPut("text", (Object)sseEventParams.getQuestion().getMessage().getText());
            contentJsonArray.add((Object)textJsonObject);
            prompts.add((Object)new JSONObject().fluentPut("role", (Object)"user").fluentPut("content", (Object)contentJsonArray));
        } else if ("text".equals(type) && content.isEmpty()) {
            prompts.add((Object)new JSONObject().fluentPut("role", (Object)"user").fluentPut("content", (Object)question.getMessage().getText()));
        } else {
            prompts.add((Object)new JSONObject().fluentPut("role", (Object)"user").fluentPut("content", (Object)question.getMessage().getText()));
        }
        return prompts;
    }
}

