/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.scene;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.MessageTypeEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.entity.im.ImSessionMsgLog;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import com.digiwin.athena.ania.knowledge.context.RichSseEmitter;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SendMqYunxinMsg;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.service.MessageService;
import com.digiwin.athena.ania.service.scene.SseEmitterCallbackComponent;
import com.digiwin.athena.ania.service.scene.callback.CallComponent;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import com.navercorp.pinpoint.sdk.v1.concurrent.TraceRunnable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class SseEmitterCallbackComponent {
    private static final Logger log = LoggerFactory.getLogger(SseEmitterCallbackComponent.class);
    @Resource
    private AsaKnowledgeMessageDao asaKnowledgeMessageDao;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    protected RedisTemplate<String, String> redisTemplate;
    @Value(value="${yunxin.knowledgeQueueName}")
    private String knowledgeQueueName;
    @Resource
    private MessageService messageService;
    @Resource
    private SseEventDataService sseEventDataService;
    @Resource
    private List<CallComponent> callComponents;
    protected Map<Integer, SseFlow> flowMap = new HashMap();

    @Autowired
    public void setFlowMap(List<SseFlow> sseFlows) {
        sseFlows.forEach(flow -> this.flowMap.put(flow.getFlowType().getFlowEventType(), flow));
    }

    public SseEmitter generateSseEmitter(SseEventParams sseEventParam) {
        String id = UUID.randomUUID().toString().replace("-", "");
        sseEventParam.setId(id);
        RichSseEmitter sseEmitter = new RichSseEmitter(Long.valueOf(300000L));
        KnowledgeContext.setSseEmitter((String)id, (SseEmitter)sseEmitter);
        sseEmitter.onTimeout(TraceRunnable.asyncEntry((Runnable)new TimeoutCallback(this, sseEventParam, null)));
        sseEmitter.onError((Consumer)new ErrorCallback(this, sseEventParam, null));
        sseEmitter.onCompletion(TraceRunnable.asyncEntry((Runnable)new CompletionCallback(this, sseEventParam, null)));
        sseEmitter.setSseEventParams(sseEventParam);
        return sseEmitter;
    }

    private void processMsg(SseEventParams sseEventParam, SendMqYunxinMsg problem) {
        for (int i = 0; i < this.callComponents.size(); ++i) {
            try {
                CallComponent callComponent = (CallComponent)this.callComponents.get(i);
                callComponent.processMsg(sseEventParam, problem);
                continue;
            }
            catch (Exception e) {
                log.error("SseEmitterCallbackComponent.processMsg error", (Throwable)e);
            }
        }
    }

    private void hiddenMultipleIntentAfterMsg(SseEventParams sseEventParam, JSONObject msgExt) {
        JSONObject selectScene = sseEventParam.getQuestion().getSelectScene();
        if (null == selectScene || selectScene.isEmpty()) {
            return;
        }
        JSONObject executeContext = selectScene.getJSONObject("executeContext");
        String rtMsgServerId = MapUtils.getString((Map)executeContext, (Object)"rtMsgServerId");
        if (StrUtil.isBlank((CharSequence)rtMsgServerId)) {
            return;
        }
        List imSessionMsgLogs = this.messageService.queryLatestMsg(sseEventParam.getQuestion().getMessage().getFrom(), sseEventParam.getQuestion().getMessage().getTo(), Integer.valueOf(3));
        if (CollUtil.isNotEmpty((Collection)imSessionMsgLogs)) {
            ImSessionMsgLog multipleMsg = (ImSessionMsgLog)imSessionMsgLogs.get(0);
            ImSessionMsgLog firstMessage = (ImSessionMsgLog)imSessionMsgLogs.get(1);
            ImSessionMsgLog secondMessage = (ImSessionMsgLog)imSessionMsgLogs.get(2);
            JSONObject body = multipleMsg.getBody();
            Integer messageType = body.getInteger("messageType");
            String messageBusinessCode = body.getString("messageBusinessCode");
            if (MessageTypeEnum.MULTIPLE_INTENTIONS.getType().equals(messageType) && "ania_multiple_intentions".equals(messageBusinessCode) && (rtMsgServerId.equals(String.valueOf(firstMessage.getMsgid())) || rtMsgServerId.equals(String.valueOf(secondMessage.getMsgid())))) {
                msgExt.put("hidden", (Object)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(SseEventParams sseEventParam) {
        EventData completed = new EventData(SseEventlEnum.CHAT_COMPLETED.getEvent(), null);
        this.sseEventDataService.saveEventDataLog(sseEventParam, completed);
        EventData doneData = new EventData(SseEventlEnum.CHAT_FAILED.getEvent(), null);
        this.sseEventDataService.saveEventDataLog(sseEventParam, doneData);
        SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEventParam.getId());
        if (Objects.nonNull(sseEmitter)) {
            try {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)completed);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)completed);
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)doneData);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)doneData);
            }
            catch (IOException e) {
                log.error("SseEmitterCallbackComponent.sendAnswerDone is error", (Throwable)e);
            }
            finally {
                sseEmitter.complete();
            }
        }
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    static /* synthetic */ SseEventDataService access$400(SseEmitterCallbackComponent x0) {
        return x0.sseEventDataService;
    }

    static /* synthetic */ void access$500(SseEmitterCallbackComponent x0, SseEventParams x1) {
        x0.stop(x1);
    }

    static /* synthetic */ AsaKnowledgeMessageDao access$600(SseEmitterCallbackComponent x0) {
        return x0.asaKnowledgeMessageDao;
    }

    static /* synthetic */ void access$700(SseEmitterCallbackComponent x0, SseEventParams x1, JSONObject x2) {
        x0.hiddenMultipleIntentAfterMsg(x1, x2);
    }

    static /* synthetic */ void access$800(SseEmitterCallbackComponent x0, SseEventParams x1, SendMqYunxinMsg x2) {
        x0.processMsg(x1, x2);
    }

    static /* synthetic */ RabbitTemplate access$900(SseEmitterCallbackComponent x0) {
        return x0.rabbitTemplate;
    }

    static /* synthetic */ String access$1000(SseEmitterCallbackComponent x0) {
        return x0.knowledgeQueueName;
    }
}

