/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.token.base.impl;

import com.digiwin.athena.ania.service.token.base.TokenConfig;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DefaultTokenConfigImpl
implements TokenConfig {
    protected volatile String token;
    protected Lock tokenLock = new ReentrantLock();
    protected volatile long expiresTime;

    public void setToken(String token) {
        this.token = token;
    }

    public void setExpiresTime(long expiresTime) {
        this.expiresTime = expiresTime;
    }

    public String getToken() {
        return this.token;
    }

    public Lock getTokenLock() {
        return this.tokenLock;
    }

    public boolean isTokenExpired() {
        return this.isExpired(this.expiresTime);
    }

    public Long tokenExpiredTime() {
        return this.expiresTime;
    }

    public void expireToken() {
        this.expiresTime = 0L;
        this.token = null;
    }

    public synchronized void updateApplicationToken(String token, long expiresInSeconds) {
        this.setToken(token);
        this.setExpiresTime(this.expiresAheadInMillis(expiresInSeconds));
    }

    protected boolean isExpired(long expiresTime) {
        return System.currentTimeMillis() > expiresTime;
    }

    protected long expiresAheadInMillis(long expiresInSeconds) {
        return System.currentTimeMillis() + expiresInSeconds * 1000L;
    }
}

