/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.urge.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.dto.GlobalUrgeAndDetailBO;
import com.digiwin.athena.ania.mongo.domain.AniaUrgeSet;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.Urge;
import com.digiwin.athena.ania.mongo.repository.AniaUrgeSetDao;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import com.digiwin.athena.ania.service.urge.UrgeService;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UrgeServiceImpl
implements UrgeService {
    private static final Logger log = LoggerFactory.getLogger(UrgeServiceImpl.class);
    @Autowired
    private MessageUtils messageUtils;
    @Resource
    private AniaUrgeSetDao aniaUrgeSetDao;
    @Resource
    private AssistantService assistantService;

    public GlobalUrgeAndDetailBO queryGlobalUrge(String assistantCode) {
        GlobalUrgeAndDetailBO result = new GlobalUrgeAndDetailBO();
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        AniaUrgeSet aniaUrgeSet = this.aniaUrgeSetDao.findAllByAssistantCodeAndIamIdAndTenantId(assistantCode, authoredUser.getUserId(), authoredUser.getTenantId());
        log.info("\u7528\u6237\u8bbe\u7f6e\u7684\u50ac\u529e\u89c4\u5219,userId:{},result:{}", (Object)authoredUser.getUserId(), (Object)BaseUseUtils.toJsonString((Object)aniaUrgeSet));
        if (Objects.isNull(aniaUrgeSet)) {
            Assistant assistant = this.assistantService.getAssistant(assistantCode);
            Urge urge = assistant.getUrge();
            if (Objects.nonNull(urge)) {
                result.setCount(urge.getCount()).setIamId(authoredUser.getUserId()).setEffectiveStatus(urge.getEffectiveStatus()).setIntervalInMinutes(urge.getIntervalInMinutes()).setStartAfter(urge.getStartAfter()).setUrgeWayShow(urge.getUrgeWayShow());
                result.setUrgeTypes(urge.getUrgeTypes());
                log.info("\u672a\u67e5\u8be2\u5230\u8be5\u7528\u6237\u50ac\u529e\u89c4\u5219,\u8fd4\u56de\u52a9\u7406\u8bbe\u7f6e\u7684\u50ac\u529e,userId:{},,result:{}", (Object)authoredUser.getUserId(), (Object)BaseUseUtils.toJsonString((Object)result));
                return result;
            }
            result.setCount(Integer.valueOf(1)).setIamId(authoredUser.getUserId()).setEffectiveStatus(Boolean.TRUE).setIntervalInMinutes(Integer.valueOf(30)).setStartAfter(Integer.valueOf(30)).setUrgeWayShow(Integer.valueOf(3));
            ArrayList<JSONObject> data = new ArrayList<JSONObject>(result.getCount());
            for (int i = 1; i <= result.getCount(); ++i) {
                int urgeWay = 0;
                if (i == 2) {
                    urgeWay = 1;
                } else if (i == 3) {
                    urgeWay = 2;
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.fluentPut("numberOfTime", (Object)i);
                jsonObject.fluentPut("urgeWay", (Object)urgeWay);
                data.add(jsonObject);
            }
            result.setUrgeTypes(data);
            log.info("\u672a\u67e5\u8be2\u5230\u8be5\u7528\u6237\u50ac\u529e\u89c4\u5219\u548c\u52a9\u7406\u8bbe\u7f6e\u7684\u50ac\u529e,\u8fd4\u56de\u9ed8\u8ba4\u503c,userId:{},,result:{}", (Object)authoredUser.getUserId(), (Object)BaseUseUtils.toJsonString((Object)result));
            return result;
        }
        BeanUtils.copyProperties((Object)aniaUrgeSet, (Object)result);
        return result;
    }

    public void update(GlobalUrgeAndDetailBO userGlobalUrgeAndDetail) {
        AniaUrgeSet aniaUrgeSet;
        if (CollectionUtils.isEmpty((Collection)userGlobalUrgeAndDetail.getUrgeTypes()) || userGlobalUrgeAndDetail.getCount().intValue() != userGlobalUrgeAndDetail.getUrgeTypes().size()) {
            BaseUseUtils.businessException((String)this.messageUtils.getMessage("error.message.common.param-missing"));
        }
        if (Objects.isNull(aniaUrgeSet = this.aniaUrgeSetDao.findAllByAssistantCodeAndIamIdAndTenantId(userGlobalUrgeAndDetail.getAssistantCode(), userGlobalUrgeAndDetail.getIamId(), userGlobalUrgeAndDetail.getTenantId()))) {
            aniaUrgeSet = new AniaUrgeSet();
            BeanUtils.copyProperties((Object)userGlobalUrgeAndDetail, (Object)aniaUrgeSet);
            aniaUrgeSet.setCreateTime(new Date());
            aniaUrgeSet.setUpdateTime(new Date());
            aniaUrgeSet.setUrgeTypes(userGlobalUrgeAndDetail.getUrgeTypes());
            aniaUrgeSet.setUrgeWayShow(Integer.valueOf(this.getUrgeWayShow(aniaUrgeSet.getUrgeTypes())));
            this.aniaUrgeSetDao.insert((Object)aniaUrgeSet);
            return;
        }
        BeanUtils.copyProperties((Object)userGlobalUrgeAndDetail, (Object)aniaUrgeSet);
        aniaUrgeSet.setUrgeTypes(userGlobalUrgeAndDetail.getUrgeTypes());
        aniaUrgeSet.setUrgeWayShow(Integer.valueOf(this.getUrgeWayShow(aniaUrgeSet.getUrgeTypes())));
        aniaUrgeSet.setUpdateTime(new Date());
        this.aniaUrgeSetDao.save((Object)aniaUrgeSet);
    }

    private int getUrgeWayShow(List<JSONObject> urgeTypes) {
        HashMap<Integer, Integer> nums = new HashMap<Integer, Integer>();
        int onlYUrgeWay = 0;
        for (JSONObject jsonObject : urgeTypes) {
            Integer urgeWay = jsonObject.getInteger("urgeWay");
            if (nums.containsKey(urgeWay)) {
                nums.put(urgeWay, (Integer)nums.get(urgeWay) + 1);
                continue;
            }
            nums.put(urgeWay, 1);
            onlYUrgeWay = urgeWay;
        }
        if (nums.size() > 1) {
            return 3;
        }
        return onlYUrgeWay;
    }
}

