/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ChatGptConstants;
import com.digiwin.athena.ania.common.enums.ChatGptPromptEnum;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.validator.GenericValidator;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChatGptUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChatGptUtils.class);
    public static final String GPT_TEMPERATURE = "temperature";
    public static final String GPT_TOP = "top_p";
    public static final String GPT_METHOD = "method";
    public static final String GPT_PROMPT = "prompt";
    public static final String GPT_MAX_TOKENS = "max_tokens";
    public static final String GPT_PROMPT_ROLE = "role";
    public static final String GPT_PROMPT_ROLE_USER = "user";
    public static final String GPT_PROMPT_ROLE_SYSTEM = "system";
    public static final String GPT_PROMPT_ROLE_ASSISTANT = "assistant";
    public static final String GPT_PROMPT_CONTENT = "content";
    public static final String GPT_TIME_CHAR = "-";
    public static final String GPT_TIME_NULL = "null";
    private static final String[] weekDays = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
    private static final String[] weekDaysQiagong = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};

    private ChatGptUtils() {
    }

    public static JSONObject getRequestParam(Map<String, Object> gptInterface, Pair<String, List<Pair<String, String>>> promptStandardCases, String userParam, double temperature, double top, BasicNameValuePair ... nameValues) {
        String promptData = userParam;
        if (Objects.nonNull(nameValues) && Objects.nonNull(userParam)) {
            for (BasicNameValuePair nameValue : nameValues) {
                promptData = promptData.replace(nameValue.getName(), nameValue.getValue());
            }
        }
        JSONObject prompt = new JSONObject().fluentPut("temperature", (Object)temperature).fluentPut("top_p", (Object)top).fluentPut("prompt", (Object)ChatGptUtils.getPromptArray(promptStandardCases, (String)promptData));
        JSONObject requestData = new JSONObject();
        requestData.fluentPut("key", (Object)0);
        JSONObject data = new JSONObject().fluentPutAll(gptInterface);
        data.fluentPut("data", (Object)prompt);
        requestData.fluentPut("data", (Object)data);
        return requestData;
    }

    public static List<JSONObject> getPromptArray(String systemContent, String userContent) {
        ArrayList<JSONObject> promptArray = new ArrayList<JSONObject>();
        if (StringUtils.isNotBlank((CharSequence)systemContent)) {
            promptArray.add(ChatGptUtils.getSystemPrompt((String)systemContent));
        }
        if (StringUtils.isNotBlank((CharSequence)userContent)) {
            promptArray.add(ChatGptUtils.getUserPrompt((String)userContent));
        }
        return promptArray;
    }

    public static List<JSONObject> getPromptArray(Pair<String, List<Pair<String, String>>> promptStandardCases, String userContent) {
        return ChatGptUtils.getPromptArray((String)((String)promptStandardCases.getKey()), (List)((List)promptStandardCases.getValue()), (String)userContent);
    }

    private static JSONObject getSystemPrompt(String promptContent) {
        return new JSONObject().fluentPut("role", (Object)"system").fluentPut("content", (Object)promptContent);
    }

    private static JSONObject getUserPrompt(String promptContent) {
        return new JSONObject().fluentPut("role", (Object)"user").fluentPut("content", (Object)promptContent);
    }

    private static JSONObject getAssistantPrompt(String promptContent) {
        return new JSONObject().fluentPut("role", (Object)"assistant").fluentPut("content", (Object)promptContent);
    }

    public static Map<String, Object> getDateTimeRangeRule(String dateTimeStr) {
        return ChatGptUtils.getTimeRangeRule((String)dateTimeStr, (String)"yyyy/MM/dd HH:mm:ss");
    }

    public static Map<String, Object> getDateRangeRule(String dateStr) {
        return ChatGptUtils.getTimeRangeRule((String)dateStr, (String)"yyyy/MM/dd");
    }

    public static Map<String, Object> getTimeRangeRule(String dateStr, String datePattern) {
        if (StringUtils.isBlank((CharSequence)dateStr) || !dateStr.contains("-")) {
            return null;
        }
        try {
            String[] split = dateStr.split("\u3001");
            String[] ruleTime = split[0].split("-");
            if (ruleTime.length > 1) {
                LocalDateTime maxDataTime;
                LocalDateTime minDataTime;
                String max;
                String min = Objects.nonNull(ruleTime[0]) ? ruleTime[0].trim() : null;
                String string = max = Objects.nonNull(ruleTime[1]) ? ruleTime[1].trim() : null;
                if ("null".equals(min) && "null".equals(max)) {
                    return null;
                }
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(datePattern);
                if ("null".equals(min)) {
                    minDataTime = LocalDateTime.now();
                } else if (GenericValidator.isDate((String)min, (String)datePattern, (boolean)true)) {
                    minDataTime = LocalDateTime.parse(min, dateTimeFormatter);
                } else {
                    return null;
                }
                if ("null".equals(max)) {
                    maxDataTime = minDataTime.plusDays(365L);
                } else if (GenericValidator.isDate((String)max, (String)datePattern, (boolean)true)) {
                    maxDataTime = LocalDateTime.parse(max, dateTimeFormatter);
                } else {
                    return null;
                }
                if (minDataTime.isBefore(maxDataTime)) {
                    HashMap<String, Object> ruleData = new HashMap<String, Object>(2);
                    ruleData.put("min", minDataTime.format(dateTimeFormatter));
                    ruleData.put("max", maxDataTime.format(dateTimeFormatter));
                    return ruleData;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("ChatGptUtils.getTimeRangeRule is error dateStr:{},datePattern:{}", new Object[]{dateStr, datePattern, ex});
        }
        return null;
    }

    public static List<String> getDateData(String dateStr) {
        String convertData = ChatGptUtils.getConvertStr((String)dateStr, (Pattern)ChatGptConstants.BRACKETS_TARGET);
        if (StringUtils.isBlank((CharSequence)convertData)) {
            convertData = dateStr;
        }
        if (StringUtils.isBlank((CharSequence)convertData)) {
            return Collections.emptyList();
        }
        return Arrays.stream(convertData.split("\u3001")).filter(StringUtils::isNotBlank).map(String::trim).filter(item -> GenericValidator.isDate((String)item, (String)"yyyy/MM/dd", (boolean)true)).collect(Collectors.toList());
    }

    public static List<String> getDateTimeData(String dateTimeStr) {
        String convertData = ChatGptUtils.getConvertStr((String)dateTimeStr, (Pattern)ChatGptConstants.BRACKETS_TARGET);
        if (StringUtils.isBlank((CharSequence)convertData)) {
            convertData = dateTimeStr;
        }
        if (StringUtils.isBlank((CharSequence)convertData)) {
            return Collections.emptyList();
        }
        return Arrays.stream(convertData.split("\u3001")).filter(StringUtils::isNotBlank).map(String::trim).filter(item -> GenericValidator.isDate((String)item, (String)"yyyy/MM/dd HH:mm:ss", (boolean)true)).collect(Collectors.toList());
    }

    public static List<String> getTimeData(String timeStr) {
        String convertData = ChatGptUtils.getConvertStr((String)timeStr, (Pattern)ChatGptConstants.BRACKETS_TARGET);
        if (StringUtils.isBlank((CharSequence)convertData)) {
            convertData = timeStr;
        }
        if (StringUtils.isBlank((CharSequence)convertData)) {
            return Collections.emptyList();
        }
        return Arrays.stream(convertData.split("\u3001")).filter(StringUtils::isNotBlank).map(String::trim).filter(item -> GenericValidator.isDate((String)item, (String)"HH:mm", (boolean)true)).map(item -> item + ":00").collect(Collectors.toList());
    }

    public static List<String> getDateTimeRangeData(String dateTimeStr) {
        String convertData = ChatGptUtils.getConvertStr((String)dateTimeStr, (Pattern)ChatGptConstants.BRACKETS_TARGET);
        if (StringUtils.isBlank((CharSequence)convertData)) {
            convertData = dateTimeStr;
        }
        if (StringUtils.isBlank((CharSequence)convertData)) {
            return Collections.emptyList();
        }
        return Arrays.stream(convertData.split("\u3001")).map(timeStr -> ChatGptUtils.convertDateTimeRange((String)timeStr)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public static List<String> getPlaceData(String placeDataStr) {
        return ChatGptUtils.getOtherData((String)placeDataStr);
    }

    public static List<String> getOtherData(String otherDataStr) {
        String convertData = ChatGptUtils.convertCommonStr((String)otherDataStr);
        if (StringUtils.isBlank((CharSequence)convertData)) {
            return Collections.emptyList();
        }
        return Arrays.stream(convertData.split("\u3001")).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
    }

    public static String convertCommonStr(String dataStr) {
        if (StringUtils.isBlank((CharSequence)dataStr)) {
            return dataStr;
        }
        String dataTrim = dataStr.trim();
        String convertData = StrUtil.isWrap((CharSequence)dataTrim, (String)"{", (String)"}") ? ChatGptUtils.getConvertStr((String)dataTrim, (Pattern)ChatGptConstants.BRACKETS_TARGET) : (StrUtil.isWrap((CharSequence)dataTrim, (String)"[", (String)"]") ? ChatGptUtils.getConvertStr((String)dataTrim, (Pattern)ChatGptConstants.MIDDLE_BRACE_TARGET) : (StrUtil.isWrap((CharSequence)dataTrim, (String)"<", (String)">") ? ChatGptUtils.getConvertStr((String)dataTrim, (Pattern)ChatGptConstants.ANGLE_BRACE_TARGET) : dataStr));
        return StringUtils.isBlank((CharSequence)convertData) ? dataStr : convertData;
    }

    public static String convertDateTimeRange(String dateTimeStr) {
        if (StringUtils.isBlank((CharSequence)dateTimeStr) || !dateTimeStr.contains("-")) {
            return null;
        }
        String[] dateTimeRange = dateTimeStr.split("-");
        if (dateTimeRange.length == 2) {
            String startTimeStr = dateTimeRange[0].trim();
            String endTimeStr = dateTimeRange[1].trim();
            if (GenericValidator.isDate((String)startTimeStr, (String)"yyyy/MM/dd HH:mm:ss", (boolean)true) && GenericValidator.isDate((String)endTimeStr, (String)"yyyy/MM/dd HH:mm:ss", (boolean)true)) {
                return startTimeStr + "-" + endTimeStr;
            }
        }
        return null;
    }

    public static String getConvertStr(String data, Pattern pattern) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return data;
        }
        Matcher matcher = pattern.matcher(data);
        return matcher.find() ? matcher.group() : null;
    }

    public static String getWeekOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static String getWeekOfDateQiagong(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDaysQiagong[w];
    }

    public static List<String> getNames(String data, boolean distinctCode) {
        String charStr;
        String convertData = ChatGptUtils.getConvertStr((String)data, (Pattern)ChatGptConstants.ANGLE_BRACE_TARGET);
        if (StringUtils.isBlank((CharSequence)convertData)) {
            convertData = data;
        }
        if (StringUtils.isBlank((CharSequence)convertData)) {
            return Collections.emptyList();
        }
        String string = charStr = convertData.contains(",") ? "," : "\u3001";
        if (distinctCode) {
            return Arrays.stream(convertData.split(charStr)).filter(StringUtils::isNotBlank).map(name -> {
                int indexOf = name.indexOf(":");
                return indexOf > 0 ? name.substring(0, indexOf) : name;
            }).collect(Collectors.toList());
        }
        return Arrays.stream(convertData.split(charStr)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public static List<String> getDistinctNames(String data, boolean distinctCode) {
        List names = ChatGptUtils.getNames((String)data, (boolean)distinctCode);
        if (CollectionUtils.isNotEmpty((Collection)names)) {
            return names.stream().distinct().collect(Collectors.toList());
        }
        return names;
    }

    public static List<JSONObject> getPromptArray(String system, List<Pair<String, String>> standardCasesList, String userContent) {
        ArrayList<JSONObject> promptArray = new ArrayList<JSONObject>();
        if (StringUtils.isNotBlank((CharSequence)system)) {
            promptArray.add(ChatGptUtils.getSystemPrompt((String)system));
        }
        if (CollectionUtils.isNotEmpty(standardCasesList)) {
            for (Pair<String, String> standardCases : standardCasesList) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)standardCases.getKey())) || !StringUtils.isNotBlank((CharSequence)((CharSequence)standardCases.getValue()))) continue;
                promptArray.add(ChatGptUtils.getUserPrompt((String)((String)standardCases.getKey())));
                promptArray.add(ChatGptUtils.getAssistantPrompt((String)((String)standardCases.getValue())));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)userContent)) {
            promptArray.add(ChatGptUtils.getUserPrompt((String)userContent));
        }
        return promptArray;
    }

    public static List<JSONObject> get4oPromptArray(String system, String userContent, List<BasicNameValuePair> typeValues) {
        ArrayList<JSONObject> promptArray = new ArrayList<JSONObject>();
        if (StringUtils.isNotBlank((CharSequence)system)) {
            promptArray.add(ChatGptUtils.getSystemPrompt((String)system));
        }
        ArrayList<JSONObject> contentArray = new ArrayList<JSONObject>();
        if (StringUtils.isNotBlank((CharSequence)userContent)) {
            contentArray.add(new JSONObject().fluentPut("type", (Object)"text").fluentPut("text", (Object)userContent));
        }
        if (CollectionUtils.isNotEmpty(typeValues)) {
            for (BasicNameValuePair typeValue : typeValues) {
                if ("text".equals(typeValue.getName())) {
                    contentArray.add(new JSONObject().fluentPut("type", (Object)typeValue.getName()).fluentPut(typeValue.getName(), (Object)typeValue.getValue()));
                    continue;
                }
                if (!"image_url".equals(typeValue.getName())) continue;
                contentArray.add(new JSONObject().fluentPut("type", (Object)typeValue.getName()).fluentPut(typeValue.getName(), (Object)new JSONObject().fluentPut("url", (Object)typeValue.getValue())));
            }
        }
        if (CollectionUtils.isNotEmpty(contentArray)) {
            promptArray.add(new JSONObject().fluentPut("role", (Object)"user").fluentPut("content", contentArray));
        }
        return promptArray;
    }

    public static String replaceContent(String dataStr, List<BasicNameValuePair> nameValues) {
        if (StringUtils.isNotBlank((CharSequence)dataStr) && CollectionUtils.isNotEmpty(nameValues)) {
            String replaceDataStr = dataStr;
            for (BasicNameValuePair nameValue : nameValues) {
                replaceDataStr = replaceDataStr.replace(nameValue.getName(), nameValue.getValue());
            }
            return replaceDataStr;
        }
        return dataStr;
    }

    public static JSONObject buildRequestParam(ChatGptPromptEnum chatGptPrompt, List<JSONObject> promptArray) {
        JSONObject prompt = new JSONObject().fluentPut("temperature", (Object)chatGptPrompt.getTemperature()).fluentPut("top_p", (Object)chatGptPrompt.getTop()).fluentPut("prompt", promptArray);
        if (chatGptPrompt.getMaxTokens() != 0.0) {
            prompt.put("max_tokens", (Object)chatGptPrompt.getMaxTokens());
        }
        JSONObject requestData = new JSONObject();
        requestData.fluentPut("key", (Object)0);
        JSONObject data = new JSONObject().fluentPutAll(chatGptPrompt.getGptInterface());
        if (chatGptPrompt.isAsynchronous()) {
            data.put("timeout", (Object)100);
        }
        data.fluentPut("data", (Object)prompt);
        requestData.fluentPut("data", (Object)data);
        return requestData;
    }

    public static List<String> splicingWithDoubleQuotes(List<BasicNameValuePair> dataList) {
        ArrayList<String> splicingWithDoubleQuotes = new ArrayList<String>();
        for (BasicNameValuePair data : dataList) {
            splicingWithDoubleQuotes.add("\"" + data.getName() + "\"" + "\uff1a" + "\"" + data.getValue() + "\"");
        }
        return splicingWithDoubleQuotes;
    }
}

