/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.intentflow.dto.IntentFlowEventData;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.knowledge.server.dto.sse.EventMessageData;
import com.digiwin.athena.ania.knowledge.server.dto.sse.StreamEventData;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.EventMessageUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventMessageUtils {
    private static final Logger log = LoggerFactory.getLogger(EventMessageUtils.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(EventMessageUtils.class);

    private EventMessageUtils() {
    }

    public static String buildAnswerContent(List<EventData.EventMessage> eventMessageList) {
        try {
            HashMap<String, Object> content = new HashMap<String, Object>(2);
            if (CollectionUtils.isNotEmpty(eventMessageList)) {
                List card;
                String text = eventMessageList.stream().filter(eventMessage -> eventMessage.getType().equals(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType()) && eventMessage.getMessage_type().equals(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType())).map(EventData.EventMessage::getMessage).collect(Collectors.joining());
                if (StrUtil.isNotBlank((CharSequence)text)) {
                    content.put("text", text);
                }
                if (CollUtil.isNotEmpty(card = eventMessageList.stream().filter(eventMessage -> eventMessage.getType().equals(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType()) && eventMessage.getMessage_type().equals(SseEventlEnum.EventDataMessageEnum.CARD.getMessageType())).map(eventMessage -> JSON.parseObject((String)eventMessage.getMessage())).collect(Collectors.toList()))) {
                    content.put("card", card);
                }
            }
            if (MapUtils.isNotEmpty(content)) {
                return BaseUseUtils.toJsonString(content);
            }
        }
        catch (Exception e) {
            LOGGER.error("EventMessageUtils.buildAnswerContent is error eventMessageList:{}", (Object)BaseUseUtils.toJsonString(eventMessageList), (Object)e);
        }
        return "";
    }

    public static Map<String, Object> buildFunctionInfo(List<EventData.EventMessage> functionList) {
        try {
            if (CollUtil.isNotEmpty(functionList)) {
                List functionCalls = functionList.stream().filter(eventMessage -> eventMessage.getType().equals(SseEventlEnum.SseEventDataTypeEnum.FUNCTION_CALL.getType())).collect(Collectors.toList());
                Map<String, List<EventData.EventMessage>> functionAnswers = functionList.stream().filter(eventMessage -> eventMessage.getType().equals(SseEventlEnum.SseEventDataTypeEnum.FUNCTION_ANSWER.getType())).collect(Collectors.groupingBy(eventMessage -> {
                    IntentFlowEventData.IntentEventMessage functionMessage = (IntentFlowEventData.IntentEventMessage)eventMessage;
                    return functionMessage.getExtra_info().getString("call_id");
                }));
                Map response = functionList.stream().filter(eventMessage -> eventMessage.getType().equals(SseEventlEnum.SseEventDataTypeEnum.TOOL_RESPONSE.getType())).collect(Collectors.toMap(eventMessage -> {
                    IntentFlowEventData.IntentEventMessage functionMessage = (IntentFlowEventData.IntentEventMessage)eventMessage;
                    return functionMessage.getExtra_info().getString("call_id");
                }, Function.identity(), (key1, key2) -> key2));
                if (CollectionUtils.isNotEmpty(functionCalls)) {
                    List functionData = functionCalls.stream().map(functionCall -> {
                        IntentFlowEventData.IntentEventMessage functionMessage = (IntentFlowEventData.IntentEventMessage)functionCall;
                        String callId = functionMessage.getExtra_info().getString("call_id");
                        JSONObject functionContent = JSONObject.parseObject((String)functionMessage.getMessage());
                        List functionAnswer = (List)functionAnswers.get(callId);
                        if (CollectionUtils.isNotEmpty((Collection)functionAnswer)) {
                            String text = functionAnswer.stream().filter(eventMessage -> "text".equals(eventMessage.getMessage_type())).map(EventData.EventMessage::getMessage).collect(Collectors.joining());
                            functionContent.put("text", (Object)text);
                        }
                        String status = "fail";
                        EventData.EventMessage toolResponse = (EventData.EventMessage)response.get(callId);
                        if (Objects.nonNull(toolResponse)) {
                            status = ((IntentFlowEventData.IntentEventMessage)toolResponse).getStatus();
                        }
                        functionContent.put("status", (Object)status);
                        return functionContent;
                    }).collect(Collectors.toList());
                    HashMap function = new HashMap(1);
                    function.put("tool", functionData);
                    HashMap<String, Object> head = new HashMap<String, Object>(2);
                    head.put("type", "function");
                    head.put("info", function);
                    return head;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("EventMessageUtils.buildFunctionInfo is error eventMessageList:{}", (Object)BaseUseUtils.toJsonString(functionList), (Object)e);
        }
        return null;
    }

    public static String buildHeadInfoContent(List<EventData.EventMessage> functionList) {
        Map functionInfo;
        ArrayList<Map> headInfo = new ArrayList<Map>();
        if (CollectionUtils.isNotEmpty(functionList) && MapUtils.isNotEmpty((Map)(functionInfo = EventMessageUtils.buildFunctionInfo(functionList)))) {
            headInfo.add(functionInfo);
        }
        return BaseUseUtils.toJsonString(headInfo);
    }

    public static List<Map> buildContent(List<EventData.EventMessage> eventMessageList) {
        ArrayList<Map> contentList = new ArrayList<Map>();
        try {
            if (CollectionUtils.isNotEmpty(eventMessageList)) {
                List<JSONObject> card;
                String text = eventMessageList.stream().filter(eventMessage -> eventMessage.getType().equals(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType()) && eventMessage.getMessage_type().equals(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType())).map(EventData.EventMessage::getMessage).collect(Collectors.joining());
                if (StrUtil.isNotBlank((CharSequence)text)) {
                    HashMap<String, String> textContent = new HashMap<String, String>(2);
                    textContent.put("type", SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType());
                    textContent.put(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), text);
                    contentList.add(textContent);
                }
                if (CollUtil.isNotEmpty(card = eventMessageList.stream().filter(eventMessage -> eventMessage.getType().equals(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType()) && eventMessage.getMessage_type().equals(SseEventlEnum.EventDataMessageEnum.CARD.getMessageType())).map(eventMessage -> JSON.parseObject((String)eventMessage.getMessage())).collect(Collectors.toList()))) {
                    card.forEach(item -> {
                        HashMap<String, String> cardContent = new HashMap<String, String>(2);
                        cardContent.put("type", SseEventlEnum.EventDataMessageEnum.CARD.getMessageType());
                        cardContent.put("content", (String)item);
                        contentList.add(cardContent);
                    });
                }
            }
            return contentList;
        }
        catch (Exception e) {
            LOGGER.error("EventMessageUtils.buildAnswerContent is error eventMessageList:{}", (Object)BaseUseUtils.toJsonString(eventMessageList), (Object)e);
            return contentList;
        }
    }

    public static List<Map> buildHeadInfo(List<EventData.EventMessage> functionList) {
        try {
            if (CollectionUtils.isEmpty(functionList)) {
                return Collections.emptyList();
            }
            List functionCalls = functionList.stream().filter(eventMessage -> eventMessage.getType().equals(SseEventlEnum.SseEventDataTypeEnum.FUNCTION_CALL.getType())).collect(Collectors.toList());
            Map<String, List<EventData.EventMessage>> functionAnswers = functionList.stream().filter(eventMessage -> eventMessage.getType().equals(SseEventlEnum.SseEventDataTypeEnum.FUNCTION_ANSWER.getType())).collect(Collectors.groupingBy(eventMessage -> {
                IntentFlowEventData.IntentEventMessage functionMessage = (IntentFlowEventData.IntentEventMessage)eventMessage;
                return functionMessage.getExtra_info().getString("call_id");
            }));
            Map response = functionList.stream().filter(eventMessage -> eventMessage.getType().equals(SseEventlEnum.SseEventDataTypeEnum.TOOL_RESPONSE.getType())).collect(Collectors.toMap(eventMessage -> {
                IntentFlowEventData.IntentEventMessage functionMessage = (IntentFlowEventData.IntentEventMessage)eventMessage;
                return functionMessage.getExtra_info().getString("call_id");
            }, Function.identity(), (key1, key2) -> key2));
            if (CollectionUtils.isNotEmpty(functionCalls)) {
                return functionCalls.stream().map(functionCall -> {
                    IntentFlowEventData.IntentEventMessage functionMessage = (IntentFlowEventData.IntentEventMessage)functionCall;
                    String callId = functionMessage.getExtra_info().getString("call_id");
                    HashMap<String, String> functionInfo = new HashMap<String, String>();
                    JSONObject functionContent = JSONObject.parseObject((String)functionMessage.getMessage());
                    List functionAnswer = (List)functionAnswers.get(callId);
                    if (CollectionUtils.isNotEmpty((Collection)functionAnswer)) {
                        String text = functionAnswer.stream().filter(eventMessage -> "text".equals(eventMessage.getMessage_type())).map(EventData.EventMessage::getMessage).collect(Collectors.joining());
                        functionInfo.put("text", text);
                    }
                    String name = functionContent.getString("name");
                    functionInfo.put("title", name);
                    String status = "fail";
                    EventData.EventMessage toolResponse = (EventData.EventMessage)response.get(callId);
                    if (Objects.nonNull(toolResponse)) {
                        status = ((IntentFlowEventData.IntentEventMessage)toolResponse).getStatus();
                    }
                    functionInfo.put("status", status);
                    return functionInfo;
                }).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            LOGGER.error("EventMessageUtils.buildFunctionInfo is error eventMessageList:{}", (Object)BaseUseUtils.toJsonString(functionList), (Object)e);
        }
        return Collections.emptyList();
    }

    public static List<Map> buildFileReferences(JSONArray referencedAttachments) {
        try {
            if (CollectionUtils.isNotEmpty((Collection)referencedAttachments)) {
                ArrayList<Map> fileFollowUp = new ArrayList<Map>();
                for (int i = 0; i < referencedAttachments.size(); ++i) {
                    JSONObject attachment = referencedAttachments.getJSONObject(i);
                    attachment.put("fileId", (Object)attachment.getString("no"));
                    attachment.put("fileName", (Object)attachment.getString("name"));
                    attachment.put("fileType", (Object)attachment.getString("type"));
                    attachment.put("type", (Object)"file");
                    fileFollowUp.add((Map)attachment);
                }
                return fileFollowUp;
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            LOGGER.error("EventMessageUtils.buildFollowUp is error referencedAttachments:{}", (Object)BaseUseUtils.toJsonString((Object)referencedAttachments), (Object)e);
            return Collections.emptyList();
        }
    }

    public static void buildStreamContent(ConversationMessage answerMessage, AsaKnowledgeMessage asaKnowledgeMessage) {
        try {
            if (Objects.nonNull(answerMessage) && Objects.nonNull(asaKnowledgeMessage)) {
                List fileFollowUp;
                List content;
                List headInfo;
                ArrayList<EventData.EventMessage> answerMessages = new ArrayList<EventData.EventMessage>();
                if (StrUtil.isNotBlank((CharSequence)asaKnowledgeMessage.getMsg())) {
                    answerMessages.add(new EventData.EventMessage(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), asaKnowledgeMessage.getMsg()));
                }
                if (CollUtil.isNotEmpty((Collection)asaKnowledgeMessage.getCardList())) {
                    answerMessages.addAll(asaKnowledgeMessage.getCardList());
                }
                if (CollectionUtils.isNotEmpty((Collection)(headInfo = EventMessageUtils.buildHeadInfo((List)asaKnowledgeMessage.getFunctionList())))) {
                    answerMessage.setHeaderInfos(headInfo);
                }
                if (CollectionUtils.isNotEmpty((Collection)(content = EventMessageUtils.buildContent(answerMessages)))) {
                    answerMessage.setContent(content);
                }
                if (CollectionUtils.isNotEmpty((Collection)(fileFollowUp = EventMessageUtils.buildFileReferences((JSONArray)asaKnowledgeMessage.getReferencedAttachments())))) {
                    HashMap<String, List> ext = answerMessage.getExt();
                    if (Objects.isNull(ext)) {
                        ext = new HashMap<String, List>(1);
                    }
                    ext.put("searchReferences", fileFollowUp);
                    answerMessage.setExt(ext);
                    answerMessage.setMsgExt(JSONUtil.toJsonStr(ext));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("EventMessageUtils.buildStreamContent is error referencedAttachments:{}", (Object)BaseUseUtils.toJsonString((Object)asaKnowledgeMessage), (Object)e);
        }
    }

    public static void buildStreamContent(ConversationMessage answerMessage, List<EventData> answers) {
        if (Objects.nonNull(answerMessage) && CollectionUtils.isNotEmpty(answers)) {
            Triple groupEventData = SseEventContext.groupEventData(answers);
            List contentData = (List)groupEventData.getLeft();
            List headData = (List)groupEventData.getMiddle();
            List followData = (List)groupEventData.getRight();
            List headInfo = EventMessageUtils.generateHeadInfo((List)headData);
            List content = SseEventContext.buildContent((List)contentData);
            if (CollectionUtils.isNotEmpty((Collection)headInfo)) {
                answerMessage.setHeaderInfos(headInfo);
            }
            if (CollectionUtils.isNotEmpty((Collection)content)) {
                answerMessage.setContent(content);
            } else if (CollectionUtils.isEmpty((Collection)answerMessage.getHeaderInfos())) {
                HashMap<String, String> text = new HashMap<String, String>();
                text.put("type", SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType());
                text.put(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), "Abnormal Termination");
                answerMessage.setContent((List)Lists.newArrayList((Object[])new Map[]{text}));
            }
            List followUp = EventMessageUtils.generateFollowUp((List)followData);
            if (CollectionUtils.isNotEmpty((Collection)followUp)) {
                answerMessage.setFollowUp(followUp);
            }
        }
    }

    public static List<Map> generateHeadInfo(List<EventData> functionList) {
        if (CollectionUtils.isEmpty(functionList)) {
            return null;
        }
        LinkedList<JSONObject> functionAnswer = new LinkedList<JSONObject>();
        LinkedHashMap headInfo = new LinkedHashMap();
        for (EventData event : functionList) {
            String callId;
            JSONObject message;
            if (SseEventlEnum.SseEventDataTypeEnum.FUNCTION_CALL.getType().equals(event.getData().getType())) {
                try {
                    message = JSON.parseObject((String)event.getData().getEventData().getMessage().getContent());
                    String title = MapUtils.getString((Map)message, (Object)"title", (String)"");
                    if (!StringUtils.isNotBlank((CharSequence)title)) continue;
                    callId = MapUtils.getString((Map)message.getJSONObject("extra_info"), (Object)"call_id");
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("type", "function");
                    info.put("title", title);
                    info.put("status", "fail");
                    headInfo.put(callId, info);
                }
                catch (Exception e) {
                    log.error("generateHeadInfo function_call is error message:{}", (Object)BaseUseUtils.toJsonString((Object)event.getData()), (Object)e);
                }
                continue;
            }
            if (SseEventlEnum.SseEventDataTypeEnum.TOOL_RESPONSE.getType().equals(event.getData().getType())) {
                try {
                    Map map;
                    message = JSON.parseObject((String)event.getData().getEventData().getMessage().getContent());
                    String status = message.getString("status");
                    if (!StringUtils.isNotBlank((CharSequence)status) || !Objects.nonNull(map = (Map)headInfo.get(callId = MapUtils.getString((Map)message.getJSONObject("extra_info"), (Object)"call_id")))) continue;
                    map.put("status", status);
                }
                catch (Exception e) {
                    log.error("generateHeadInfo tool_response is error message:{}", (Object)BaseUseUtils.toJsonString((Object)event.getData()), (Object)e);
                }
                continue;
            }
            if (!SseEventlEnum.SseEventDataTypeEnum.FUNCTION_ANSWER.getType().equals(event.getData().getType())) continue;
            try {
                functionAnswer.add(JSON.parseObject((String)event.getData().getEventData().getMessage().getContent()));
            }
            catch (Exception e) {
                log.error("generateHeadInfo function_answer is error message:{}", (Object)BaseUseUtils.toJsonString((Object)event.getData()), (Object)e);
            }
        }
        if (MapUtils.isNotEmpty(headInfo)) {
            if (CollectionUtils.isNotEmpty(functionAnswer)) {
                functionAnswer.stream().forEach(item -> {
                    Map map;
                    String callId = MapUtils.getString((Map)item.getJSONObject("extra_info"), (Object)"call_id");
                    String text = MapUtils.getString((Map)item, (Object)"content");
                    if (Objects.nonNull(text) && StringUtils.isNotBlank((CharSequence)callId) && Objects.nonNull(map = (Map)headInfo.get(callId))) {
                        String old = MapUtils.getString((Map)map, (Object)"text", (String)"");
                        map.put("text", old + text);
                    }
                });
            }
            return new ArrayList<Map>(headInfo.values());
        }
        return Collections.emptyList();
    }

    public static List<Map> generateFollowUp(List<EventData> followData) {
        ArrayList<Map> followUps = new ArrayList<Map>();
        if (CollectionUtils.isNotEmpty(followData)) {
            followData.forEach(item -> {
                try {
                    JSONArray objects = JSON.parseArray((String)item.getData().getMessage());
                    if (CollectionUtils.isNotEmpty((Collection)objects)) {
                        for (int i = 0; i < objects.size(); ++i) {
                            followUps.add(new HashMap(objects.getJSONObject(i)));
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return followUps;
    }

    public static void buildMessage(SseEventParams sseEventParam, EventData eventData) {
        ConversationMessage questionMessage = sseEventParam.getQuestionMessage();
        if (SseEventlEnum.CHAT_CREATED.getEvent().equals(eventData.getEvent())) {
            EventData.EventMessage eventMessage = EventData.EventMessage.builder().messageId(questionMessage.getMessageId()).messageIndex(questionMessage.getIndex()).localMessageId(questionMessage.getLocalMessageId()).conversationId(questionMessage.getConversationId()).build();
            StreamEventData event = StreamEventData.builder().messageId(questionMessage.getMessageId()).messageIndex(questionMessage.getIndex()).localMessageId(questionMessage.getLocalMessageId()).conversationId(questionMessage.getConversationId()).build();
            eventMessage.setEventData(event);
            eventData.setData(eventMessage);
        } else if (Objects.nonNull(eventData.getData())) {
            eventData.getData().setMessageId(sseEventParam.getAnswerMessageId());
            eventData.getData().setMessageIndex(sseEventParam.getAnswerMessageIndex());
            eventData.getData().setLocalMessageId(questionMessage.getLocalMessageId());
            eventData.getData().setConversationId(questionMessage.getConversationId());
            if (Objects.isNull(eventData.getData().getEventData())) {
                EventMessageUtils.buildStreamEventData((EventData.EventMessage)eventData.getData());
            }
        }
    }

    private static void buildStreamEventData(EventData.EventMessage message) {
        StreamEventData event = StreamEventData.builder().messageId(message.getMessageId()).messageIndex(message.getMessageIndex()).localMessageId(message.getLocalMessageId()).conversationId(message.getConversationId()).build();
        SseEventlEnum.SseEventDataTypeEnum eventDataType = SseEventlEnum.SseEventDataTypeEnum.getEventDataType((String)message.getType());
        if (Objects.nonNull(eventDataType)) {
            switch (1.$SwitchMap$com$digiwin$athena$ania$common$enums$SseEventlEnum$SseEventDataTypeEnum[eventDataType.ordinal()]) {
                case 1: {
                    if (message instanceof IntentFlowEventData.IntentEventMessage) {
                        IntentFlowEventData.IntentEventMessage intentEventMessage = (IntentFlowEventData.IntentEventMessage)message;
                        JSONObject extraInfo = intentEventMessage.getExtra_info();
                        JSONObject content = new JSONObject();
                        content.fluentPut("extra_info", (Object)extraInfo);
                        String name = "";
                        if (Objects.nonNull(message.getMessage())) {
                            JSONObject jsonObject = JSON.parseObject((String)message.getMessage());
                            name = MapUtils.getString((Map)jsonObject, (Object)"name", (String)"....");
                        }
                        content.fluentPut("title", (Object)name);
                        content.fluentPut("content", (Object)message.getMessage());
                        event.setMessage(new EventMessageData(SseEventlEnum.EventDataMessageEnum.TEXT, content.toJSONString(), null, null));
                        break;
                    }
                    event.setMessage(new EventMessageData(SseEventlEnum.EventDataMessageEnum.TEXT, message.getMessage(), null, null));
                    break;
                }
                case 2: {
                    JSONObject extraInfo;
                    IntentFlowEventData.IntentEventMessage intentEventMessage;
                    if (message instanceof IntentFlowEventData.IntentEventMessage) {
                        intentEventMessage = (IntentFlowEventData.IntentEventMessage)message;
                        extraInfo = intentEventMessage.getExtra_info();
                        String status = intentEventMessage.getStatus();
                        JSONObject content = new JSONObject();
                        content.fluentPut("extra_info", (Object)extraInfo);
                        content.fluentPut("status", (Object)status);
                        event.setMessage(new EventMessageData(SseEventlEnum.EventDataMessageEnum.TEXT, content.toJSONString(), null, null));
                    } else {
                        event.setMessage(new EventMessageData(SseEventlEnum.EventDataMessageEnum.TEXT, message.getMessage(), null, null));
                    }
                }
                case 3: {
                    JSONObject extraInfo;
                    IntentFlowEventData.IntentEventMessage intentEventMessage;
                    if (message instanceof IntentFlowEventData.IntentEventMessage) {
                        intentEventMessage = (IntentFlowEventData.IntentEventMessage)message;
                        extraInfo = intentEventMessage.getExtra_info();
                        JSONObject content = new JSONObject();
                        content.fluentPut("extra_info", (Object)extraInfo);
                        content.fluentPut("content", (Object)message.getMessage());
                        event.setMessage(new EventMessageData(SseEventlEnum.EventDataMessageEnum.TEXT, content.toJSONString(), message.getMessage(), null));
                        break;
                    }
                    event.setMessage(new EventMessageData(SseEventlEnum.EventDataMessageEnum.TEXT, message.getMessage(), null, null));
                    break;
                }
                case 4: {
                    String messageType = message.getMessage_type();
                    String content = message.getMessage();
                    String text = null;
                    if (SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType().equals(messageType)) {
                        text = message.getMessage();
                        content = new JSONObject().fluentPut("text", (Object)content).toJSONString();
                    }
                    event.setMessage(new EventMessageData(messageType, content, text, null));
                }
            }
        }
        message.setEventData(event);
    }
}

