package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtSchemaConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 更新API的创建人信息
 * /restful/standard/apimgmt/ApiBuilder/Update
 */
@Slf4j
@Service
public class ApiBuilderUpdateService extends AbstractApiService {

	@Autowired
	private ApiMgmtStandardApiVersionDao standardApiVersionDao;

	public ApiBuilderUpdateService() {
		super();
		jsonSchemaFileName = ApimgmtSchemaConstant.API_BUILDER_UPDATE_SCHEMA;
	}

	/**
	 * 更新API的创建人信息
	 * @param validatorResult validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		String tenantId = "";
		String apiBuildAcct = tRequestJsonNode.get(ApimgmtConstant.API_BUILD_ACCT).asText();
		String apiBuildName = tRequestJsonNode.get(ApimgmtConstant.API_BUILD_NAME).asText();
		Map<String, String> tConditionMap = new HashMap<>();
		// 通过api名称+租户获取对应的版本
		tConditionMap.put(ApimgmtConstant.API_NAME, tRequestJsonNode.get(ApimgmtConstant.API_NAME).asText());
		tConditionMap.put(ApimgmtConstant.VERSION, tRequestJsonNode.get(ApimgmtConstant.API_VERSION).asText());
		if (tRequestJsonNode.get(ApimgmtConstant.TENANT_ID) != null) {
			tenantId = tRequestJsonNode.get(ApimgmtConstant.TENANT_ID).asText();
		}
		tConditionMap.put(ApimgmtConstant.TENANT_ID, tenantId);
		StandardApiVersion tStandardApiVersion = standardApiVersionDao.fetchApiVersion(tConditionMap);
		if (null != tStandardApiVersion) {
			tStandardApiVersion.setApprovedAcct(apiBuildAcct);
			tStandardApiVersion.setApplicant(apiBuildName);
			tStandardApiVersion.setUserId(apiBuildAcct);
			standardApiVersionDao.saveOrupdate(tStandardApiVersion);
		}
		Map<String, Object> tResponse = new HashMap<>();
		StateCode tStateCode = getStateCode(ValidateStateEnum.SUCCESS.getCode());
		tResponse.put(ApimgmtConstant.CODE, tStateCode.getCode());
		tResponse.put(ApimgmtConstant.DESCRIPTION, tStateCode.getDescription());
		return tResponse;
	}
}
