package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 取得API清單    标准API查询使用
 * /restful/standard/apimgmt/ApiList/Get
 */
@Slf4j
@Service
@Deprecated
public class ApiListGetService {


	@Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

	@Autowired
    ApiMgmtTenantConfigDao tenantConfigDao;

	public ApiListGetService() {
		super();
	}

	public ArrayList<Map<String, Object>> execute(String validatorResult) throws Exception {
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口：" + this.getClass() + "，原始訊息：" + validatorResult);
		// 取得語系
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
		// header沒傳語系的話，默認回傳英文
		tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
        String teamType = ApiMgmtServiceContextHolder.getTeamType();
		ArrayList<Map<String, Object>> tResponse = new ArrayList<>();
		JsonNode tRequestJsonNode = JsonLoader.fromString(validatorResult);
		String tReqCategory = tRequestJsonNode.get(ApimgmtConstant.CATEGORY_ID).asText();
		// 判斷租戶是否可查看全部API
		boolean tViewAllApi = tenantConfigDao.viewAllApiTenantExist(tTenantId);
		// by songwq 查询时新增teamId 1位鼎捷内部  2/3外部
		List<StandardApiVersion> tStandardApiVersionList = standardApiVersionDao.getByCategory(Long.valueOf(tReqCategory), tTenantId, teamType, tViewAllApi);
		Map<String, List<StandardApiVersion>> tApiVersionMap = new HashMap<>();
		for(StandardApiVersion tStandardApiVersion : tStandardApiVersionList){
			// by wqsong 根据apiId和api名称确认是否为同一个api
			StandardApi api = tStandardApiVersion.getStandardApi();
			String tApiKey = api.getId() +  "_" + api.getName();
			if(tApiVersionMap.get(tApiKey) == null){
				List<StandardApiVersion> tStandardApiVersionFromApiName = new ArrayList<>();
				tStandardApiVersionFromApiName.add(tStandardApiVersion);
				tApiVersionMap.put(tApiKey, tStandardApiVersionFromApiName);
			}else{
				tApiVersionMap.get(tApiKey).add(tStandardApiVersion);
			}
		}
		for(String tKey : tApiVersionMap.keySet()){
			// by songwq 20230625 获取首次申请的版本以及最新的版本
			List<StandardApiVersion> pStandardApiVersions = tApiVersionMap.get(tKey);
			StandardApiVersion firstStandardApiVersion = ApiVersionServiceUtil.getFirstVersion(pStandardApiVersions);
			StandardApiVersion tStandardApiVersion = ApiVersionServiceUtil.getLatestVersion(pStandardApiVersions);
			StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
			Map<String, Object> tApiMap = new HashMap<>();
			String tApprovedStatus;
			String tDescription;
			String tRemark;
			String tSyncType;
			String tCategory;
			switch (tLocale) {
			case ApimgmtConstant.ZH_CN:
				tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhCn();
				tDescription = tStandardApi.getDescriptionZhCn();
				tRemark = tStandardApi.getRemarkZhCn();
				tSyncType = tStandardApi.getStandardApiSyncType().getNameZhCn();
				tCategory = tStandardApi.getStandardApiCategory().getNameZhCn();
				break;
			case ApimgmtConstant.ZH_TW:
				tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhTw();
				tDescription = tStandardApi.getDescriptionZhTw();
				tRemark = tStandardApi.getRemarkZhTw();
				tSyncType = tStandardApi.getStandardApiSyncType().getNameZhTw();
				tCategory = tStandardApi.getStandardApiCategory().getNameZhTw();
				break;
			case ApimgmtConstant.EN_US:
			default:
				tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameEnUs();
				tDescription = tStandardApi.getDescriptionEnUs();
				tRemark = tStandardApi.getRemarkEnUs();
				tSyncType = tStandardApi.getStandardApiSyncType().getNameEnUs();
				tCategory = tStandardApi.getStandardApiCategory().getNameEnUs();
				break;
			}
			//組成回傳訊息
			tApiMap.put(ApimgmtConstant.API_ID, tStandardApi.getId());
			tApiMap.put(ApimgmtConstant.NAME, tStandardApi.getName());
			tApiMap.put(ApimgmtConstant.VERSION, tStandardApiVersion.getVersion());
			tApiMap.put(ApimgmtConstant.APPROVED_STATUS, tApprovedStatus);
            tApiMap.put(ApiAttributeEnum.approvedTime.toString(), DateUtil.formatLocalDateTime(tStandardApiVersion.getApprovedTime()));
			tApiMap.put(ApimgmtConstant.DESCRIPTION, tDescription);
			tApiMap.put(ApimgmtConstant.REMARK, tRemark);
			tApiMap.put(ApimgmtConstant.SYNC_TYPE, tSyncType);
			tApiMap.put(ApimgmtConstant.CATEGORY_ID, tStandardApi.getStandardApiCategory().getId());
			tApiMap.put(ApimgmtConstant.CATEGORY_NAME, tCategory);
			tApiMap.put(ApimgmtConstant.MSG_FORMAT, tStandardApi.getMsgFormat());
			tApiMap.put(ApimgmtConstant.PROVIDER, tStandardApi.getProvider());
			tApiMap.put(ApimgmtConstant.TENANT_ID, tStandardApi.getTenantId());
			// by songwq 20230625 获取首次申请的版本以及最新的版本以及设计租户ID
			String firstV = firstStandardApiVersion.getVersion();
			String lastV = tStandardApiVersion.getVersion();
			tApiMap.put(ApimgmtConstant.FIRST_APPLICANT, firstStandardApiVersion.getApplicant());
			// 如果首次与最后一次版本号相同，则无最后一次申请人
			if (firstV.equals(lastV)) {
				tApiMap.put(ApimgmtConstant.LAST_APPLICANT, "");
			} else {
				tApiMap.put(ApimgmtConstant.LAST_APPLICANT, tStandardApiVersion.getApplicant());
			}
			tApiMap.put(ApimgmtConstant.DESIGN_TENANT_ID, tStandardApiVersion.getStandardApi().getDesignTenantId());
			tApiMap.put(ApimgmtConstant.TEAM_ID, tStandardApiVersion.getStandardApi().getTeamId());
			tResponse.add(tApiMap);
		}
		return tResponse;
	}
}
