package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtSchemaConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dto.ApiParamTextReqDto;
import com.digiwin.athena.apimgmt.dto.ApiParamTextResDto;
import com.digiwin.athena.apimgmt.enums.*;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.service.util.DmcFileServiceUtil;
import com.digiwin.athena.apimgmt.service.util.MessageSampleServiceUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * 取得API详情規格檔(txt形式)
 * /restful/standard/apimgmt/MessageExampleFile/Get
 */
@Slf4j
@Service
public class ApiMessageExampleFileGetService extends AbstractApiService {

    @Autowired
    ApiMgmtStandardApiDao standardApiDao;

    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

    @Autowired
    ApiMgmtStandardApiDataNameDao standardApiDataNameDao;
    @Autowired
    private ApiParamTextService apiParamTextService;

    public ApiMessageExampleFileGetService() {
        super();
        jsonSchemaFileName = ApimgmtSchemaConstant.API_MESSAGE_EXAMPLE_FILE_GET_SCHEMA;
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException {
        // request
        JsonNode tRequestNode = validatorResult.getJsonContent();
        // response
        ObjectNode tResponseNode = mapper.createObjectNode();
        // 取得語系
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        // header沒傳語系的話，默認回傳英文
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        // 取得入參
        String tApiName = tRequestNode.get(ApiAttributeEnum.apiName.toString()).asText();
        // branch
        String branch = ApimgmtConstant.DEFAULT_BRANCH;
        String tServiceProduct = tRequestNode.get(ApiAttributeEnum.serviceProduct.toString()).asText();
        String tHostProduct = tRequestNode.get(ApiAttributeEnum.hostProduct.toString()).asText();
        String tMsgFormat = tRequestNode.get(ApiAttributeEnum.msgFormat.toString()).asText();
        String tDevelopRole = tRequestNode.get(ApiAttributeEnum.developRole.toString()).asText();
        String tMessageType = tRequestNode.get(ApiAttributeEnum.messageType.toString()).asText();
        String tTenant = "";
        if (tRequestNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
            tTenant = tRequestNode.get(ApiAttributeEnum.tenantId.toString()).asText();
        }
        String tVersion = null;
        if (tRequestNode.get(ApiAttributeEnum.apiVersion.toString()) != null) {
            tVersion = tRequestNode.get(ApiAttributeEnum.apiVersion.toString()).asText();
            // branch
            branch = ApiVersionServiceUtil.getBranchFromVersion(tVersion);
        }

        // 取得api的所有版本號
        List<StandardApiVersion> tStandardApiVersionList = standardApiVersionDao.fetchApiVersionsByName(tApiName, branch, tTenant);
        StandardApiVersion tTargetApiVersion = null;
        for (StandardApiVersion tStandardApiVersion : tStandardApiVersionList) {
            // 取得對應版本號
            if (tStandardApiVersion.getVersion().equals(tVersion)) {
                tTargetApiVersion = tStandardApiVersion;

                StandardApi standardApi = tTargetApiVersion.getStandardApi();
                if (standardApi.getTextId() != null) {
                    ApiParamTextResDto apiParamText = apiParamTextService.getApiParamText(standardApi.getTextId());
                    ApiParamTextReqDto apiParamTextReqDto = new ApiParamTextReqDto();
                    apiParamTextReqDto.setRequestText(apiParamText.getRequestText());
                    apiParamTextReqDto.setResponseText(apiParamText.getResponseText());

                    standardApi.setApiParamText(apiParamTextReqDto);

                    String allParamText = "";
                    JSONObject responseText = apiParamText.getResponseText();
                    JSONObject requestText = apiParamText.getRequestText();
                    if (responseText != null) {
                        for (Map.Entry<String, Object> entry : responseText.entrySet()) {
                            JSONObject value = (JSONObject) entry.getValue();
                            for (Map.Entry<String, Object> formatEntry : value.entrySet()) {
                                allParamText += formatEntry.getValue();
                            }
                        }
                    }
                    if ( requestText != null) {
                        for (Map.Entry<String, Object> entry : requestText.entrySet()) {
                            JSONObject value = (JSONObject) entry.getValue();
                            for (Map.Entry<String, Object> formatEntry : value.entrySet()) {
                                allParamText += formatEntry.getValue();
                            }
                        }
                    }

                    if (StrUtil.isEmpty(allParamText)){
                        throw new RuntimeException("未设置范本");
                    }
                }
            }
        }
        // 有對應版本
        if (tTargetApiVersion != null) {
            String tGenerateFileName;
            String tCustomUUID = UUID.randomUUID().toString();
            try {
                // 打包下載
                if (tMessageType.equals(ApimgmtConstant.ALL)) {
                    tGenerateFileName = MessageSampleServiceUtil.zipItAndGetZipFileName(tTargetApiVersion.getId(),
                            tTargetApiVersion.getStandardApi(), tMsgFormat, tHostProduct, tServiceProduct,
                            MessageSampleArchiveTypeEnum.ZIP.toString(),
                            tTargetApiVersion.getStandardApi().getStandardApiSyncType().getNameEnUs(), tDevelopRole,
                            tCustomUUID, tLocale);
                } else {
                    tGenerateFileName = MessageSampleServiceUtil.writeToFile(ApiMgmtApplicationParameter._FILE_EXPORT_PATH,
                            tTargetApiVersion.getId(), tTargetApiVersion.getStandardApi(),
                            MessageFormatEnum.valueOf(tMsgFormat), tHostProduct, tServiceProduct,
                            MessageTextSampleTypeEnum.valueOf(tMessageType), DeveloperRoleEnum.valueOf(tDevelopRole),
                            tCustomUUID, tLocale);
                }
                String tFilePath = ApiMgmtApplicationParameter._FILE_EXPORT_PATH + "/" + tGenerateFileName;
                // 上傳檔案並提供下載連結
                DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tFilePath, tGenerateFileName, false, 0);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
        }
        StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
        String tDescription = tStateCode.getDescription();
        ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        return converJsonNodeToMap(tResponseJsonNode);
    }
}
