package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.model.DirtyData;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 用于查询历史api脏数据
 */
@Service
public class ApiMgmtQueryDirtyDataService {

    @Autowired
    private ApiMgmtStandardApiVersionDao standardApiVersionDao;

    public List<Long> queryDirtyData() {
        List<Long> ids = new ArrayList<>();
        // 对比当前api的最大版本，对应的apiVersionId最大才对，否则错误
        List<DirtyData> dirtyDataList = standardApiVersionDao.queryDirtyData();
        Map<Long, DirtyData> map = new HashMap<>();
        for (DirtyData dirtyData : dirtyDataList) {
            if (null != dirtyData.getApiId()) {
                if (map.containsKey(dirtyData.getApiId())) {
                    DirtyData dirtyData1 = map.get(dirtyData.getApiId());
                    if (dirtyData.getApiVersionId() > dirtyData1.getApiVersionId()) {
                        map.put(dirtyData.getApiId(), dirtyData);
                    }
                } else {
                    map.put(dirtyData.getApiId(), dirtyData);
                }
            }
        }
        for (Long key : map.keySet()) {
            List<StandardApiVersion> tStandardApiVersions = standardApiVersionDao.getVersionListByApiId(key);
            StandardApiVersion latestStandardApiVersion = ApiVersionServiceUtil.getLatestVersion(tStandardApiVersions);
            if (!latestStandardApiVersion.getId().equals(map.get(key).getApiVersionId())) {
                ids.add(key);
            }
        }
        return ids;
    }
}
