package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.apimgmt.constants.ApiTypeConstants;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtSchemaConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProductCategoryDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiCategoryDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiSyncTypeDao;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.ProductCategory;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiSyncType;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 取得查詢條件清單
 * /restful/standard/apimgmt/SearchConditionList/Get
 */
@Slf4j
@Service
public class ApiMgmtSearchConditionListGetService extends AbstractApiService {

    @Autowired
    ApiMgmtStandardApiCategoryDao standardApiCategoryDao;

    @Autowired
    ApiMgmtStandardApiSyncTypeDao standardApiSyncTypeDao;

    @Autowired
    ApiMgmtProductCategoryDao productCategoryDao;

    @Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;

    public ApiMgmtSearchConditionListGetService() {
        super();
        jsonSchemaFileName = ApimgmtSchemaConstant.SEARCH_CONDITION_LIST_GET_SCHEMA;
    }

    /**
     * 取得查詢條件清單
     *
     * @param validatorResult validatorResult
     * @return map
     * @throws BaseException BaseException
     * @throws Exception     Exception
     */
    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        // 取得語系
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        // header沒傳語系的話，默認回傳英文
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tReqCategory = ObjectUtil.isNotNull(tRequestJsonNode.get(ApimgmtConstant.CATEGORY_ID)) ? tRequestJsonNode.get(ApimgmtConstant.CATEGORY_ID).asText() : null;
        String tReqStatus = ObjectUtil.isNotNull(tRequestJsonNode.get(ApimgmtConstant.STATUS_ID)) ? tRequestJsonNode.get(ApimgmtConstant.STATUS_ID).asText() : null;
        List<String> conditionList = new ArrayList<>();
        conditionList.add(ApimgmtConstant.API_NAME);
        conditionList.add(ApimgmtConstant.API_TAG);
        //conditionList.add(ApimgmtConstant.API_DATANAME);
        conditionList.add(ApimgmtConstant.API_DESC);
        conditionList.add(ApimgmtConstant.API_REMARK);
        conditionList.add(ApimgmtConstant.API_SYNC_TYPE);
        //发起方
        conditionList.add(ApimgmtConstant.REQUESTER);
        //接受方
        conditionList.add(ApimgmtConstant.PROVIDER);
        conditionList.add(ApimgmtConstant.API_TYPE);
        conditionList.add(ApimgmtConstant.API_CATEGORY);
        conditionList.add(ApimgmtConstant.API_STATUS);
        // 入參categoryId是空的就回傳apiCategory，categoryId有值就不回傳apiCategory
        if (!StringUtil.isEmptyOrSpace(tReqCategory)) {
            conditionList.remove(ApimgmtConstant.API_CATEGORY);
        }
        // 入參statusId是空的就回傳apiStatus，statusId有值就不回傳apiStatus
        if (!StringUtil.isEmptyOrSpace(tReqStatus)) {
            conditionList.remove(ApimgmtConstant.API_STATUS);
        }
        Map<String, Object> tResponse = new HashMap<>();
        ArrayList<Map<String, Object>> tCondition = new ArrayList<>();
        for (String condition : conditionList) {
            Map<String, Object> tConditionMap = new HashMap<>();
            ArrayList<String> tEquation = new ArrayList<>();
            ArrayList<String> tOptionStr = new ArrayList<>();
            ArrayList<Map<String, Object>> tOptionMap = new ArrayList<>();
            tConditionMap.put(ApimgmtConstant.CONDITION, condition);
            switch (condition) {
                case ApimgmtConstant.API_NAME:
                case ApimgmtConstant.API_TAG:
                case ApimgmtConstant.API_DATANAME:
                case ApimgmtConstant.API_DESC:
                case ApimgmtConstant.API_REMARK:
                case ApimgmtConstant.TENANT_ID:
                case ApimgmtConstant.REQUESTER:
                    tEquation.add(ApimgmtConstant.LIKE);
                    tEquation.add(ApimgmtConstant.EQUAL);
                    tConditionMap.put(ApimgmtConstant.EQUATION, tEquation);
                    break;
                case ApimgmtConstant.API_SYNC_TYPE:
                    List<StandardApiSyncType> tStandardApiSyncTypeList = standardApiSyncTypeDao.getAll();
                    for (StandardApiSyncType tStandardApiSyncType : tStandardApiSyncTypeList) {
                        Map<String, Object> tGroupMap = new HashMap<>();
                        String tGroupName;
                        switch (tLocale) {
                            case ApimgmtConstant.ZH_CN:
                                tGroupName = tStandardApiSyncType.getNameZhCn();
                                break;
                            case ApimgmtConstant.ZH_TW:
                                tGroupName = tStandardApiSyncType.getNameZhTw();
                                break;
                            case ApimgmtConstant.EN_US:
                            default:
                                tGroupName = tStandardApiSyncType.getNameEnUs();
                                break;
                        }
                        tGroupMap.put(ApimgmtConstant.ID, tStandardApiSyncType.getId());
                        tGroupMap.put(ApimgmtConstant.NAME, tGroupName);
                        tOptionMap.add(tGroupMap);
                    }
                    tEquation.add(ApimgmtConstant.EQUAL);
                    tConditionMap.put(ApimgmtConstant.EQUATION, tEquation);
                    tConditionMap.put(ApimgmtConstant.OPTION, tOptionMap);
                    break;
                case ApimgmtConstant.API_CATEGORY:
                    List<StandardApiCategory> tStandardApiCategoryList = standardApiCategoryDao.getAll();
                    for (StandardApiCategory tStandardApiCategory : tStandardApiCategoryList) {
                        Map<String, Object> tCategoryMap = new HashMap<>();
                        String tCategory;
                        switch (tLocale) {
                            case ApimgmtConstant.ZH_CN:
                                tCategory = tStandardApiCategory.getNameZhCn();
                                break;
                            case ApimgmtConstant.ZH_TW:
                                tCategory = tStandardApiCategory.getNameZhTw();
                                break;
                            case ApimgmtConstant.EN_US:
                            default:
                                tCategory = tStandardApiCategory.getNameEnUs();
                                break;
                        }
                        tCategoryMap.put(ApimgmtConstant.ID, tStandardApiCategory.getId());
                        tCategoryMap.put(ApimgmtConstant.NAME, tCategory);
                        tOptionMap.add(tCategoryMap);
                    }
                    tEquation.add(ApimgmtConstant.EQUAL);
                    tConditionMap.put(ApimgmtConstant.EQUATION, tEquation);
                    tConditionMap.put(ApimgmtConstant.OPTION, tOptionMap);
                    break;
                case ApimgmtConstant.PROVIDER:
                    List<ProductCategory> tProductCategoryList = productCategoryDao.getAll();
                    for (ProductCategory tProductCategory : tProductCategoryList) {
                        String tGroup;
                        switch (tLocale) {
                            case ApimgmtConstant.ZH_CN:
                                tGroup = tProductCategory.getNameZhCn();
                                break;
                            case ApimgmtConstant.ZH_TW:
                                tGroup = tProductCategory.getNameZhTw();
                                break;
                            case ApimgmtConstant.EN_US:
                            default:
                                tGroup = tProductCategory.getNameEnUs();
                                break;
                        }
                        tOptionStr.add(tGroup);
                    }
                    tEquation.add(ApimgmtConstant.LIKE);
                    tEquation.add(ApimgmtConstant.EQUAL);
                    tConditionMap.put(ApimgmtConstant.EQUATION, tEquation);
                    tConditionMap.put(ApimgmtConstant.OPTION, tOptionStr);
                    break;
                case ApimgmtConstant.API_STATUS:
                    List<ApprovedStatus> tApprovedStatusList = approvedStatusDao.getAll();
                    for (ApprovedStatus tApprovedStatus : tApprovedStatusList) {
                        Map<String, Object> tStatusMap = new HashMap<>();
                        String tStatus;
                        switch (tLocale) {
                            case ApimgmtConstant.ZH_CN:
                                tStatus = tApprovedStatus.getNameZhCn();
                                break;
                            case ApimgmtConstant.ZH_TW:
                                tStatus = tApprovedStatus.getNameZhTw();
                                break;
                            case ApimgmtConstant.EN_US:
                            default:
                                tStatus = tApprovedStatus.getNameEnUs();
                                break;
                        }
                        tStatusMap.put(ApimgmtConstant.ID, tApprovedStatus.getId());
                        tStatusMap.put(ApimgmtConstant.NAME, tStatus);
                        tOptionMap.add(tStatusMap);
                    }
                    tEquation.add(ApimgmtConstant.EQUAL);
                    tConditionMap.put(ApimgmtConstant.EQUATION, tEquation);
                    tConditionMap.put(ApimgmtConstant.OPTION, tOptionMap);
                    break;
                case ApimgmtConstant.API_TYPE:
                    tEquation.add(ApimgmtConstant.EQUAL);
                    tConditionMap.put(ApimgmtConstant.EQUATION, tEquation);
                    tConditionMap.put(ApimgmtConstant.OPTION, ApiTypeConstants.LANG_OPTIONS.get(tLocale));
                    break;
            }
            tCondition.add(tConditionMap);
        }
        tResponse.put(ApimgmtConstant.CONDITION_LIST, tCondition);
        return tResponse;
    }
}