package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtSchemaConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.APIExportImportEnums;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.MessageFormatEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.exception.TeamIdNotFindValidationException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMdcProp;
import com.digiwin.athena.apimgmt.model.*;
import com.digiwin.athena.apimgmt.service.util.*;
import com.digiwin.athena.apimgmt.services.ApiMgmtApiSaveAndReviewVerifyProcessor;
import com.digiwin.athena.apimgmt.services.ApiMgmtApiVersionService;
import com.digiwin.athena.apimgmt.services.ApiMgmtProductCategoryService;
import com.digiwin.athena.apimgmt.services.ApiMgmtSyncMdcServiceProcessor;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 批量保存API规格+送审 -驱动模型使用
 * /restful/standard/apimgmt/ApiSpec/BatchSave
 */
@Slf4j
@Service
@OperateAuthorityVerify
public class ApiSpecBatchSaveService extends AbstractApiService {

    public ApiSpecBatchSaveService() {
        super();
        jsonSchemaFileName = ApimgmtSchemaConstant.API_SPEC_BATCH_SAVE_SCHEMA;
    }

    @Autowired
    private ApiMgmtStandardApiDao standardApiDao;

    @Autowired
    private ApiMgmtStandardApiVersionDao standardApiVersionDao;

    @Autowired
    private ApiMgmtProjectVersionRelationDao projectVersionRelationDao;

    @Autowired
    private ApiMgmtProductCategoryService productCategoryService;

    @Autowired
    private ApiMgmtStandardApiDataNameDao standardApiDataNameDao;

    @Autowired
    private ApiMgmtSyncMdcServiceProcessor syncMdcServiceProcessor;

    @Autowired
    private ApiMgmtApiSaveAndReviewVerifyProcessor apiSaveAndReviewVerifyProcessor;

    @Autowired
    private ApiMgmtApiVersionService apiVersionService;

    @Autowired
    private ApiMgmtMdcProp mdcProp;

    /**
     * 批量保存API规格-送审
     * 1、先进行保存API+送审的API检测
     * 2、在执行入库操作
     *
     * @param validatorResult validatorResult
     * @return map
     */
    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws Exception {
        // 1、基础信息获取
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        StateCode tStateCode = getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = tStateCode.getDescription();
        StringBuilder tDescriptionBuilder = new StringBuilder();
        // 建立response node
        ObjectNode tResponseNode = mapper.createObjectNode();
        ArrayNode dataNode = mapper.createArrayNode();
        tResponseNode.set(ApimgmtConstant.API_LIST, dataNode);
        // 全部API的錯誤總Map
        Map<String, List<Map<String, String>>> tTotalApiErrorMap = new HashMap<>();
        List<StandardApi> standardApiList = new ArrayList<>();
        List<Long> apiVersionList = new ArrayList<>();
        List<Long> apiIdList = new ArrayList<>();
        try {
            String tToken = ApiMgmtServiceContextHolder.getToken();
            String routerKey = ApiMgmtServiceContextHolder.getRouterKey();
            String tTeamId = ApiMgmtServiceContextHolder.getTeamId();
            String teamType = ApiMgmtServiceContextHolder.getTeamType();
            String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
            String tUserId = ApiMgmtServiceContextHolder.getUserId();
            if (StringUtil.isEmpty(teamType)) {
                throw new TeamIdNotFindValidationException(this.getClass());
            }
            JsonNode tRequestJsonNode = validatorResult.getJsonContent();
            JsonNode arrayNode = tRequestJsonNode.get(ApimgmtConstant.API_LIST);
            // 2、主体信息的获取 保存API(API不存在保存API,API存在,根据不同状态进行处理)
            for (JsonNode jsonNode : arrayNode) {
                // 解析API资讯
                StandardApi tStandardApi = new StandardApi();
                tStandardApi.setTeamId(tTeamId);
                tStandardApi.setTeamType(teamType);
                List<Map<String, String>> tSetStdApiResult = StandardApiSpecAnalyzeServiceUtil.setStandardApi(tStandardApi, jsonNode, tLocale);
                String tApiName = tStandardApi.getName();
                String tApiTenantId = tStandardApi.getTenantId();
                String tVersion = tStandardApi.getStandardApiVersions().get(0).getVersion();
                if (CollUtil.isNotEmpty(tSetStdApiResult)) {
                    tTotalApiErrorMap.put(tApiName + "/" + tVersion + "/" + tApiTenantId, tSetStdApiResult);
                    break;
                }
                // 解析DataName资讯
                Map<String, StandardApiDataName> tAddDataName = new HashMap<>();
                tSetStdApiResult = StandardApiSpecAnalyzeServiceUtil.setStandardApiDataName(tStandardApi, jsonNode, tAddDataName, tLocale);
                if (CollUtil.isNotEmpty(tSetStdApiResult)) {
                    tTotalApiErrorMap.put(tApiName + "/" + tVersion + "/" + tApiTenantId, tSetStdApiResult);
                    break;
                }
                /*
                 *  API 已存在的情况下 处于开发状态下的API可以不用取回直接更新后再次送审
                 *  1、区分是保存 还是 编辑
                 *  2、编辑区分是API创建人、非创建人
                 */
                List<StandardApiVersion> tStandardApiVersionList = standardApiVersionDao.getExistApiVersion(tApiName, tApiTenantId, tVersion);
                setVersion(tStandardApiVersionList, tSetStdApiResult, tTotalApiErrorMap, apiVersionList, apiIdList, tStandardApi,
                        tLocale, tUserId, tTenantId);
                // 檢查前一版是否匯入，除了1.0不檢查
                //if (Float.parseFloat(tStandardApi.getStandardApiVersions().get(0).getVersion()) > Float.parseFloat(ApimgmtConstant.API_VER)) {
                if (!apiVersionService.judgeNewBranch(tVersion)) {
                    log.info("进入与上一版本的验证");
                    List<StandardApiVersion> tPreviStandardApiVersions = standardApiVersionDao.getExistApiVersion(tApiName, tApiTenantId,
                            ApiVersionServiceUtil.getPreviousVersion(tVersion));
                    if (tPreviStandardApiVersions.isEmpty()) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PREVI_API_VERSION_IS_EXIST.toString(), null, null, 0, 0, tLocale);
                    } else {
                        // 確認是否有缺少字段、「為數組」、「必要」欄位是否正確
                        List<StandardApiDataName> tPreviApiDataName = standardApiDataNameDao.getByApiVerId(tPreviStandardApiVersions.get(0).getId(), true);
                        apiSaveAndReviewVerifyProcessor.compareDataName(tSetStdApiResult, tPreviApiDataName, tAddDataName);
                        StandardApi previousStandardApi = tPreviStandardApiVersions.get(0).getStandardApi();
                        ApprovedStatus previousApprovedStatus = tPreviStandardApiVersions.get(0).getApprovedStatus();
                        if (previousApprovedStatus.getId() != ApimgmtConstant.APPROVED_STATUS_COMFIRMED) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PREVI_IS_DEVELOPING.toString(), null, null, 0, 0, tLocale);
                        }
                        /*
                         * 判定父类api是否一致，不一致则抛出异常
                         * 1.0父类不存在 1.1父类不存在 ok、1.1父类存在 则异常
                         * 1.0父类存在 1.1父类不存在 ok、1.1父类存在且一致 ok、1.1父类存在且不一致 则异常
                         * 增加父类api租户的判定
                         */
                        if ((null != tStandardApi.getParentApiName()
                                && (null == previousStandardApi.getParentApiName()
                                || (null != previousStandardApi.getParentApiName()
                                && (!tStandardApi.getParentApiName().equals(previousStandardApi.getParentApiName())
                                || !tStandardApi.getParentBranch().equals(previousStandardApi.getParentBranch())
                                && !tStandardApi.getParentApiTenantId().equals(previousStandardApi.getParentApiTenantId())))))) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PARENT_NAME_INCONSISTENT.toString(), null, null, 0, 0, tLocale);
                        }
                        // 判定当前版本的调用模式是否与上一版一致
                        if (!previousStandardApi.getStandardApiSyncType().getId().equals(tStandardApi.getStandardApiSyncType().getId())) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.SYNC_TYPE_CAN_NOT_CHANGE.toString(), null, null, 0, 0, tLocale);
                        }
                        // 判定当前版本的分包属性是否与上一版一致
                        if (!previousStandardApi.getIsBatch().equals(tStandardApi.getIsBatch())) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.IS_BATCH_CAN_NOT_CHANGE.toString(), null, null, 0, 0, tLocale);
                        }
                        // 判定上一版本与当前token中的TenantId不一致并且teamType = 1 鼎捷租户
                        String designTenantId = previousStandardApi.getDesignTenantId();
                        if (!tTenantId.equals(designTenantId) && !"1".equals(teamType)) {
                            Map<String, String> errorMap = new HashMap<>();
                            errorMap.put(ApimgmtConstant.DESCRIPTION, "当前租户无权限执行当前操作");
                            errorMap.put(ApimgmtConstant.SOLUTION, "请使用租户ID：" + designTenantId + "执行当前操作");
                            tSetStdApiResult.add(errorMap);
                        }
                    }
                } else if(!ApimgmtConstant.API_VER.equals(tVersion)) {
                    String prevBranch = ApiVersionServiceUtil.getPrevBranchByVersion(tVersion);
                    List<StandardApiVersion> tPreviStandardApiVersions = standardApiVersionDao.getExistApiVersion(tApiName, tApiTenantId, prevBranch);
                    if (tPreviStandardApiVersions.isEmpty()) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PREV_API_BRANCH_NOT_EXIST.toString(), null, null, 0, 0, tLocale);
                    }
                }
                // 檢查列舉值格式
                apiSaveAndReviewVerifyProcessor.checkListEnum(tSetStdApiResult, tAddDataName);
                // 若服務發起方或接收方包含ATHENA，則訊息格式必須為JSON
                if (tStandardApi.getRequester().equalsIgnoreCase("Athena") || tStandardApi.getProvider().equalsIgnoreCase("Athena")) {
                    if (!tStandardApi.getMsgFormat().equals(MessageFormatEnum.JSON.getMsgFormat())) {
                        Map<String, String> tReqErrorLog = new HashMap<>();
                        tReqErrorLog.put("description", "發起方、接收方產品包含「Athena」，則信息格式必須為「JSON」");
                        tSetStdApiResult.add(tReqErrorLog);
                    }
                }
                // 檢查匯入是否有包含必要字段
                apiSaveAndReviewVerifyProcessor.checkRequiredDataName(tSetStdApiResult, tAddDataName);
                // 檢查「分頁模式」
                if (tStandardApi.getStandardApiPaging().getId() == 2L || tStandardApi.getStandardApiPaging().getId() == 3L) {
                    apiSaveAndReviewVerifyProcessor.checkPagingRequiredDataName(tSetStdApiResult, tAddDataName);
                }
                // 除M、D、SD、4D、5D...之外，「為數組」不可為Y
                apiSaveAndReviewVerifyProcessor.checkIsArrayCannotBeY(tSetStdApiResult, tAddDataName);
                // 檢查datakey是否設為Y
                apiSaveAndReviewVerifyProcessor.checkDataKey(tSetStdApiResult, tAddDataName);
                // 若調用模式為全異步則訊息格式必須為JSON
                if (tStandardApi.getStandardApiSyncType().getId() == 2L) {
                    if (!tStandardApi.getMsgFormat().equals(MessageFormatEnum.JSON.getMsgFormat())) {
                        Map<String, String> tReqErrorLog = new HashMap<>();
                        tReqErrorLog.put("description", "調用模式為「全異步」，則信息格式必須為「JSON」");
                        tSetStdApiResult.add(tReqErrorLog);
                    }
                }
                if (CollUtil.isNotEmpty(tSetStdApiResult)) {
                    String tApiError = tApiName + "/" + tVersion + "/" + tApiTenantId;
                    tTotalApiErrorMap.put(tApiError, tSetStdApiResult);
                    break;
                }
                standardApiList.add(tStandardApi);
            }
            if (MapUtils.isNotEmpty(tTotalApiErrorMap)) {
                return result(tStateCode, tDescription, tTotalApiErrorMap);
            } else {
                // 不是新建 - 则先删除,再创建
                if (CollUtil.isNotEmpty(apiVersionList)) {
                    apiVersionList.forEach(x -> standardApiVersionDao.delete(x, false));
                }
                if (CollUtil.isNotEmpty(apiIdList)) {
                    apiIdList.forEach(apiId -> projectVersionRelationDao.deleteByApiId(apiId));
                }
                //保存API
                ArrayList<Long> tListApiVerIdNeedToSyncMetadata = new ArrayList<>();
                if (CollUtil.isNotEmpty(standardApiList)) {
                    standardApiList.forEach(x -> {
                        x.getStandardApiVersions().get(0).getApprovedStatus().setId(ApimgmtConstant.APPROVED_STATUS_DEVELOPING);
                        standardApiDao.save(x);
                        productCategoryService.saveProductCategory(x.getProvider());
                        ObjectNode objectNode = mapper.createObjectNode();
                        objectNode.put(ApimgmtConstant.APPROVED_STATUS, ApimgmtConstant.APPROVED_STATUS_DEVELOPING);
                        objectNode.put(ApimgmtConstant.API_NAME, x.getName());
                        objectNode.put(ApimgmtConstant.API_VERSION, x.getStandardApiVersions().get(0).getVersion());
                        objectNode.put(ApimgmtConstant.TENANT_ID, x.getTenantId());
                        dataNode.add(objectNode);
                        List<StandardApiVersion> standardApiVersionList = standardApiVersionDao.getExistApiVersion(x.getName(), x.getTenantId(), x.getStandardApiVersions().get(0).getVersion());
                        if (CollUtil.isNotEmpty(standardApiVersionList)) {
                            tListApiVerIdNeedToSyncMetadata.add(standardApiVersionList.get(0).getId());
                        }
                    });
                }
                if(!tListApiVerIdNeedToSyncMetadata.isEmpty() && CollUtil.isNotEmpty(mdcProp.getReviewUrlList())) {
                    //同步MDC元数据
                    for (String url : mdcProp.getReviewUrlList()) {
                        syncMdcServiceProcessor.runSyncMdcMetadata(
                                tListApiVerIdNeedToSyncMetadata, url, tUserId, tToken, routerKey);
                    }
                }
            }
        } catch (BaseException e) {
            log.error(e.getMessage(), e);
            tStateCode = getStateCode(e.getStateEnum().getCode());
            tDescriptionBuilder.append(tStateCode.getDescription());
            if (!StringUtil.isEmptyOrSpace(e.getMessage())) {
                tDescriptionBuilder.append(ApimgmtConstant.BLANK).append(e.getMessage());
            }
            tDescription = tDescriptionBuilder.toString();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            tStateCode = getStateCode(ValidateStateEnum.UNEXPECTED_ERROR.getCode());
            tDescriptionBuilder.append(tStateCode.getDescription()).append(ApimgmtConstant.BLANK).append(e.getClass().toString()).append(":").append(e.getMessage());
            tDescription = tDescriptionBuilder.toString();
        }
        tResponseNode.put(ApimgmtConstant.CODE, tStateCode.getCode());
        tResponseNode.put(ApimgmtConstant.DESCRIPTION, tDescription);
        ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        return converJsonNodeToMap(tResponseJsonNode);
    }


    private void setVersion(List<StandardApiVersion> tStandardApiVersionList, List<Map<String, String>> tSetStdApiResult,
                            Map<String, List<Map<String, String>>> tTotalApiErrorMap,
                            List<Long> apiVersionList, List<Long> apiIdList, StandardApi tStandardApi,
                            String tLocale, String tUserId, String tTenantId) {
        if (CollUtil.isNotEmpty(tStandardApiVersionList)) {
            StandardApiVersion tStandardApiVersion = tStandardApiVersionList.get(0);
            // 编辑人与创建人不一致或者同一人不同租户抛出异常
            if (tStandardApiVersion.getApprovedStatus().getId() != ApimgmtConstant.APPROVED_STATUS_COMFIRMED
                    && (!tStandardApiVersion.getUserId().equals(tUserId)
                    || (!StringUtil.isEmptyOrSpace(tStandardApiVersion.getStandardApi().getDesignTenantId())
                    && !tStandardApiVersion.getStandardApi().getDesignTenantId().equals(tTenantId)))) {
                StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.API_VERSION_IS_EXIST.toString(), null, null, 0, 0, tLocale);
                String tApiError = tStandardApi.getName() + "/" + tStandardApi.getStandardApiVersions().get(0).getVersion()
                        + "/" + tStandardApi.getTenantId();
                tTotalApiErrorMap.put(tApiError, tSetStdApiResult);
                return;
            }
            if (tStandardApiVersion.getApprovedStatus().getId() == ApimgmtConstant.APPROVED_STATUS_DRAFT) {
                apiVersionList.add(tStandardApiVersion.getId());
            }
            if (tStandardApiVersion.getApprovedStatus().getId() == ApimgmtConstant.APPROVED_STATUS_DEVELOPING) {
                // 需要取回-暂可不实现
                apiVersionList.add(tStandardApiVersion.getId());
            }
            if (tStandardApiVersion.getApprovedStatus().getId() == ApimgmtConstant.APPROVED_STATUS_COMFIRMED) {
                // 进版
                tStandardApi.getStandardApiVersions().get(0)
                        .setVersion(ApiVersionServiceUtil.getNextVersion(tStandardApi.getStandardApiVersions().get(0).getVersion()));
                List<StandardApiVersion> standardApiNextVersionList
                        = standardApiVersionDao.getExistApiVersion(tStandardApi.getName(), tStandardApi.getTenantId(),
                        tStandardApi.getStandardApiVersions().get(0).getVersion());
                setVersion(standardApiNextVersionList, tSetStdApiResult, tTotalApiErrorMap, apiVersionList, apiIdList, tStandardApi,
                        tLocale, tUserId, tTenantId);
            }

            apiIdList.add(tStandardApiVersion.getStandardApi().getId());
        }
    }

    private Map<String, Object> result(StateCode tStateCode, String tDescription,
                                       Map<String, List<Map<String, String>>> pTotalApiErrorMap) throws Exception {
        ObjectNode tResponseNode = mapper.createObjectNode();
        ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        tStateCode = getStateCode(ValidateStateEnum.IMPORT_SPEC_FORMAT_ERROR.getCode());
        tDescription = tStateCode.getDescription();
        // 取得樣板
        HSSFWorkbook tHSSFWorkbook = StandardApiExportServiceUtil.getTemplateFile(false);
        Sheet tErrorSheet = tHSSFWorkbook.createSheet("錯誤明細");
        StandardApiFileReadServiceUtil.writeImportErrorFile(tErrorSheet, pTotalApiErrorMap);
        String tFileName = ApiMgmtApplicationParameter._TEMPLATE_FILE_NAME;
        String tFileExportPath = ApiMgmtApplicationParameter._FILE_EXPORT_PATH + "/" + tFileName;
        FileOutputStream fileOut = new FileOutputStream(tFileExportPath);
        tHSSFWorkbook.write(fileOut);
        fileOut.close();
        int pFailedNum = pTotalApiErrorMap.keySet().size();
        // 上傳檔案並提供下載連結
        DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tFileExportPath, tFileName, true, pFailedNum);
        tResponseNode.put(ApimgmtConstant.CODE, tStateCode.getCode());
        tResponseNode.put(ApimgmtConstant.DESCRIPTION, tDescription);
        return converJsonNodeToMap(tResponseJsonNode);
    }

}
