package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtSchemaConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * API刪除
 * /restful/standard/apimgmt/DeleteApi/Delete
 */
@Slf4j
@Service
@OperateAuthorityVerify
public class DeleteApiService extends AbstractApiService {

    @Autowired
    ApiMgmtStandardApiDao standardApiDao;

    public DeleteApiService() {
        super();
        jsonSchemaFileName = ApimgmtSchemaConstant.DELETE_API_SCHEMA;
    }

    /**
     * 删除API
     *
     * @param validatorResult validatorResult
     * @return map
     * @throws BaseException BaseException
     * @throws Exception     Exception
     */
    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ArrayNode tApiArrayNode = (ArrayNode) tRequestJsonNode.get(ApimgmtConstant.API_LIST);
        for (JsonNode tApiNode : tApiArrayNode) {
            // 取得入參api名稱
            String tApiName = tApiNode.asText();
            List<StandardApi> standardApiList = standardApiDao.getByNameAndTenantId(tApiName, null);
            if (CollUtil.isNotEmpty(standardApiList)) {
                log.info(tApiName + ": 查询数据的条数: " + standardApiList.size());
                for (StandardApi standardApi : standardApiList) {
                    standardApiDao.delete(standardApi.getId());
                }
            }
        }
        Map<String, Object> tResponse = new HashMap<>();
        // 組成回傳訊息
        tResponse.put(ApimgmtConstant.CODE, "000");
        tResponse.put(ApimgmtConstant.RESULT, ApimgmtConstant.SUCCESS);
        return tResponse;
    }

}
