package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtSchemaConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApimgmtProductDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.*;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;

/**
 * 複製API規格
 * /restful/standard/apimgmt/DuplicateApi/Get
 */
@Slf4j
@Service
public class DuplicateApiGetService extends AbstractApiService {

	@Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

	@Autowired
    ApiMgmtStandardApiDataNameDao standardApiDataNameDao;

	@Autowired
    ApimgmtProductDao productDao;
	
	@Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;

	public DuplicateApiGetService() {
		super();
		jsonSchemaFileName = ApimgmtSchemaConstant.DUPLICATE_API_GET_SCHEMA;
	}

	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws Exception {
		// 取得語系
		String tLocale = ApiMgmtServiceContextHolder.getLocale();
		// 取得用戶名稱
		String tUserName = ApiMgmtServiceContextHolder.getUserName();
		// 取得request node
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		// 建立response node
		ObjectNode tResponseNode = mapper.createObjectNode();
		StateCode tStateCode = getStateCode(ValidateStateEnum.SUCCESS.getCode());
		// 取得入參api名稱
		String tApiName = tRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
		// 取得入參api版號
		String tVersion = tRequestJsonNode.get(ApiAttributeEnum.version.toString()).asText();
		// branch
		String branch = ApiVersionServiceUtil.getBranchFromVersion(tVersion);
//		String branch = ObjectUtil.isNotNull(tRequestJsonNode.get(ApiAttributeEnum.branch.toString())) ?
//				tRequestJsonNode.get(ApiAttributeEnum.branch.toString()).asText() : ApimgmtConstant.DEFAULT_BRANCH;
		// 找出api的所有版本號
		List<StandardApiVersion> tStandardApiVersionList = standardApiVersionDao.fetchApiVersionsByName(tApiName, branch, "");
		// 找出草稿的狀態
		ApprovedStatus tDraft = approvedStatusDao.get(1L);
		// 找出入參對應版本號的相關資訊
		StandardApiVersion tStandardApiVersion = null;
		for (StandardApiVersion standardApiVersion : tStandardApiVersionList) {
			// 有找到對應版本號數據
			if (standardApiVersion.getVersion().equals(tVersion)) {
				tStandardApiVersion = standardApiVersion;
			}
		}
		// 有找到對應版本號數據
		if (tStandardApiVersion != null) {
			// 組成response
			StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
			String tApiNameResponse = tStandardApi.getName();
			String tApiDescription = null;
			String tApiRemark = null;
			String tApiTag = null;
			String tApiVersionString = tStandardApiVersion.getVersion();
			String tApprovedStatus = null;
			String tEditHistory = tStandardApiVersion.getUpdateHistory();
			String tInvokeType = tStandardApi.getStandardApiSyncType().getNameEnUs();
			String tRequester = tStandardApi.getRequester();
			String tProvider = tStandardApi.getProvider();
			String tPaging = null;
			String tProductType = null;
			Long tStatusId = tStandardApi.getStandardApiCategory().getId();
			String tGroup = null;
			String isBatch = tStandardApi.getIsBatch() ? ApimgmtConstant.YES : ApimgmtConstant.NO;
			boolean tIdempotency = tStandardApiVersion.getIdempotency();
			if (tLocale != null) {
				switch (tLocale) {
				case ApimgmtConstant.ZH_CN:
					tApprovedStatus = tDraft.getNameZhCn();
					tApiDescription = tStandardApi.getDescriptionZhCn();
					tPaging = tStandardApi.getStandardApiPaging().getNameZhCn();
					tApiRemark = tStandardApi.getRemarkZhCn();
					tApiTag = tStandardApi.getTagZhCn();
					tGroup = tStandardApi.getTagZhCn();
					break;
				case ApimgmtConstant.EN_US:
					tApprovedStatus = tDraft.getNameEnUs();
					tApiDescription = tStandardApi.getDescriptionEnUs();
					tPaging = tStandardApi.getStandardApiPaging().getNameEnUs();
					tApiRemark = tStandardApi.getRemarkEnUs();
					tApiTag = tStandardApi.getTagEnUs();
					tGroup = tStandardApi.getTagEnUs();
					break;
				case ApimgmtConstant.ZH_TW:
				default:
					tApprovedStatus = tDraft.getNameZhTw();
					tApiDescription = tStandardApi.getDescriptionZhTw();
					tPaging = tStandardApi.getStandardApiPaging().getNameZhTw();
					tApiRemark = tStandardApi.getRemarkZhTw();
					tApiTag = tStandardApi.getTagZhTw();
					tGroup = tStandardApi.getTagZhTw();
					break;
				}
			}
			ObjectNode tApiDescriptionMultilingualNode = mapper.createObjectNode();
			tApiDescriptionMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tStandardApi.getDescriptionZhTw());
			tApiDescriptionMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tStandardApi.getDescriptionZhCn());
			tApiDescriptionMultilingualNode.put(LocaleEnum.EN_US.getType(), tStandardApi.getDescriptionEnUs());
			tResponseNode.set(ApiAttributeEnum.apiDescriptionMultilingual.toString(), tApiDescriptionMultilingualNode);
			ObjectNode tApiRemarkMultilingualNode = mapper.createObjectNode();
			tApiRemarkMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tStandardApi.getRemarkZhTw());
			tApiRemarkMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tStandardApi.getRemarkZhCn());
			tApiRemarkMultilingualNode.put(LocaleEnum.EN_US.getType(), tStandardApi.getRemarkEnUs());
			tResponseNode.set(ApiAttributeEnum.apiRemarkMultilingual.toString(), tApiRemarkMultilingualNode);
			ObjectNode tApiTagMultilingualNode = mapper.createObjectNode();
			tApiTagMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tStandardApi.getTagZhTw());
			tApiTagMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tStandardApi.getTagZhCn());
			tApiTagMultilingualNode.put(LocaleEnum.EN_US.getType(), tStandardApi.getTagEnUs());
			tResponseNode.set(ApiAttributeEnum.apiTagMultilingual.toString(), tApiTagMultilingualNode);
			// api名稱
			tResponseNode.put(ApiAttributeEnum.apiName.toString(), tApiNameResponse);
			// api說明
			tResponseNode.put(ApiAttributeEnum.apiDescription.toString(), tApiDescription);
			// 備註
			tResponseNode.put(ApiAttributeEnum.apiRemark.toString(), tApiRemark);
			// 標籤
			tResponseNode.put(ApiAttributeEnum.apiTag.toString(), tApiTag);
			// 版本號
			tResponseNode.put(ApiAttributeEnum.apiVersion.toString(), tApiVersionString);
			// 申請人
			tResponseNode.put(ApiAttributeEnum.applicant.toString(), tUserName);
			// 當前狀態
			tResponseNode.put(ApiAttributeEnum.approvedStatus.toString(), tApprovedStatus);
			// 修改紀錄
			tResponseNode.put(ApiAttributeEnum.editHistory.toString(), tEditHistory);
			// 发起方
			tResponseNode.put(ApiAttributeEnum.requester.toString(), tRequester);
			// 接收方
			tResponseNode.put(ApiAttributeEnum.provider.toString(), tProvider);
			// 幂等性
			tResponseNode.put(ApiAttributeEnum.idempotency.toString(), tIdempotency);
			// 调用模式
			tResponseNode.put(ApiAttributeEnum.invokeType.toString(), tInvokeType);
			// 信息大類
			tResponseNode.put(ApiAttributeEnum.group.toString(), tGroup);
			// 須分包
			tResponseNode.put(ApiAttributeEnum.isBatch.toString(), isBatch);
			// 分頁模式
			tResponseNode.put(ApiAttributeEnum.paging.toString(), tPaging);
			// 信息類別
			tResponseNode.put(ApiAttributeEnum.statusId.toString(), tStatusId);
			// 发起方产品
			ArrayNode tHostProductAryNode = mapper.createArrayNode();
			// 接收方产品
			ArrayNode tServiceProductAryNode = mapper.createArrayNode();
			String[] tRequesterProducts = tRequester.split(ApimgmtConstant.SPLITER);
			String[] tProviderProducts = tProvider.split(ApimgmtConstant.SPLITER);
			for (String tRequesterProduct : tRequesterProducts) {
				tHostProductAryNode.add(tRequesterProduct);
			}
			for (String tProviderProduct : tProviderProducts) {
				tServiceProductAryNode.add(tProviderProduct);
			}
			// 有實作產品
			if (tProviderProducts.length != 0) {
				// 取得產品
				List<Product> tProducts = productDao.getByName(tProviderProducts[0]);
				Product tProduct = null;
				if (tProducts.size() != 0) {
					tProduct = tProducts.get(0);
				}
				// 取得產品的類別
				if (tProduct != null && tProduct.getProductCategory() != null) {
					if (tLocale != null) {
						switch (tLocale) {
						case ApimgmtConstant.ZH_CN:
							tProductType = tProduct.getProductCategory().getNameZhCn();
							break;
						case ApimgmtConstant.EN_US:
							tProductType = tProduct.getProductCategory().getNameEnUs();
							break;
						case ApimgmtConstant.ZH_TW:
						default:
							tProductType = tProduct.getProductCategory().getNameZhTw();
							break;
						}
					}
					tResponseNode.put(ApiAttributeEnum.productType.toString(), tProductType);
					ObjectNode tProductTypeMultilingualNode = mapper.createObjectNode();
					tProductTypeMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tProduct.getProductCategory().getNameZhTw());
					tProductTypeMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tProduct.getProductCategory().getNameZhCn());
					tProductTypeMultilingualNode.put(LocaleEnum.EN_US.getType(), tProduct.getProductCategory().getNameEnUs());
					tResponseNode.set(ApiAttributeEnum.productTypeMultilingual.toString(), tProductTypeMultilingualNode);
				}
			}
			// 取得詞彙
			List<StandardApiDataName> tStandardApiDataNameList = standardApiDataNameDao.getByApiVerId(tStandardApiVersion.getId(), true);
			// Request信息内容
			ArrayNode tRequestMessageSpecAryNode = mapper.createArrayNode();
			tResponseNode.set(ApiAttributeEnum.requestMessageSpec.toString(), tRequestMessageSpecAryNode);
			for (StandardApiDataName standardApiDataName : tStandardApiDataNameList) {
				if (standardApiDataName.getMsgType() == 1) {
					ObjectNode tRequestMessageSpecNode = mapper.createObjectNode();
					String tColumnType = standardApiDataName.getColumnType();
					long tId = standardApiDataName.getId();
					long tParentId;
					boolean tIsDataKey = standardApiDataName.getIsDatakey() != null && standardApiDataName.getIsDatakey();
					boolean tIsRequired = standardApiDataName.getIsRequired() != null && standardApiDataName.getIsRequired();
					boolean tIsArray = standardApiDataName.getIsArray() != null && standardApiDataName.getIsArray();
					boolean tCanSort = standardApiDataName.getCanSort() != null && standardApiDataName.getCanSort();
					boolean tCanFilter = standardApiDataName.getCanFilter() != null && standardApiDataName.getCanFilter();
					boolean tIsBusinessKey = standardApiDataName.getIsBusinesskey() != null && standardApiDataName.getIsBusinesskey();
					String tDataType = standardApiDataName.getDataType();
					String tValue = standardApiDataName.getValue();
					String tListEnum = null;
					if (standardApiDataName.getListEnumZhTw() != null) {
						tListEnum = MessageFormat.format("zh_TW:[{0}]\nzh_CN:[{1}]\nen_US:[{2}]", standardApiDataName.getListEnumZhTw(), standardApiDataName.getListEnumZhCn(), standardApiDataName.getListEnumEn());
					}
					String tRequestMessageDataNameEditHistory = standardApiDataName.getUpdateHistory();
					ObjectNode tDataNameDescriptionMultilingualNode = mapper.createObjectNode();
					tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getDescriptionZhTw());
					tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getDescriptionZhCn());
					tDataNameDescriptionMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getDescriptionEnUs());
					ObjectNode tDataRemarkMultilingualNode = mapper.createObjectNode();
					tDataRemarkMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getRemarkZhTw());
					tDataRemarkMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getRemarkZhCn());
					tDataRemarkMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getRemarkEnUs());
					String tDataName = standardApiDataName.getStandardDataName();
					if (standardApiDataName.getParentId() != null) {
						tParentId = standardApiDataName.getParentId();
						tRequestMessageSpecNode.put(ApiAttributeEnum.parent.toString(), tParentId);
					}
					tRequestMessageSpecNode.put(ApiAttributeEnum.columnType.toString(), tColumnType);
					tRequestMessageSpecNode.put(ApiAttributeEnum.id.toString(), tId);
					tRequestMessageSpecNode.put(ApiAttributeEnum.dataName.toString(), tDataName);
					tRequestMessageSpecNode.set(ApiAttributeEnum.dataDescriptionMultilingual.toString(), tDataNameDescriptionMultilingualNode);
					tRequestMessageSpecNode.set(ApiAttributeEnum.dataNameRemarkMultilingual.toString(), tDataRemarkMultilingualNode);
					tRequestMessageSpecNode.put(ApiAttributeEnum.isDatakey.toString(), tIsDataKey);
					tRequestMessageSpecNode.put(ApiAttributeEnum.dataType.toString(), tDataType);
					tRequestMessageSpecNode.put(ApiAttributeEnum.canSort.toString(), tCanSort);
					tRequestMessageSpecNode.put(ApiAttributeEnum.canFilter.toString(), tCanFilter);
					tRequestMessageSpecNode.put(ApiAttributeEnum.isRequired.toString(), tIsRequired);
					tRequestMessageSpecNode.put(ApiAttributeEnum.isArray.toString(), tIsArray);
					tRequestMessageSpecNode.put(ApiAttributeEnum.isBusinessKey.toString(), tIsBusinessKey);
					tRequestMessageSpecNode.put(ApiAttributeEnum.value.toString(), tValue);
					tRequestMessageSpecNode.put(ApiAttributeEnum.listEnum.toString(), tListEnum);
					tRequestMessageSpecNode.put(ApiAttributeEnum.editHistory.toString(), tRequestMessageDataNameEditHistory);
					tRequestMessageSpecAryNode.add(tRequestMessageSpecNode);
				}
			}
			// Response信息内容（成功）
			ArrayNode tResponseMessageSuccessSpecAryNode = mapper.createArrayNode();
			tResponseNode.set(ApiAttributeEnum.responseMessageSuccessSpec.toString(), tResponseMessageSuccessSpecAryNode);
			for (StandardApiDataName standardApiDataName : tStandardApiDataNameList) {
				if (standardApiDataName.getMsgType() == 2) {
					ObjectNode tResponseMessageSucccessSpecNode = mapper.createObjectNode();
					String tColumnType = standardApiDataName.getColumnType();
					long tId = standardApiDataName.getId();
					long tParentId;
					boolean tIsDataKey = standardApiDataName.getIsDatakey() != null && standardApiDataName.getIsDatakey();
					boolean tIsRequired = standardApiDataName.getIsRequired() != null && standardApiDataName.getIsRequired();
					boolean tIsArray = standardApiDataName.getIsArray() != null && standardApiDataName.getIsArray();
					boolean tCanSort = standardApiDataName.getCanSort() != null && standardApiDataName.getCanSort();
					boolean tCanFilter = standardApiDataName.getCanFilter() != null && standardApiDataName.getCanFilter();
					boolean tIsBusinessKey = standardApiDataName.getIsBusinesskey() != null && standardApiDataName.getIsBusinesskey();
					String tDataType = standardApiDataName.getDataType();
					String tValue = standardApiDataName.getValue();
					String tListEnum = null;
					if (standardApiDataName.getListEnumZhTw() != null) {
						tListEnum = MessageFormat.format("zh_TW:[{0}]\nzh_CN:[{1}]\nen_US:[{2}]", standardApiDataName.getListEnumZhTw(), standardApiDataName.getListEnumZhCn(), standardApiDataName.getListEnumEn());
					}
					String tResponseMessageSucccessDataNameEditHistory = standardApiDataName.getUpdateHistory();
					ObjectNode tDataNameDescriptionMultilingualNode = mapper.createObjectNode();
					tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getDescriptionZhTw());
					tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getDescriptionZhCn());
					tDataNameDescriptionMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getDescriptionEnUs());
					ObjectNode tDataRemarkMultilingualNode = mapper.createObjectNode();
					tDataRemarkMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getRemarkZhTw());
					tDataRemarkMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getRemarkZhCn());
					tDataRemarkMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getRemarkEnUs());
					String tDataName = standardApiDataName.getStandardDataName();
					if (standardApiDataName.getParentId() != null) {
						tParentId = standardApiDataName.getParentId();
						tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.parent.toString(), tParentId);
					}
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.columnType.toString(), tColumnType);
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.id.toString(), tId);
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.dataName.toString(), tDataName);
					tResponseMessageSucccessSpecNode.set(ApiAttributeEnum.dataDescriptionMultilingual.toString(), tDataNameDescriptionMultilingualNode);
					tResponseMessageSucccessSpecNode.set(ApiAttributeEnum.dataNameRemarkMultilingual.toString(), tDataRemarkMultilingualNode);
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.isDatakey.toString(), tIsDataKey);
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.dataType.toString(), tDataType);
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.canSort.toString(), tCanSort);
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.canFilter.toString(), tCanFilter);
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.isRequired.toString(), tIsRequired);
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.isArray.toString(), tIsArray);
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.isBusinessKey.toString(), tIsBusinessKey);
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.value.toString(), tValue);
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.listEnum.toString(), tListEnum);
					tResponseMessageSucccessSpecNode.put(ApiAttributeEnum.editHistory.toString(), tResponseMessageSucccessDataNameEditHistory);
					tResponseMessageSuccessSpecAryNode.add(tResponseMessageSucccessSpecNode);
				}
			}
			// Response信息内容（失败）
			ArrayNode tResponseMessageFailedSpecAryNode = mapper.createArrayNode();
			tResponseNode.set(ApiAttributeEnum.responseMessageFailedSpec.toString(), tResponseMessageFailedSpecAryNode);
			for (StandardApiDataName standardApiDataName : tStandardApiDataNameList) {
				if (standardApiDataName.getMsgType() == 3) {
					ObjectNode tResponseMessageFailedSpecNode = mapper.createObjectNode();
					String tColumnType = standardApiDataName.getColumnType();
					long tId = standardApiDataName.getId();
					long tParentId;
					boolean tIsDataKey = standardApiDataName.getIsDatakey() != null && standardApiDataName.getIsDatakey();
					boolean tIsRequired = standardApiDataName.getIsRequired() != null && standardApiDataName.getIsRequired();
					boolean tIsArray = standardApiDataName.getIsArray() != null && standardApiDataName.getIsArray();
					boolean tCanSort = standardApiDataName.getCanSort() != null && standardApiDataName.getCanSort();
					boolean tCanFilter = standardApiDataName.getCanFilter() != null && standardApiDataName.getCanFilter();
					boolean tIsBusinessKey = standardApiDataName.getIsBusinesskey() != null && standardApiDataName.getIsBusinesskey();
					String tDataType = standardApiDataName.getDataType();
					String tValue = standardApiDataName.getValue();
					String tListEnum = null;
					if (standardApiDataName.getListEnumZhTw() != null) {
						tListEnum = MessageFormat.format("zh_TW:[{0}]\nzh_CN:[{1}]\nen_US:[{2}]", standardApiDataName.getListEnumZhTw(), standardApiDataName.getListEnumZhCn(), standardApiDataName.getListEnumEn());
					}
					String tResponseMessageFailedDataNameEditHistory = standardApiDataName.getUpdateHistory();
					String tDataName = standardApiDataName.getStandardDataName();
					ObjectNode tDataNameDescriptionMultilingualNode = mapper.createObjectNode();
					tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getDescriptionZhTw());
					tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getDescriptionZhCn());
					tDataNameDescriptionMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getDescriptionEnUs());
					ObjectNode tDataRemarkMultilingualNode = mapper.createObjectNode();
					tDataRemarkMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getRemarkZhTw());
					tDataRemarkMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getRemarkZhCn());
					tDataRemarkMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getRemarkEnUs());
					if (standardApiDataName.getParentId() != null) {
						tParentId = standardApiDataName.getParentId();
						tResponseMessageFailedSpecNode.put(ApiAttributeEnum.parent.toString(), tParentId);
					}
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.columnType.toString(), tColumnType);
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.id.toString(), tId);
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.dataName.toString(), tDataName);
					tResponseMessageFailedSpecNode.set(ApiAttributeEnum.dataDescriptionMultilingual.toString(), tDataNameDescriptionMultilingualNode);
					tResponseMessageFailedSpecNode.set(ApiAttributeEnum.dataNameRemarkMultilingual.toString(), tDataRemarkMultilingualNode);
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.isDatakey.toString(), tIsDataKey);
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.dataType.toString(), tDataType);
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.canSort.toString(), tCanSort);
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.canFilter.toString(), tCanFilter);
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.isRequired.toString(), tIsRequired);
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.isArray.toString(), tIsArray);
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.isBusinessKey.toString(), tIsBusinessKey);
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.value.toString(), tValue);
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.listEnum.toString(), tListEnum);
					tResponseMessageFailedSpecNode.put(ApiAttributeEnum.editHistory.toString(), tResponseMessageFailedDataNameEditHistory);
					tResponseMessageFailedSpecAryNode.add(tResponseMessageFailedSpecNode);
				}
			}
			// 沒找到對應版本號數據
		} else {
			tStateCode = getStateCode(ValidateStateEnum.API_NAME_VER_NOTFOUND.getCode());
		}
		String tDescription = tStateCode.getDescription();
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}
}
