package com.digiwin.athena.apimgmt.cache;


import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.concurrent.TimeUnit;

@Component
public class GuavaLocalCache {
    private final Cache<String, List<String>> cache = CacheBuilder.newBuilder()
            //设置缓存初始大小，应该合理设置，后续会扩容
            .initialCapacity(10)
            //最大值
            .maximumSize(100)
            //并发数设置
            .concurrencyLevel(50)
            //缓存过期时间，写入后5分钟过期
            .expireAfterWrite(5, TimeUnit.MINUTES)
            //统计缓存命中率
            .recordStats()
            .build();

    public Cache<String, List<String>> getCache() {
        return cache;
    }
}