package com.digiwin.athena.apimgmt.dao;

import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;

import java.util.List;

public interface ApiMgmtStandardApiDataNameDao extends GenericDao<StandardApiDataName, Integer> {

    List<StandardApiDataName> getByApiVerId(Long pApiId, Boolean pShowField);

    List<StandardApiDataName> getByApiVerIdAndMsgType(Long pApiId, Integer pMsgType, Boolean pShowField);

    List<StandardApiDataName> selectByVersionIds(List<Long> subIdList);

    void batchSave(List<StandardApiDataName> subList);

    int deleteByApiVerId(Long apiVerId);

    void fillStandardApiDataNames(List<StandardApiVersion> versions);
}
