package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtProductApiDataNameMapper;
import com.digiwin.athena.apimgmt.model.ProductApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import org.springframework.stereotype.Repository;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Repository
public class ApiMgmtProductApiDataNameDaoMybatisImpl
        extends GenericDaoMybatisImpl<ApiMgmtProductApiDataNameMapper, ProductApiDataName, Long> {

    public void batchSave(List<ProductApiDataName> list) {
        batchService.saveBatch(list, 200);
    }

    @SuppressWarnings("UnusedReturnValue")
    public int deleteByApiVerId(Long apiVerId) {
        return baseMapper.deleteByApiVerId(apiVerId);
    }

    public void fillProductDataName(List<StandardApiDataName> list) {
        List<Long> apiDataNameId = CollUtil.map(list, StandardApiDataName::getId, true);

        Map<Long, List<ProductApiDataName>> apiDataNameIdMap = baseMapper.selectByApiDataNameIdList(apiDataNameId)
                .stream()
                .collect(Collectors.groupingBy(ProductApiDataName::getApiDataNameId));

        list.forEach(v -> {
            List<ProductApiDataName> productApiDataNameList = apiDataNameIdMap.getOrDefault(v.getId(), Collections.emptyList());
            v.setProductApiDataNames(productApiDataNameList);
        });
    }
}
