package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProductCategoryDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtProductCategoryMapper;
import com.digiwin.athena.apimgmt.model.ProductCategory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import java.util.List;

@Primary
@Repository
public class ApiMgmtProductCategoryDaoMybatisImpl extends GenericDaoMybatisImpl<ApiMgmtProductCategoryMapper, ProductCategory, Long>
        implements ApiMgmtProductCategoryDao {

    public ApiMgmtProductCategoryDaoMybatisImpl() {
        super();
    }

    @Override
    public List<ProductCategory> getAll() {
        LambdaQueryWrapper<ProductCategory> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.orderByAsc(ProductCategory::getNameZhTw);
        return baseMapper.selectList(queryWrapper);
    }

}