package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.apimgmt.dao.ApiMgmtSyncMdcFailDataDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtSyncMdcFailDataMapper;
import com.digiwin.athena.apimgmt.model.SyncMdcFailData;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import java.util.List;

@Primary
@Repository
public class ApiMgmtSyncMdcFailDataDaoMybatisImpl extends GenericDaoMybatisImpl<ApiMgmtSyncMdcFailDataMapper, SyncMdcFailData, Long>
        implements ApiMgmtSyncMdcFailDataDao {

    public ApiMgmtSyncMdcFailDataDaoMybatisImpl() {
        super();
    }

    @Override
    public List<SyncMdcFailData> getData() {
        return baseMapper.selectList(
                Wrappers.lambdaQuery(SyncMdcFailData.class)
                        .eq(SyncMdcFailData::getSuccessFlag, false)
                        .orderByAsc(SyncMdcFailData::getBuildTime)
        );
    }

    @Override
    public void removeByApiVerId(Long apiVerId) {
        LambdaQueryWrapper<SyncMdcFailData> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SyncMdcFailData::getApiVerId, apiVerId);
        baseMapper.delete(wrapper);
    }
}
