package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtTenantConfigMapper;
import com.digiwin.athena.apimgmt.model.TenantConfig;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import java.util.Optional;

@Primary
@Repository
public class ApiMgmtTenantConfigDaoMybatisImpl extends GenericDaoMybatisImpl<ApiMgmtTenantConfigMapper, TenantConfig, String>
        implements ApiMgmtTenantConfigDao {

    public ApiMgmtTenantConfigDaoMybatisImpl() {
        super();
    }

    @Override
    public Boolean getSkipReviewTenant(String pTenant) {
        LambdaQueryWrapper<TenantConfig> query = Wrappers.lambdaQuery(TenantConfig.class)
                .eq(TenantConfig::getTenantId, pTenant);

        TenantConfig tenantConfig = baseMapper.selectOne(query);
        return Optional.ofNullable(tenantConfig)
                .map(TenantConfig::isSkipReview)
                // 沒找到的租戶也略過審核
                .orElse(true);
    }

    @Override
    public Boolean getSkipReviewDataNameTenant(String pTenant) {
        return baseMapper.getSkipReviewDataNameTenant(pTenant) > 0;
    }

    @Override
    public Boolean viewAllApiTenantExist(String pTenant) {
        return baseMapper.viewAllApiTenantExist(pTenant) > 0;
    }
}
