package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.apimgmt.dao.ApiMgmtVerifyLogDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtVerifyLogMapper;
import com.digiwin.athena.apimgmt.model.VerifyLog;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import java.util.List;

@Primary
@Repository
public class ApiMgmtVerifyLogDaoMybatisImpl extends GenericDaoMybatisImpl<ApiMgmtVerifyLogMapper, VerifyLog, Long>
    implements ApiMgmtVerifyLogDao {

    public ApiMgmtVerifyLogDaoMybatisImpl() {
        super();
    }

    @Override
    public List<VerifyLog> getVerifyLogsByApiVerId(long pApiVerId) {
        LambdaQueryWrapper<VerifyLog> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(VerifyLog::getApiVerId, pApiVerId);
        return baseMapper.selectList(wrapper);
    }
}
