package com.digiwin.athena.apimgmt.dto;


import com.digiwin.athena.apimgmt.model.Project;
import com.digiwin.athena.apimgmt.model.ProjectVersion;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import java.util.Date;
import java.util.List;

public class ProjectDto extends Project {

    private Boolean hasVersions = false;
    private List<ProjectVersion> projectVersionList;

    public List<ProjectVersion> getProjectVersionList() {
        return projectVersionList;
    }


    public Boolean getHasVersions() {
        return hasVersions;
    }

    public void setHasVersions(Boolean hasVersions) {
        this.hasVersions = hasVersions;
    }

    public void setProjectVersionList(List<ProjectVersion> projectVersionList) {
        this.projectVersionList = projectVersionList;
    }

    public static ProjectDto create(Project project) {
        ProjectDto projectDto = new ProjectDto();
        BeanUtils.copyProperties(project, projectDto);
        return projectDto;
    }

    public void validateFields(){
        if (StringUtils.isEmpty(this.getProjectName())){
            throw new RuntimeException("项目名不能为空");
        }
        if (StringUtils.isEmpty(this.getProjectDesc())){
            throw new RuntimeException("项目描述不能为空");
        }
    }

    public Project createProject() {
        Project project = new Project();
        project.setProjectRemark(this.getProjectRemark());
        project.setProjectDesc(this.getProjectDesc());
        project.setProjectName(this.getProjectName());
        project.setCreateTime(new Date());
        project.setEditTime(new Date());


        return  project;
    }
}
