package com.digiwin.athena.apimgmt.model;


import cn.hutool.core.util.StrUtil;

public class AdvanceSearchValue {

    /**
     * 内容
     */
    private String content;

    /**
     * 符号
     */
    private String equation;

    /**
     * 标识
     */
    private String mark;

    /**
     * 字段
     */
    private String field;

    @Override
    public String toString() {
        return "AdvanceSearchValue{" +
                "content='" + content + '\'' +
                ", equation='" + equation + '\'' +
                ", mark='" + mark + '\'' +
                ", field='" + field + '\'' +
                ", order=" + order +
                '}';
    }

    /**
     * 排序
     */
    private Integer order;

    public AdvanceSearchValue(){

    }

    public AdvanceSearchValue(String content, String equation, String mark, String field, Integer order) {
        this.content = content;
        this.equation = equation;
        this.mark = mark;
        this.field = field;
        this.order = order;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setContent(Object content) {
        this.content = StrUtil.toStringOrNull(content);
    }

    public String getEquation() {
        return equation;
    }

    public void setEquation(String equation) {
        this.equation = equation;
    }

    public String getMark() {
        return mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }
}
