package com.digiwin.athena.apimgmt.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;

@Data
@TableName(value = "product", resultMap = "BaseResultMap")
public class Product implements Serializable {
	private static final long serialVersionUID = 1L;

    @TableId
	private String name;

    @TableField("is_agile")
	private Boolean isAgile;

    @TableField("product_category")
    private Integer productCategoryId;

    @TableField("remark")
    private String remark;

    // bi-directional many-to-one association to StandardApi
    @TableField(exist = false)
	private ProductCategory productCategory;

	// bi-directional many-to-one association to ProductVersion
    @TableField(exist = false)
	private List<ProductVersion> productVersions;

	// bi-directional many-to-one association to ProductApiDataName
    @TableField(exist = false)
	private List<ProductApiDataName> productApiDataNames;

	public Product() {
    }

    public void setProductCategory(ProductCategory productCategory) {
        this.productCategory = productCategory;
        if (productCategory != null) {
            this.productCategoryId = Optional.ofNullable(productCategory.getId())
                    .map(Long::intValue).orElse(null);
        }
	}

}
