package com.digiwin.athena.apimgmt.schedule;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtSyncMdcFailDataDao;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.model.SyncMdcFailData;
import com.digiwin.athena.apimgmt.services.ApiMgmtSyncMdcServiceProcessor;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 补偿同步mdc排程
 * 定时任务
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ApiMgmtSyncMdcFailDataTask {
    private final ApiMgmtSyncMdcFailDataDao syncMdcFailDataDao;
    private final ApiMgmtSyncMdcServiceProcessor syncMdcServiceProcessor;
    private final ApiMgmtProp apiMgmtProp;


    /**
     * 采用ScheduledExecutorService做一个建议的定时任务组件
     * 每隔1分钟发起一次。
     */
    public void syncMdcFailData() {
        long startTime = System.currentTimeMillis();
        try {
            log.info("定时任务开启: {}", Calendar.getInstance().getTime());
            List<SyncMdcFailData> list = syncMdcFailDataDao.getData();
            log.info("查询出的数据量: {}", list.size());
            if (CollUtil.isNotEmpty(list)) {
                Map<String, List<SyncMdcFailData>> map = list.stream()
                        .collect(Collectors.groupingBy(SyncMdcFailData::getSyncFactory));
                for (String syncFactory : map.keySet()) {
                    syncMdcServiceProcessor.reqSyncMdcMetadataAddCompensate(map.get(syncFactory), syncFactory);
                }
            }
        } catch (Exception e) {
            log.error("补偿任务执行完毕耗时：{}", e.getMessage());
        } finally {
            log.info("补偿任务执行完毕耗时：{}", System.currentTimeMillis() - startTime);
        }
    }
}
