package com.digiwin.athena.apimgmt.service.util;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.services.ApiDataNameService;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * apiDataName处理类util
 */
@Service
public class ApiDataNameServiceUtil extends GenericServiceUtil<ApiDataNameService> {

	private static ApiDataNameService service;

	@Override
	@Autowired
	public void setService(ApiDataNameService pService) {
		service = pService;
	}

	public static void setApiDataNameList(List<String> pDataNameList){
		service.dataNameList = pDataNameList;
	}
	
	public static List<String> getApiDataNameList(){
		return service.dataNameList;
	}
	
	public static void setReaponseMessageSpec(ObjectNode pResponseNode, List<StandardApiDataName> pStandardApiDataNameList, String pMessageSpec, int pMsgType, String pLocale) {
		service.setReaponseMessageSpec(pResponseNode, pStandardApiDataNameList, pMessageSpec, pMsgType, pLocale);
	}

}
