package com.digiwin.athena.apimgmt.service.util;

import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.services.ApiMgmtStandardApiExportService;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * api导出处理类util
 */
@Service
public class StandardApiExportServiceUtil extends GenericServiceUtil<ApiMgmtStandardApiExportService> {

    private static ApiMgmtStandardApiExportService service;

    @Override
    @Autowired
    public void setService(ApiMgmtStandardApiExportService pService) {
        service = pService;
    }

    public static String exportStandardApi(StandardApiVersion pStandardApiVersion) {
        return service.exportStandardApi(pStandardApiVersion);
    }

    public static String getTemplate() throws Exception {
        return service.getTemplate();
    }

    public static String getFileName(String pFilePath) {
        return service.getFileName(pFilePath);
    }

    public static Boolean removeFile(String pFilePath) {
        return service.removeFile(pFilePath);
    }

    public static HSSFWorkbook getTemplateFile(boolean pSetDateName) {
        return service.getTemplateFile(pSetDateName);
    }

}
