package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.util.URLUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtInterfaceConstant;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.infra.util.PropertyUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public abstract class AbstractService {

    ObjectMapper mapper = new ObjectMapper();


    /**
     * 翻译
     * @param content content
     * @param convertType convertType
     * @return String
     * @throws Exception Exception
     */
    protected String localeTranslate(String content, String convertType) throws Exception {
        String tTranslateCenterUrl = PropertyUtil.getApiMgmtProp().getTranslateCenterUrl();
        HttpRequest tPost = HttpRequest.ofPost(URLUtil.completeUrl(tTranslateCenterUrl, ApimgmtInterfaceConstant.DW_TRANSLATE_SERVICE_PATH));
        ArrayNode convertTypesArrayNode = mapper.createArrayNode();
        convertTypesArrayNode.add(convertType);
        ObjectNode objectNode = mapper.createObjectNode();
        objectNode.put("content", content);
        objectNode.set("convertTypes", convertTypesArrayNode);
        tPost.setEntity(objectNode);
        tPost.addHeader("Content-Type", "application/json;charset=UTF-8");
        if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
            tPost.setHeader(ApimgmtConstant.ROUTER_KEY, ApiMgmtServiceContextHolder.getRouterKey());
        }
        String tResponse = HttpUtil.execute(tPost, String.class);
        JsonNode responseObject = mapper.readTree(tResponse);
        return responseObject.get("response").get("data").get(convertType).asText();
    }
}
