package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.URLUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtInterfaceConstant;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.file.ApiMgmtFileService;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.http.MultipartFile;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtDmcProp;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.util.DateUtil;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Slf4j
@RequiredArgsConstructor
public class ApiMgmtFileDmcService implements ApiMgmtFileService {

    private final ObjectMapper mapper = new ObjectMapper();
    private final ApiMgmtDmcProp apiMgmtDmcProp;
    private final ApiMgmtProp prop;

    @Override
    public String uploadFile(File file, String fileName) throws Exception {
        String tUserToken = login();
        String tFileId = "";
        if (!StringUtil.isEmptyOrSpace(tUserToken)) {
            String tDmcHost = apiMgmtDmcProp.getUrl();
            String tBucket = apiMgmtDmcProp.getBucket();
            String tDmcDirectoryId = apiMgmtDmcProp.getDirectoryId();
            String tUriStr = URLUtil.completeUrl(tDmcHost,
                    String.format(ApimgmtInterfaceConstant.DMC_UPLOAD_FILE_PATH, tBucket) + "?bucket=" + tBucket);
            HttpRequest tPost = HttpRequest.ofPost(tUriStr);
            tPost.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_USER, tUserToken);
            tPost.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_APP, prop.getIamToken());
            tPost.setHeader(ApimgmtConstant.TOKEN, tUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tPost.setHeader(ApimgmtConstant.ROUTER_KEY, ApiMgmtServiceContextHolder.getRouterKey());
            }
            MultipartFile multipartFile = new MultipartFile("file", file);
            JsonObject tFileInfo = new JsonObject();
            tFileInfo.addProperty("directoryId", tDmcDirectoryId);
            tFileInfo.addProperty("displayName", fileName);
            tFileInfo.addProperty("fileName", fileName);
            tFileInfo.addProperty("expireDate", DateUtil.formatToSecond(new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5))));
            tPost.setEntity(MapUtil.of("fileInfo", tFileInfo));
            String tResponse = HttpUtil.uploadFile(tPost, multipartFile, String.class);
            JsonNode tDataNode;
            JsonNode tResponseNode = mapper.readTree(tResponse);
            if (tResponseNode.get("data") != null) {
                tDataNode = tResponseNode.get("data");
                if (tDataNode.get("id") != null) {
                    tFileId = tDataNode.get("id").asText();
                }
            }
        }
        return tFileId;
    }

    @Override
    public String generateDownloadLink(String fileId) throws Exception {
        String tUserToken = login();
        String tDownloadUrl = "";
        if (!StringUtil.isEmptyOrSpace(tUserToken)) {
            String tDmcHost = apiMgmtDmcProp.getUrl();
            String tBucket = apiMgmtDmcProp.getBucket();
            String tUriStr = URLUtil.completeUrl(tDmcHost,
                    String.format(ApimgmtInterfaceConstant.DMC_SHARED_FILE_LINK_PATH, tBucket) + "?bucket=" + tBucket);
            HttpRequest tPost = HttpRequest.ofPost(tUriStr);
            tPost.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_USER, tUserToken);
            tPost.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_APP, prop.getIamToken());
            tPost.setHeader("Content-Type", "application/json");
            tPost.setHeader(ApimgmtConstant.TOKEN, tUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tPost.setHeader(ApimgmtConstant.ROUTER_KEY, ApiMgmtServiceContextHolder.getRouterKey());
            }
            Map<String, Object> tRequestBody = new HashMap<>();
            tRequestBody.put("fileId", fileId);
            tRequestBody.put("expireDate", DateUtil.formatToSecond(new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5))));
            tPost.setEntity(tRequestBody);
            String tResponse = HttpUtil.execute(tPost, String.class);
            JsonNode tDataNode;
            JsonNode tResponseNode = mapper.readTree(tResponse);
            if (tResponseNode.get("data") != null) {
                tDataNode = tResponseNode.get("data");
                if (tDataNode.get("url") != null) {
                    tDownloadUrl = tDataNode.get("url").asText();
                }
            }
        }
        return tDownloadUrl;
    }

    @Override
    public String uploadFileAndGenerateDownloadLink(File file, String fileName) throws Exception {
        String tFileId = uploadFile(file, fileName);
        String tDownloadLink = null;
        if (!StringUtil.isEmptyOrSpace(tFileId)) {
            tDownloadLink = generateDownloadLink(tFileId);
        }
        log.info("分享API規格檔至dmc成功，檔案名稱:" + fileName + " 檔案ID:" + tFileId + " 下載連結:" + tDownloadLink);
        return tDownloadLink;
    }

    String login() {
        String tToken = null;
        HttpRequest tPost = HttpRequest.ofPost(URLUtil.completeUrl(apiMgmtDmcProp.getUrl(), ApimgmtInterfaceConstant.DMC_LOGIN_PATH));
        Map<String, Object> tRequestBody = new HashMap<>();
        tRequestBody.put(ApimgmtConstant.USER_NAME, apiMgmtDmcProp.getUser());
        tRequestBody.put(ApimgmtConstant.PWD_HASH, apiMgmtDmcProp.getHashedPassword());
        tPost.setHeader("Content-Type", "application/json");
        tPost.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_APP, prop.getIamToken());
        if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
            tPost.setHeader(ApimgmtConstant.ROUTER_KEY, ApiMgmtServiceContextHolder.getRouterKey());
        }
        tPost.setEntity(tRequestBody);
        //noinspection unchecked
        Map<String, String> tResponse = HttpUtil.execute(tPost, HashMap.class);
        if (null != tResponse && tResponse.get(ApimgmtConstant.USERTOKEN) != null) {
            tToken = tResponse.get(ApimgmtConstant.USERTOKEN);
        }
        return tToken;
    }
}
