package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProductCategoryDao;
import com.digiwin.athena.apimgmt.model.ProductCategory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * ProductCategory操作类,加锁保证数据为真
 */
@Service
public class ApiMgmtProductCategoryService implements InitializingBean {

    private static final Lock LOCK = new ReentrantLock(true);

    private List<ProductCategory> productCategories;

    @Autowired
    private ApiMgmtProductCategoryDao productCategoryDao;


    /**
     * 保存接收者信息
     * 必要的时候需要更新
     * @param providers providers
     */
    public void saveProductCategory(String providers) {
        LOCK.lock();
        try {
            if (CollUtil.isNotEmpty(productCategories) && StringUtils.isNotBlank(providers)) {
                for (String provider : providers.split(",")) {
                    boolean isExists = false;
                    for (ProductCategory productCategory : productCategories) {
                        if (productCategory.getNameEnUs().equals(provider)
                                || productCategory.getNameZhCn().equals(provider)
                                || productCategory.getNameZhTw().equals(provider)) {
                            isExists = true;
                            break;
                        }
                    }
                    if (!isExists) {
                        ProductCategory pc = new ProductCategory();
                        pc.setNameEnUs(provider);
                        pc.setNameZhCn(provider);
                        pc.setNameZhTw(provider);
                        productCategoryDao.save(pc);
                    }
                }
                productCategories = productCategoryDao.getAll();
            }
        } finally {
            LOCK.unlock();
        }
    }

    @Override
    public void afterPropertiesSet() {
        productCategories = productCategoryDao.getAll();
    }
}
