package com.digiwin.athena.apimgmt.services;

import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionDao;
import com.digiwin.athena.apimgmt.model.ProjectVersion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 放开原有的限制，版本在原有的基础上+-1
 */
@Service
public class ApiMgmtProjectVersionService {

    @Autowired
    private ApiMgmtProjectVersionDao projectVersionDao;

    public boolean judgeProjectVersionNames(Long projectId, List<String> projectVersionNameList) {
        List<ProjectVersion> projectVersionList = projectVersionDao.getByProjectVersionNames(projectId, projectVersionNameList);
        return projectVersionList.size() == projectVersionNameList.size();
    }

    public List<ProjectVersion> queryProjectVersionList(Long projectId, List<String> projectVersionNameList) {
        return projectVersionDao.getByProjectVersionNames(projectId, projectVersionNameList);
    }

    public List<ProjectVersion> queryProjectVersionByIdList(List<Long> projectIdList) {
        return projectVersionDao.queryProjectVersionByIdList(projectIdList);
    }

}