package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiInfoDTO;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiKeyDTO;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiProjectVerDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ApiMgmtStandardApiService {

    private final ApiMgmtStandardApiDao standardApiDao;
    private final ApiMgmtProjectVersionRelationDao projectVersionRelationDao;

    public List<ApiMgmtApiInfoDTO> queryByKey(List<ApiMgmtApiKeyDTO> apiKeys) {
        List<ApiMgmtApiInfoDTO> result = standardApiDao.queryByKey(apiKeys);

        if (CollUtil.isEmpty(result)) {
            return result;
        }

        List<Long> apiIds = result.stream()
                .map(ApiMgmtApiInfoDTO::getApiId)
                .distinct()
                .collect(Collectors.toList());

        Map<Long, List<ApiMgmtApiProjectVerDTO>> apiIdProjectVerMap = projectVersionRelationDao.selectProjectVerMapByApi(apiIds);

        result.forEach(dto -> {
            List<ApiMgmtApiProjectVerDTO> versionNames = apiIdProjectVerMap.get(dto.getApiId());
            if (CollUtil.isNotEmpty(versionNames)) {
                ApiMgmtApiProjectVerDTO first = versionNames.get(0);

                dto.setProjectCode(first.getProjectName());
                dto.setProjectHasVersions(first.getProjectHasVersion());
                dto.setProjectVersionNameList(CollUtil.map(versionNames, ApiMgmtApiProjectVerDTO::getProjectVerName, true));
            }
        });

        return result;
    }
}
