/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.AdvanceSearchValue;
import com.digiwin.athena.apimgmt.util.StandardApiMessageUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JsonLoader;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvanceSearchApiListGetCountService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdvanceSearchApiListGetCountService.class);
    @Autowired
    private ApiMgmtStandardApiDao standardApiDao;
    @Autowired
    private ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    private ApiMgmtTenantConfigDao tenantConfigDao;
    ObjectMapper mapper = new ObjectMapper();

    public Map<String, Object> execute(String validatorResult) throws Exception {
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + validatorResult);
        ObjectNode tResponse = this.mapper.createObjectNode();
        JsonNode tRequestJsonNode = JsonLoader.fromString((String)validatorResult);
        ArrayNode tConditionArrayNode = (ArrayNode)tRequestJsonNode.get("conditionList");
        JsonNode tCategoryId = tRequestJsonNode.get("categoryId");
        JsonNode projectId = tRequestJsonNode.get("projectId");
        JsonNode projectVersionId = tRequestJsonNode.get("projectVersionId");
        String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
        String teamType = ApiMgmtServiceContextHolder.getTeamType();
        boolean tViewAllApi = this.tenantConfigDao.viewAllApiTenantExist(tTenantId);
        List<List<AdvanceSearchValue>> arrayList = StandardApiMessageUtil.generateQuery(tConditionArrayNode, tCategoryId, null, null, projectId, projectVersionId, null);
        List<Long> ids = this.standardApiDao.advanceStandardApiCountSearch(arrayList, teamType, tTenantId, tViewAllApi);
        this.setStandardApiCountResponse(ids, tResponse);
        return (Map)this.mapper.convertValue((Object)tResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    private void setStandardApiCountResponse(List<Long> ids, ObjectNode tResponse) {
        long draftNum = 0L;
        long underReview = 0L;
        long developingNum = 0L;
        long confirmedNum = 0L;
        long deactivateNum = 0L;
        long total = 0L;
        if (CollUtil.isNotEmpty(ids)) {
            Map<Long, Long> countValue = this.standardApiVersionDao.advanceStandardApiCountByVersionIds(ids);
            draftNum = null == countValue.get(1L) ? 0L : countValue.get(1L);
            underReview = null == countValue.get(2L) ? 0L : countValue.get(2L);
            developingNum = null == countValue.get(3L) ? 0L : countValue.get(3L);
            confirmedNum = null == countValue.get(4L) ? 0L : countValue.get(4L);
            deactivateNum = null == countValue.get(5L) ? 0L : countValue.get(5L);
            total = draftNum + underReview + developingNum + confirmedNum + deactivateNum;
        }
        tResponse.put("draftNum", draftNum);
        tResponse.put("underReview", underReview);
        tResponse.put("developingNum", developingNum);
        tResponse.put("confirmedNum", confirmedNum);
        tResponse.put("deactivateNum", deactivateNum);
        tResponse.put("pageTotal", total);
    }
}

