/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtVerifyLogDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.model.VerifyLog;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiApprovedProcessGetService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiApprovedProcessGetService.class);
    @Autowired
    ApiMgmtVerifyLogDao verifyLogDao;
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

    public ApiApprovedProcessGetService() {
        this.jsonSchemaFileName = "api_approved_process_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, ParseException {
        List<VerifyLog> verifyLogs;
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        ArrayNode tApiProcessAryNode = this.mapper.createArrayNode();
        tResponseNode.set(ApiAttributeEnum.apiProcess.toString(), (JsonNode)tApiProcessAryNode);
        String tApiName = tRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        String tVersion = tRequestJsonNode.get(ApiAttributeEnum.version.toString()).asText();
        String branch = ApiVersionServiceUtil.getBranchFromVersion(tVersion);
        String tTenant = "";
        if (tRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
            tTenant = tRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()).asText();
        }
        List<StandardApiVersion> tStandardApiVersionList = this.standardApiVersionDao.fetchApiVersionsByName(tApiName, branch, tTenant);
        StandardApiVersion tStandardApiVersion = null;
        for (StandardApiVersion standardApiVersion : tStandardApiVersionList) {
            if (!standardApiVersion.getVersion().equals(tVersion)) continue;
            tStandardApiVersion = standardApiVersion;
        }
        if (tStandardApiVersion != null && (verifyLogs = this.verifyLogDao.getVerifyLogsByApiVerId(tStandardApiVersion.getId())).size() != 0) {
            for (VerifyLog verifyLog : verifyLogs) {
                String tOperation;
                ObjectNode tLogNode = this.mapper.createObjectNode();
                tLogNode.put(ApiAttributeEnum.apiName.toString(), tApiName);
                tLogNode.put(ApiAttributeEnum.auditor.toString(), verifyLog.getVerifyAcct());
                switch (tLocale) {
                    case "zh_CN": {
                        tOperation = verifyLog.getVerityOperate().getNameZhCn();
                        break;
                    }
                    case "zh_TW": {
                        tOperation = verifyLog.getVerityOperate().getNameZhTw();
                        break;
                    }
                    default: {
                        tOperation = verifyLog.getVerityOperate().getNameEnUs();
                    }
                }
                tLogNode.put(ApiAttributeEnum.operation.toString(), tOperation);
                tLogNode.put(ApiAttributeEnum.operationDesc.toString(), verifyLog.getReason());
                tLogNode.put(ApiAttributeEnum.auditor.toString(), verifyLog.getVerifyAcct());
                tLogNode.put(ApiAttributeEnum.version.toString(), tVersion);
                tLogNode.put(ApiAttributeEnum.approvedTime.toString(), DateUtil.formatLocalDateTime((LocalDateTime)verifyLog.getVerifyTime()));
                tApiProcessAryNode.add((JsonNode)tLogNode);
            }
            tApiProcessAryNode = this.sortJsonArrayByAttribute(tApiProcessAryNode, ApiAttributeEnum.approvedTime.toString());
            tResponseNode.set(ApiAttributeEnum.apiProcess.toString(), (JsonNode)tApiProcessAryNode);
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String string = tStateCode.getDescription();
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), string, tResponseNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    public ArrayNode sortJsonArrayByAttribute(ArrayNode pArrayNode, final String pAttribute) {
        int i;
        ArrayNode sortedJsonArray = this.mapper.createArrayNode();
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        for (i = 0; i < pArrayNode.size(); ++i) {
            list.add((ObjectNode)pArrayNode.get(i));
        }
        list.sort(new Comparator(){

            public int compare(Object o1, Object o2) {
                DateTime date1 = null;
                DateTime date2 = null;
                try {
                    String approvedTime1 = StringUtil.isEmptyOrSpace((Object)((ObjectNode)o1).get(pAttribute).asText()) ? ApimgmtConstant.EARLIEST_TIME : ((ObjectNode)o1).get(pAttribute).asText();
                    String approvedTime2 = StringUtil.isEmptyOrSpace((Object)((ObjectNode)o2).get(pAttribute).asText()) ? ApimgmtConstant.EARLIEST_TIME : ((ObjectNode)o2).get(pAttribute).asText();
                    date1 = DateUtil.parse((CharSequence)approvedTime1);
                    date2 = DateUtil.parse((CharSequence)approvedTime2);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                return ((Date)Objects.requireNonNull(date1)).compareTo((Date)date2);
            }
        });
        for (i = 0; i < pArrayNode.size(); ++i) {
            sortedJsonArray.add((JsonNode)list.get(i));
        }
        return sortedJsonArray;
    }
}

