/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiBranchGetService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiBranchGetService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    private ApiMgmtStandardApiDao standardApiDao;

    public ApiBranchGetService() {
        this.jsonSchemaFileName = "api_branch_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        HashMap<String, Object> tResponse = new HashMap<String, Object>();
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String description = tStateCode.getDescription();
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tApiName = tRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        String tenantId = Optional.ofNullable(tRequestJsonNode.get(ApiAttributeEnum.tenantId.toString())).map(JsonNode::asText).orElse("");
        List<StandardApi> standardApiList = this.standardApiDao.getByNameAndTenantId(tApiName, tenantId);
        String maxBranch = ApiBranchGetService.getNextBranch(standardApiList);
        tResponse.put("code", tStateCode.getCode());
        tResponse.put("description", description);
        tResponse.put(ApiAttributeEnum.branch.toString(), maxBranch);
        return tResponse;
    }

    public static String getNextBranch(List<StandardApi> standardApiList) {
        int maxBranch = CollUtil.emptyIfNull(standardApiList).stream().mapToInt(ApiBranchGetService::getBranchOrder).max().orElse(0);
        return maxBranch + 1 + ".0";
    }

    private static int getBranchOrder(StandardApi api) {
        return ApiVersionServiceUtil.getMajorVersion(api.getBranch());
    }
}

