/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiCategoryDao;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiCategoryGetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiCategoryGetService.class);
    @Autowired
    ApiMgmtStandardApiCategoryDao standardApiCategoryDao;

    public ArrayList<Map<String, Object>> execute(String validatorResult) {
        log.debug("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3\uff1a" + this.getClass() + "\uff0c\u539f\u59cb\u8a0a\u606f\uff1a" + validatorResult);
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        ArrayList<Map<String, Object>> tResponse = new ArrayList<Map<String, Object>>();
        List tStandardApiCategoryList = this.standardApiCategoryDao.getAll();
        for (StandardApiCategory tStandardApiCategory : tStandardApiCategoryList) {
            String tCategory;
            HashMap<String, Object> tCategoryMap = new HashMap<String, Object>();
            switch (tLocale) {
                case "zh_CN": {
                    tCategory = tStandardApiCategory.getNameZhCn();
                    break;
                }
                case "zh_TW": {
                    tCategory = tStandardApiCategory.getNameZhTw();
                    break;
                }
                default: {
                    tCategory = tStandardApiCategory.getNameEnUs();
                }
            }
            tCategoryMap.put("id", tStandardApiCategory.getId());
            tCategoryMap.put("category", tCategory);
            tResponse.add(tCategoryMap);
        }
        return tResponse;
    }
}

