/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.APIExportImportEnums;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMdcProp;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.service.util.DmcFileServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiExportServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiFileReadServiceUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtApiVersionService;
import com.digiwin.athena.apimgmt.services.ApiMgmtSyncMdcServiceProcessor;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@OperateAuthorityVerify
public class ApiComfirmedUpdateService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiComfirmedUpdateService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;
    @Autowired
    private ApiMgmtSyncMdcServiceProcessor syncMdcServiceProcessor;
    @Autowired
    private ApiMgmtApiVersionService apiVersionService;
    @Autowired
    private ApiMgmtMdcProp mdcProp;

    public ApiComfirmedUpdateService() {
        this.jsonSchemaFileName = "api_review_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = tStateCode.getDescription();
        ArrayList<Long> tListApiVerIdNeedToSyncMetadata = new ArrayList<Long>();
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ArrayNode tApiArrayNode = (ArrayNode)tRequestJsonNode.get("apiList");
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        String tToken = ApiMgmtServiceContextHolder.getToken();
        String routerKey = ApiMgmtServiceContextHolder.getRouterKey();
        String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
        String tUserId = ApiMgmtServiceContextHolder.getUserId();
        HashMap<String, List<Map<String, String>>> tTotalApiErrorMap = new HashMap<String, List<Map<String, String>>>();
        for (JsonNode tApiNode : tApiArrayNode) {
            String tApiError;
            StandardApiVersion tStandardApiVersion;
            String apiName = tApiNode.get(ApiAttributeEnum.apiName.toString()).asText();
            String version = tApiNode.get(ApiAttributeEnum.version.toString()).asText();
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(ApiAttributeEnum.apiName.toString(), apiName);
            tConditionMap.put(ApiAttributeEnum.version.toString(), version);
            if (tApiNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
                tConditionMap.put(ApiAttributeEnum.tenantId.toString(), tApiNode.get(ApiAttributeEnum.tenantId.toString()).asText());
            }
            if ((tStandardApiVersion = this.standardApiVersionDao.fetchApiVersion(tConditionMap)) == null || tStandardApiVersion.getStandardApi() == null || !StringUtil.isEmpty((Object)tStandardApiVersion.getStandardApi().getDesignTenantId()) && !tTenantId.equals(tStandardApiVersion.getStandardApi().getDesignTenantId())) continue;
            ArrayList<Map<String, String>> tSetStdApiResult = new ArrayList<Map<String, String>>();
            if (!this.apiVersionService.judgeNewBranch(version).booleanValue()) {
                String tPreviousVersion = ApiVersionServiceUtil.getPreviousVersion(version);
                tConditionMap.put(ApiAttributeEnum.version.toString(), tPreviousVersion);
                StandardApiVersion standardApiVersion = this.standardApiVersionDao.fetchApiVersion(tConditionMap);
                if (null != standardApiVersion && null != standardApiVersion.getApprovedStatus() && 4L != standardApiVersion.getApprovedStatus().getId()) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PREVI_IS_DEVELOPING.toString(), null, null, 0, 0, tLocale);
                    tApiError = apiName + "/" + version;
                    tTotalApiErrorMap.put(tApiError, tSetStdApiResult);
                    continue;
                }
                ApprovedStatus tApprovedStatus = (ApprovedStatus)this.approvedStatusDao.get(4L);
                tStandardApiVersion.setApprovedStatus(tApprovedStatus);
                tStandardApiVersion.setApprovedTime(LocalDateTime.now());
                this.standardApiVersionDao.saveOrupdate(tStandardApiVersion);
                tListApiVerIdNeedToSyncMetadata.add(tStandardApiVersion.getId());
                continue;
            }
            StandardApi standardApi = tStandardApiVersion.getStandardApi();
            if (!StringUtil.isEmptyOrSpace((Object)standardApi.getParentApiName())) {
                List<StandardApiVersion> standardApiVersionList = this.standardApiVersionDao.fetchApiVersionsByName(standardApi.getParentApiName(), standardApi.getParentBranch(), standardApi.getParentApiTenantId());
                if (CollUtil.isEmpty(standardApiVersionList = standardApiVersionList.stream().filter(x -> x.getApprovedStatus().getId() == 4L).collect(Collectors.toList()))) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PARENT_API_NOT_CONFIRMED.toString(), null, null, 0, 0, tLocale);
                    tApiError = apiName + "/" + version;
                    tTotalApiErrorMap.put(tApiError, tSetStdApiResult);
                    continue;
                }
            }
            ApprovedStatus tApprovedStatus = (ApprovedStatus)this.approvedStatusDao.get(4L);
            tStandardApiVersion.setApprovedStatus(tApprovedStatus);
            tStandardApiVersion.setApprovedTime(LocalDateTime.now());
            this.standardApiVersionDao.saveOrupdate(tStandardApiVersion);
            tListApiVerIdNeedToSyncMetadata.add(tStandardApiVersion.getId());
        }
        if (!tListApiVerIdNeedToSyncMetadata.isEmpty() && CollUtil.isNotEmpty((Collection)this.mdcProp.getConfirmedUrlList())) {
            for (String url : this.mdcProp.getConfirmedUrlList()) {
                this.syncMdcServiceProcessor.runSyncMdcMetadata(tListApiVerIdNeedToSyncMetadata, url, tUserId, tToken, routerKey);
            }
        }
        if (MapUtil.isNotEmpty(tTotalApiErrorMap)) {
            log.info("tTotalApiErrorMap: " + tTotalApiErrorMap);
            return this.result(tStateCode, tDescription, tTotalApiErrorMap);
        }
        HashMap<String, Object> tResponse = new HashMap<String, Object>();
        tResponse.put("code", "000");
        tResponse.put("result", "success");
        return tResponse;
    }

    private Map<String, Object> result(StateCode tStateCode, String tDescription, Map<String, List<Map<String, String>>> pTotalApiErrorMap) throws Exception {
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        tStateCode = this.getStateCode(ValidateStateEnum.IMPORT_SPEC_FORMAT_ERROR.getCode());
        tDescription = tStateCode.getDescription();
        HSSFWorkbook tHSSFWorkbook = StandardApiExportServiceUtil.getTemplateFile(false);
        HSSFSheet tErrorSheet = tHSSFWorkbook.createSheet("\u932f\u8aa4\u660e\u7d30");
        StandardApiFileReadServiceUtil.writeImportErrorFile((Sheet)tErrorSheet, pTotalApiErrorMap);
        String tFileName = ApiMgmtApplicationParameter._TEMPLATE_FILE_NAME;
        String tFileExportPath = ApiMgmtApplicationParameter._FILE_EXPORT_PATH + "/" + tFileName;
        FileOutputStream fileOut = new FileOutputStream(tFileExportPath);
        tHSSFWorkbook.write((OutputStream)fileOut);
        fileOut.close();
        int pFailedNum = pTotalApiErrorMap.keySet().size();
        DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tFileExportPath, tFileName, true, pFailedNum);
        tResponseNode.put("code", tStateCode.getCode());
        tResponseNode.put("description", tDescription);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

