/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@OperateAuthorityVerify
public class ApiDeleteService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiDeleteService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtStandardApiDao standardApiDao;

    public ApiDeleteService() {
        this.jsonSchemaFileName = "api_delete_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ArrayNode tApiArrayNode = (ArrayNode)tRequestJsonNode.get("apiList");
        for (JsonNode tApiNode : tApiArrayNode) {
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            String tApiName = tApiNode.get(ApiAttributeEnum.apiName.toString()).asText();
            String tVersion = tApiNode.get(ApiAttributeEnum.version.toString()).asText();
            String branch = ApiVersionServiceUtil.getBranchFromVersion(tVersion);
            String tTenant = "";
            if (tApiNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
                tTenant = tApiNode.get(ApiAttributeEnum.tenantId.toString()).asText();
            }
            tConditionMap.put(ApiAttributeEnum.apiName.toString(), tApiName);
            tConditionMap.put(ApiAttributeEnum.version.toString(), tVersion);
            tConditionMap.put(ApiAttributeEnum.tenantId.toString(), tTenant);
            StandardApiVersion tStandardApiVersion = this.standardApiVersionDao.fetchApiVersion(tConditionMap);
            if (tStandardApiVersion == null) continue;
            List<StandardApiVersion> tStandardApiVersions = this.standardApiVersionDao.fetchApiVersionsByName(tApiName, branch, tTenant);
            this.standardApiVersionDao.delete(tStandardApiVersion.getId(), tStandardApiVersions.size() <= 1);
        }
        HashMap<String, Object> tResponse = new HashMap<String, Object>();
        tResponse.put("code", "000");
        tResponse.put("result", "success");
        return tResponse;
    }
}

