/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.MessageFormatEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.ApiDataNameServiceUtil;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiDetailGetByNameService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiDetailGetByNameService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtStandardApiDataNameDao standardApiDataNameDao;
    @Autowired
    ApiMgmtTenantConfigDao tenantConfigDao;

    public ApiDetailGetByNameService() {
        this.jsonSchemaFileName = "api_detail_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException {
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tApiName = tRequestJsonNode.get(ApiAttributeEnum.apiName.toString()).asText();
        String branch = ObjectUtil.isNotNull((Object)tRequestJsonNode.get(ApiAttributeEnum.branch.toString())) ? tRequestJsonNode.get(ApiAttributeEnum.branch.toString()).asText() : "1.0";
        boolean isFormDev = false;
        if (tRequestJsonNode.get("isFormDev") != null) {
            isFormDev = tRequestJsonNode.get("isFormDev").asBoolean();
        }
        String tTenant = "";
        if (tRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
            tTenant = tRequestJsonNode.get(ApiAttributeEnum.tenantId.toString()).asText();
        }
        List<StandardApiVersion> standardApiVersionList = this.standardApiVersionDao.fetchApiVersionsByName(tApiName, branch, tTenant);
        StandardApiVersion tStandardApiVersion = null;
        if (CollUtil.isNotEmpty(standardApiVersionList)) {
            if (isFormDev) {
                standardApiVersionList = standardApiVersionList.stream().filter(v -> v.getApprovedStatus().getId().equals(3L) || v.getApprovedStatus().getId().equals(4L)).collect(Collectors.toList());
            }
            standardApiVersionList.sort((o1, o2) -> o2.getApprovedTime().compareTo(o1.getApprovedTime()));
            tStandardApiVersion = standardApiVersionList.get(0);
        }
        if (tStandardApiVersion != null) {
            MessageFormatEnum[] tMessageFormatEnums;
            String tCategoryName;
            String tGroupName;
            String tApiTag;
            String tApiRemark;
            String tApiDescription;
            String tApprovedStatus;
            StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
            String tApiNameResponse = tStandardApi.getName();
            String tParentApiNameResponse = tStandardApi.getParentApiName();
            String tParentBranchResponse = tStandardApi.getParentBranch();
            String tParentApiTenantIdResponse = tStandardApi.getParentApiTenantId();
            String tApiVersionString = tStandardApiVersion.getVersion();
            String tApplicant = tStandardApiVersion.getApplicant();
            String tEditHistory = tStandardApiVersion.getUpdateHistory() == null ? "" : tStandardApiVersion.getUpdateHistory();
            String tInvokeType = tStandardApi.getStandardApiSyncType().getNameEnUs();
            String tRequester = tStandardApi.getRequester();
            String tProvider = tStandardApi.getProvider();
            Long tPaging = tStandardApi.getStandardApiPaging().getId();
            int tStatusId = tStandardApiVersion.getApprovedStatus().getId().intValue();
            String approvedTime = DateUtil.formatLocalDateTime((LocalDateTime)tStandardApiVersion.getApprovedTime());
            int tCategoryId = tStandardApi.getStandardApiCategory().getId().intValue();
            int tGroup = tStandardApi.getStandardApiGroup().getId().intValue();
            String tIsBatch = tStandardApi.getIsBatch() != false ? "Y" : "N";
            String tIdempotency = tStandardApiVersion.getIdempotency() != false ? "Y" : "N";
            String tMsgFormat = tStandardApi.getMsgFormat();
            String tTenantId = tStandardApi.getTenantId() != null || StringUtil.isEmptyOrSpace((Object)tStandardApi.getTenantId()) ? tStandardApi.getTenantId() : "";
            switch (tLocale) {
                case "zh_CN": {
                    tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhCn();
                    tApiDescription = tStandardApi.getDescriptionZhCn();
                    tApiRemark = tStandardApi.getRemarkZhCn();
                    tApiTag = tStandardApi.getTagZhCn() == null ? "" : tStandardApi.getTagZhCn();
                    tGroupName = tStandardApi.getStandardApiGroup().getNameZhCn();
                    tCategoryName = tStandardApi.getStandardApiCategory().getNameZhCn();
                    break;
                }
                case "zh_TW": {
                    tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhTw();
                    tApiDescription = tStandardApi.getDescriptionZhTw();
                    tApiRemark = tStandardApi.getRemarkZhTw();
                    tApiTag = tStandardApi.getTagZhTw() == null ? "" : tStandardApi.getTagZhTw();
                    tGroupName = tStandardApi.getStandardApiGroup().getNameZhTw();
                    tCategoryName = tStandardApi.getStandardApiCategory().getNameZhTw();
                    break;
                }
                default: {
                    tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameEnUs();
                    tApiDescription = tStandardApi.getDescriptionEnUs();
                    tApiRemark = tStandardApi.getRemarkEnUs();
                    tApiTag = tStandardApi.getTagEnUs() == null ? "" : tStandardApi.getTagEnUs();
                    tGroupName = tStandardApi.getStandardApiGroup().getNameEnUs();
                    tCategoryName = tStandardApi.getStandardApiCategory().getNameEnUs();
                }
            }
            ObjectNode tApiDescriptionMultilingualNode = this.mapper.createObjectNode();
            tApiDescriptionMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tStandardApi.getDescriptionZhTw());
            tApiDescriptionMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tStandardApi.getDescriptionZhCn());
            tApiDescriptionMultilingualNode.put(LocaleEnum.EN_US.getType(), tStandardApi.getDescriptionEnUs());
            tResponseNode.set(ApiAttributeEnum.apiDescriptionMultilingual.toString(), (JsonNode)tApiDescriptionMultilingualNode);
            ObjectNode tApiRemarkMultilingualNode = this.mapper.createObjectNode();
            tApiRemarkMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tStandardApi.getRemarkZhTw());
            tApiRemarkMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tStandardApi.getRemarkZhCn());
            tApiRemarkMultilingualNode.put(LocaleEnum.EN_US.getType(), tStandardApi.getRemarkEnUs());
            tResponseNode.set(ApiAttributeEnum.apiRemarkMultilingual.toString(), (JsonNode)tApiRemarkMultilingualNode);
            ObjectNode tApiTagMultilingualNode = this.mapper.createObjectNode();
            tApiTagMultilingualNode.put(LocaleEnum.ZH_TW.getType(), tStandardApi.getTagZhTw() == null ? "" : tStandardApi.getTagZhTw());
            tApiTagMultilingualNode.put(LocaleEnum.ZH_CN.getType(), tStandardApi.getTagZhCn() == null ? "" : tStandardApi.getTagZhCn());
            tApiTagMultilingualNode.put(LocaleEnum.EN_US.getType(), tStandardApi.getTagEnUs() == null ? "" : tStandardApi.getTagEnUs());
            tResponseNode.set(ApiAttributeEnum.apiTagMultilingual.toString(), (JsonNode)tApiTagMultilingualNode);
            tResponseNode.put(ApiAttributeEnum.apiName.toString(), tApiNameResponse);
            tResponseNode.put(ApiAttributeEnum.apiId.toString(), tStandardApi.getId());
            tResponseNode.put(ApiAttributeEnum.parentApiName.toString(), tParentApiNameResponse);
            tResponseNode.put(ApiAttributeEnum.parentBranch.toString(), tParentBranchResponse);
            tResponseNode.put(ApiAttributeEnum.parentApiTenantId.toString(), tParentApiTenantIdResponse);
            tResponseNode.put(ApiAttributeEnum.apiDescription.toString(), tApiDescription);
            tResponseNode.put(ApiAttributeEnum.apiTag.toString(), tApiTag);
            tResponseNode.put(ApiAttributeEnum.apiRemark.toString(), tApiRemark);
            tResponseNode.put(ApiAttributeEnum.apiVersion.toString(), tApiVersionString);
            tResponseNode.put(ApiAttributeEnum.tenantId.toString(), tTenantId);
            tResponseNode.put(ApiAttributeEnum.applicant.toString(), tApplicant);
            tResponseNode.put(ApiAttributeEnum.approvedStatus.toString(), tApprovedStatus);
            tResponseNode.put(ApiAttributeEnum.approvedTime.toString(), approvedTime);
            tResponseNode.put(ApiAttributeEnum.editHistory.toString(), tEditHistory);
            tResponseNode.put(ApiAttributeEnum.requester.toString(), tRequester);
            tResponseNode.put(ApiAttributeEnum.provider.toString(), tProvider);
            tResponseNode.put(ApiAttributeEnum.idempotency.toString(), tIdempotency);
            tResponseNode.put(ApiAttributeEnum.invokeType.toString(), tInvokeType);
            tResponseNode.put(ApiAttributeEnum.paging.toString(), tPaging);
            tResponseNode.put(ApiAttributeEnum.statusId.toString(), tStatusId);
            tResponseNode.put(ApiAttributeEnum.categoryId.toString(), tCategoryId);
            tResponseNode.put(ApiAttributeEnum.categoryName.toString(), tCategoryName);
            tResponseNode.put(ApiAttributeEnum.group.toString(), tGroup);
            tResponseNode.put(ApiAttributeEnum.groupName.toString(), tGroupName);
            tResponseNode.put(ApiAttributeEnum.isBatch.toString(), tIsBatch);
            tResponseNode.put(ApiAttributeEnum.msgFormat.toString(), tMsgFormat);
            tResponseNode.put(ApiAttributeEnum.designTenantId.toString(), tStandardApi.getDesignTenantId());
            ArrayNode tApiVersionListAryNode = this.mapper.createArrayNode();
            for (StandardApiVersion standardApiVersion : standardApiVersionList) {
                tApiVersionListAryNode.add(standardApiVersion.getVersion());
            }
            tResponseNode.set(ApiAttributeEnum.apiVersionList.toString(), (JsonNode)tApiVersionListAryNode);
            ObjectNode tMessageExampleDownloadNode = this.mapper.createObjectNode();
            ObjectNode tRequesterSideNode = this.mapper.createObjectNode();
            ObjectNode tProviderSideNode = this.mapper.createObjectNode();
            ArrayNode tHostProductAryNode = this.mapper.createArrayNode();
            ArrayNode tServiceProductAryNode = this.mapper.createArrayNode();
            ArrayNode tMsgFormatAryNode = this.mapper.createArrayNode();
            tResponseNode.set(ApiAttributeEnum.messageExampleDownload.toString(), (JsonNode)tMessageExampleDownloadNode);
            tMessageExampleDownloadNode.set(ApiAttributeEnum.requesterSide.toString(), (JsonNode)tRequesterSideNode);
            tMessageExampleDownloadNode.set(ApiAttributeEnum.providerSide.toString(), (JsonNode)tProviderSideNode);
            tRequesterSideNode.set(ApiAttributeEnum.hostProduct.toString(), (JsonNode)tHostProductAryNode);
            tRequesterSideNode.set(ApiAttributeEnum.serviceProduct.toString(), (JsonNode)tServiceProductAryNode);
            tRequesterSideNode.set(ApiAttributeEnum.msgFormat.toString(), (JsonNode)tMsgFormatAryNode);
            tProviderSideNode.set(ApiAttributeEnum.hostProduct.toString(), (JsonNode)tHostProductAryNode);
            tProviderSideNode.set(ApiAttributeEnum.serviceProduct.toString(), (JsonNode)tServiceProductAryNode);
            tProviderSideNode.set(ApiAttributeEnum.msgFormat.toString(), (JsonNode)tMsgFormatAryNode);
            String[] tRequesterProducts = tStandardApi.getRequester().split(",");
            String[] tProviderProducts = tStandardApi.getProvider().split(",");
            for (String tRequester1 : tRequesterProducts) {
                tHostProductAryNode.add(tRequester1);
            }
            for (String tProvider1 : tProviderProducts) {
                tServiceProductAryNode.add(tProvider1);
            }
            for (MessageFormatEnum tMessageFormatEnum : tMessageFormatEnums = MessageFormatEnum.values()) {
                if (tMessageFormatEnum.equals((Object)MessageFormatEnum.JSON10) || tInvokeType.equals("fasync") && tMessageFormatEnum.equals((Object)MessageFormatEnum.XML)) continue;
                tMsgFormatAryNode.add(tMessageFormatEnum.toString());
            }
            List<StandardApiDataName> tStandardApiDataNameList = this.standardApiDataNameDao.getByApiVerId(tStandardApiVersion.getId(), true);
            ApiDataNameServiceUtil.setReaponseMessageSpec(tResponseNode, tStandardApiDataNameList, ApiAttributeEnum.requestMessageSpec.toString(), 1, tLocale);
            ApiDataNameServiceUtil.setReaponseMessageSpec(tResponseNode, tStandardApiDataNameList, ApiAttributeEnum.responseMessageSuccessSpec.toString(), 2, tLocale);
            ApiDataNameServiceUtil.setReaponseMessageSpec(tResponseNode, tStandardApiDataNameList, ApiAttributeEnum.responseMessageFailedSpec.toString(), 3, tLocale);
        } else {
            tStateCode = this.getStateCode(ValidateStateEnum.API_NAME_VER_NOTFOUND.getCode());
        }
        String tDescription = tStateCode.getDescription();
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tResponseNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

