/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.apiservice.AbstractApiService;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtVerifyLogDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtVerityOperateDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMdcProp;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.VerifyLog;
import com.digiwin.athena.apimgmt.model.VerityOperate;
import com.digiwin.athena.apimgmt.services.ApiMgmtSyncMdcServiceProcessor;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@OperateAuthorityVerify
public class ApiExaminationPassedUpdateService
extends AbstractApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiExaminationPassedUpdateService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;
    @Autowired
    ApiMgmtVerifyLogDao verifyLogDao;
    @Autowired
    ApiMgmtVerityOperateDao verityOperateDao;
    @Autowired
    private ApiMgmtSyncMdcServiceProcessor syncMdcServiceProcessor;
    @Autowired
    private ApiMgmtMdcProp mdcProp;

    public ApiExaminationPassedUpdateService() {
        this.jsonSchemaFileName = "api_examination_passed_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        ArrayList<Long> tListApiVerIdNeedToSyncMetadata = new ArrayList<Long>();
        String tToken = ApiMgmtServiceContextHolder.getToken();
        String routerKey = ApiMgmtServiceContextHolder.getRouterKey();
        String tUserId = ApiMgmtServiceContextHolder.getUserId();
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ArrayNode tApiArrayNode = (ArrayNode)tRequestJsonNode.get("apiList");
        for (JsonNode tApiNode : tApiArrayNode) {
            StandardApiVersion tStandardApiVersion;
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(ApiAttributeEnum.apiName.toString(), tApiNode.get(ApiAttributeEnum.apiName.toString()).asText());
            tConditionMap.put(ApiAttributeEnum.version.toString(), tApiNode.get(ApiAttributeEnum.version.toString()).asText());
            if (tApiNode.get(ApiAttributeEnum.tenantId.toString()) != null) {
                tConditionMap.put(ApiAttributeEnum.tenantId.toString(), tApiNode.get(ApiAttributeEnum.tenantId.toString()).asText());
            }
            if ((tStandardApiVersion = this.standardApiVersionDao.fetchApiVersion(tConditionMap)) == null) continue;
            ApprovedStatus tApprovedStatus = (ApprovedStatus)this.approvedStatusDao.get(3L);
            tStandardApiVersion.setApprovedStatus(tApprovedStatus);
            tStandardApiVersion.setApprovedTime(LocalDateTime.now());
            this.standardApiVersionDao.saveOrupdate(tStandardApiVersion);
            Long tApiVerId = tStandardApiVersion.getId();
            tListApiVerIdNeedToSyncMetadata.add(tApiVerId);
            this.setLog(tApiVerId, tUserId, tApiNode.get("passDesc").asText());
        }
        for (String url : this.mdcProp.getReviewUrlList()) {
            this.syncMdcServiceProcessor.runSyncMdcMetadata(tListApiVerIdNeedToSyncMetadata, url, tUserId, tToken, routerKey);
        }
        HashMap<String, Object> tResponse = new HashMap<String, Object>();
        tResponse.put("code", "000");
        tResponse.put("result", "success");
        return tResponse;
    }

    private void setLog(Long pApiVerId, String pUserId, String pPaasDesc) {
        VerityOperate tVerityOperate = (VerityOperate)this.verityOperateDao.get(1L);
        VerifyLog tVerifyLog = new VerifyLog();
        tVerifyLog.setApiVerId(pApiVerId);
        tVerifyLog.setVerifyAcct(pUserId);
        tVerifyLog.setVerifyTime(LocalDateTime.now());
        tVerifyLog.setVerityOperate(tVerityOperate);
        tVerifyLog.setReason(pPaasDesc);
        this.verifyLogDao.save(tVerifyLog);
    }
}

