/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.common.model.dto.FileDto;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStateCodeDao;
import com.digiwin.athena.apimgmt.enums.APIExportImportEnums;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.DmcFileServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiFileReadServiceUtil;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiImportCheckService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiImportCheckService.class);
    ObjectMapper mapper = new ObjectMapper();
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    private ApiMgmtStateCodeDao stateCodeDao;

    public Map<String, Object> execute(FileDto file) throws BaseException {
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3\uff1a" + this.getClass());
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        StateCode tStateCode = this.stateCodeDao.getStateCodeByCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = tStateCode.getDescription();
        StringBuilder tDescriptionBuilder = new StringBuilder();
        try {
            String tUserId = ApiMgmtServiceContextHolder.getUserId();
            String tUserName = ApiMgmtServiceContextHolder.getUserName();
            InputStream fileIn = file.getInputStream();
            String fileType = FilenameUtils.getExtension((String)file.getFileName());
            Workbook tWorkbook = StandardApiFileReadServiceUtil.getWorkBook(fileType, fileIn);
            ObjectNode tCheckResult = this.mapper.createObjectNode();
            int tDraftDuplicateCount = 0;
            int tUnderReviewDuplicateCount = 0;
            int tDevelopingDuplicateCount = 0;
            int tConfirmedDuplicateCount = 0;
            String tDuplicateType = null;
            String tOtherUser = null;
            HashMap<String, Integer> tOtherUserDuplicateRecord = new HashMap<String, Integer>();
            boolean tApiAlreadyExist = false;
            int tAlreadyExistCount = 0;
            log.info("\u8b80\u5165\u7684Excel\u6709" + tWorkbook.getNumberOfSheets() + "\u500bSheets.");
            for (int tSheetNumber = 5; tSheetNumber < tWorkbook.getNumberOfSheets(); ++tSheetNumber) {
                String tVersion;
                String tTenantId;
                if (tWorkbook.isSheetHidden(tSheetNumber)) continue;
                StandardApi tStandardApi = new StandardApi();
                Sheet tSheet = tWorkbook.getSheetAt(tSheetNumber);
                Map<String, String> tSetStdApiResult = StandardApiFileReadServiceUtil.setStandardApiBasicInfo(tStandardApi, tUserName, tSheet);
                if (!StringUtil.isEmptyOrSpace((Object)tSetStdApiResult.get(APIExportImportEnums.RESULT_MESSAGE.toString()))) {
                    tStateCode = this.getStateCode(ValidateStateEnum.IMPORT_SPEC_FORMAT_ERROR.getCode());
                    tSetStdApiResult.put("code", tStateCode.getCode());
                    tSetStdApiResult.put("description", "API\u57fa\u7840\u4fe1\u606f\u68c0\u6d4b\u5f02\u5e38: " + tSetStdApiResult.get(APIExportImportEnums.RESULT_MESSAGE.toString()));
                    return (Map)this.mapper.convertValue(tSetStdApiResult, (TypeReference)new TypeReference<Map<String, Object>>(){});
                }
                String tApiName = tStandardApi.getName();
                List<StandardApiVersion> tExistStandardApiVersions = this.standardApiVersionDao.getExistApiVersion(tApiName, tTenantId = tStandardApi.getTenantId(), tVersion = tStandardApi.getStandardApiVersions().get(0).getVersion());
                if (tExistStandardApiVersions.isEmpty()) continue;
                if (Objects.equals(tUserId, tExistStandardApiVersions.get(0).getUserId())) {
                    switch (String.valueOf(tExistStandardApiVersions.get(0).getApprovedStatus().getId())) {
                        case "1": {
                            ++tDraftDuplicateCount;
                            tDuplicateType = "1";
                            break;
                        }
                        case "2": {
                            ++tUnderReviewDuplicateCount;
                            tDuplicateType = "2";
                            break;
                        }
                        case "3": {
                            ++tDevelopingDuplicateCount;
                            tDuplicateType = "3";
                            break;
                        }
                        case "4": {
                            ++tConfirmedDuplicateCount;
                            tDuplicateType = "4";
                            break;
                        }
                    }
                } else {
                    tDuplicateType = "5";
                    tOtherUser = tExistStandardApiVersions.get(0).getUserId();
                    if (tOtherUserDuplicateRecord.get(tExistStandardApiVersions.get(0).getUserId()) == null) {
                        tOtherUserDuplicateRecord.put(tExistStandardApiVersions.get(0).getUserId(), 1);
                    } else {
                        int i = (Integer)tOtherUserDuplicateRecord.get(tExistStandardApiVersions.get(0).getUserId());
                        tOtherUserDuplicateRecord.put(tExistStandardApiVersions.get(0).getUserId(), i + 1);
                    }
                }
                tApiAlreadyExist = true;
                ++tAlreadyExistCount;
                StandardApiFileReadServiceUtil.addDuplicateDescription(tWorkbook, tSheet, tDuplicateType, tOtherUser);
            }
            if (tApiAlreadyExist) {
                String tDetailFilePath = ApiMgmtApplicationParameter._FILE_EXPORT_PATH + "/" + file.getFileName();
                String tDetailFileName = file.getFileName();
                FileOutputStream fileOut = new FileOutputStream(tDetailFilePath);
                tWorkbook.write((OutputStream)fileOut);
                fileOut.close();
                DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tDetailFilePath, tDetailFileName, true, 0);
                tStateCode = this.stateCodeDao.getStateCodeByCode(ValidateStateEnum.IMPORT_SPEC_DUPLICATE_API.getCode());
                tDescription = tStateCode.getDescription();
            }
            if (tDraftDuplicateCount != 0) {
                tCheckResult.put(ApiAttributeEnum.DraftDuplicate.toString(), tDraftDuplicateCount);
            }
            if (tUnderReviewDuplicateCount != 0) {
                tCheckResult.put(ApiAttributeEnum.UnderReviewDuplicate.toString(), tUnderReviewDuplicateCount);
            }
            if (tDevelopingDuplicateCount != 0) {
                tCheckResult.put(ApiAttributeEnum.DevelopingDuplicate.toString(), tDevelopingDuplicateCount);
            }
            if (tConfirmedDuplicateCount != 0) {
                tCheckResult.put(ApiAttributeEnum.ConfirmedDuplicate.toString(), tConfirmedDuplicateCount);
            }
            if (!tOtherUserDuplicateRecord.isEmpty()) {
                ArrayNode tOtherUserDuplicateAryNode = this.mapper.createArrayNode();
                for (String tUser : tOtherUserDuplicateRecord.keySet()) {
                    ObjectNode tUserDuplicateNode = this.mapper.createObjectNode();
                    tUserDuplicateNode.put(ApiAttributeEnum.userId.toString(), tUser);
                    tUserDuplicateNode.put(ApiAttributeEnum.duplicateNumber.toString(), (Integer)tOtherUserDuplicateRecord.get(tUser));
                    tOtherUserDuplicateAryNode.add((JsonNode)tUserDuplicateNode);
                }
                tCheckResult.set(ApiAttributeEnum.OtherUserDuplicate.toString(), (JsonNode)tOtherUserDuplicateAryNode);
            }
            tResponseNode.set(ApiAttributeEnum.checkResult.toString(), (JsonNode)tCheckResult);
            tResponseNode.put(ApiAttributeEnum.wholeError.toString(), tAlreadyExistCount == tWorkbook.getNumberOfSheets() - 5);
        }
        catch (BaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            tStateCode = this.getStateCode(e.getStateEnum().getCode());
            tDescriptionBuilder.append(tStateCode.getDescription());
            if (!StringUtil.isEmptyOrSpace((Object)e.getMessage())) {
                tDescriptionBuilder.append(" ").append(e.getMessage());
            }
            tDescription = tDescriptionBuilder.toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            tStateCode = this.getStateCode(ValidateStateEnum.UNEXPECTED_ERROR.getCode());
            tDescriptionBuilder.append(tStateCode.getDescription()).append(" ").append(e.getClass().toString()).append(":").append(e.getMessage());
            tDescription = tDescriptionBuilder.toString();
        }
        tResponseNode.put("code", tStateCode.getCode());
        tResponseNode.put("description", tDescription);
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3\uff1a" + this.getClass() + "\uff0c\u56de\u50b3\u8a0a\u606f\uff1a" + tResponseNode.toString());
        return (Map)this.mapper.convertValue((Object)tResponseNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    protected StateCode getStateCode(String pStateCode) {
        return this.stateCodeDao.getStateCodeByCode(pStateCode);
    }
}

