/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.common.model.dto.FileDto;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStateCodeDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtTenantConfigDao;
import com.digiwin.athena.apimgmt.enums.APIExportImportEnums;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.enums.ValidateStateEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.exception.ImportApiNotFindValidationException;
import com.digiwin.athena.apimgmt.exception.TeamIdNotFindValidationException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StateCode;
import com.digiwin.athena.apimgmt.service.util.ApiDataNameServiceUtil;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import com.digiwin.athena.apimgmt.service.util.DmcFileServiceUtil;
import com.digiwin.athena.apimgmt.service.util.StandardApiFileReadServiceUtil;
import com.digiwin.athena.apimgmt.service.util.ValidateApiDataNameServiceUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtApiVersionService;
import com.digiwin.athena.apimgmt.services.ApiMgmtProductCategoryService;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiImportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiImportService.class);
    ObjectMapper mapper = new ObjectMapper();
    private static final Lock LOCK = new ReentrantLock(true);
    @Autowired
    ApiMgmtTenantConfigDao tenantConfigDao;
    @Autowired
    private ApiMgmtStateCodeDao stateCodeDao;
    @Autowired
    private ApiMgmtStandardApiDao standardApiDao;
    @Autowired
    private ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    private ApiMgmtStandardDataNameDao standardDataNameDao;
    @Autowired
    private ApiMgmtProductCategoryService productCategoryService;
    @Autowired
    private ApiMgmtApiVersionService apiVersionService;
    @Autowired
    private ApiMgmtProp prop;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> execute(FileDto file) throws Exception {
        if (this.prop.isEnvType()) {
            throw new Exception("\u6b64\u64cd\u4f5c\u4e0d\u5bf9\u5916\u5f00\u653e,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3\uff1a" + this.getClass());
        ObjectNode tResponseNode = this.mapper.createObjectNode();
        StateCode tStateCode = this.stateCodeDao.getStateCodeByCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = tStateCode.getDescription();
        StringBuilder tDescriptionBuilder = new StringBuilder();
        try {
            String tLocale = ApiMgmtServiceContextHolder.getLocale();
            tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
            String tTeamId = ApiMgmtServiceContextHolder.getTeamId();
            String teamType = ApiMgmtServiceContextHolder.getTeamType();
            if (null == teamType) {
                throw new TeamIdNotFindValidationException(this.getClass());
            }
            String tTenant = ApiMgmtServiceContextHolder.getTenantId();
            String tUserId = ApiMgmtServiceContextHolder.getUserId();
            String tUserName = ApiMgmtServiceContextHolder.getUserName();
            InputStream fileIn = file.getInputStream();
            String fileType = FilenameUtils.getExtension((String)file.getFileName());
            Workbook tWorkbook = StandardApiFileReadServiceUtil.getWorkBook(fileType, fileIn);
            boolean tApiSpecErrorExist = false;
            log.info("\u5bfc\u5165\u7684Excel\u6709" + tWorkbook.getNumberOfSheets() + "\u4e2aSheet\u9875");
            ArrayList<Integer> tApiSheetIndex = new ArrayList<Integer>();
            for (int tSheetNumber = 0; tSheetNumber < tWorkbook.getNumberOfSheets(); ++tSheetNumber) {
                Sheet tSheet = tWorkbook.getSheetAt(tSheetNumber);
                String tSheetName = tSheet.getSheetName().trim();
                if (!StandardApi.validateName("esp", tSheetName) && !StandardApi.validateName("openapi", tSheetName)) continue;
                tApiSheetIndex.add(tSheetNumber);
            }
            if (CollUtil.isEmpty(tApiSheetIndex)) {
                throw new ImportApiNotFindValidationException(this.getClass());
            }
            boolean tSkipReview = this.tenantConfigDao.getSkipReviewDataNameTenant(tTenant);
            LOCK.lock();
            try {
                if (!tSkipReview) {
                    List<String> tDataNameAllList = ApiDataNameServiceUtil.getApiDataNameList();
                    Long tDataNameCount = this.standardDataNameDao.getDataNameCount();
                    if ((long)tDataNameAllList.size() != tDataNameCount) {
                        tDataNameAllList = this.standardDataNameDao.getAllDataName();
                        ApiDataNameServiceUtil.setApiDataNameList(tDataNameAllList);
                    }
                }
            }
            finally {
                LOCK.unlock();
            }
            HashMap<String, List<Map<String, String>>> tTotalApiErrorMap = new HashMap<String, List<Map<String, String>>>();
            Iterator iterator = tApiSheetIndex.iterator();
            while (iterator.hasNext()) {
                HashMap<String, StandardApiDataName> tAddDataName;
                List<Map<String, String>> tSetStdApiDataNameResult;
                String prevBranch;
                String tApiError;
                List<StandardApiVersion> tPreviStandardApiVersions;
                Object tApiError2;
                int tSheetNumber = (Integer)iterator.next();
                log.info("\u68c0\u67e5\u6837\u677fSheet\u7d22\u5f15\u4e3a: " + tSheetNumber);
                if (tWorkbook.isSheetHidden(tSheetNumber)) continue;
                StandardApi tStandardApi = new StandardApi();
                Sheet tSheet = tWorkbook.getSheetAt(tSheetNumber);
                List<Map<String, String>> tSetStdApiResult = StandardApiFileReadServiceUtil.setStandardApi(tStandardApi, tUserName, tSheet, tLocale);
                String tApiName = tStandardApi.getName();
                String tTenantId = tStandardApi.getTenantId();
                String tVersion = Optional.ofNullable((StandardApiVersion)CollUtil.getFirst(tStandardApi.getStandardApiVersions())).map(StandardApiVersion::getVersion).orElse("");
                String branch = tStandardApi.getBranch();
                if (CollUtil.isNotEmpty(tSetStdApiResult)) {
                    String tApiError3 = tApiName + "/" + tVersion;
                    tTotalApiErrorMap.put(tApiError3, tSetStdApiResult);
                    tApiSpecErrorExist = true;
                    continue;
                }
                tStandardApi.setTeamId(tTeamId);
                tStandardApi.setTeamType(teamType);
                tStandardApi.setDesignTenantId(tTenant);
                List<StandardApiVersion> tExistStandardApiVersions = this.standardApiVersionDao.getExistApiVersion(tApiName, tTenantId, tVersion);
                if (!tExistStandardApiVersions.isEmpty()) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.API_VERSION_IS_EXIST.toString(), null, null, 0, 0, tLocale);
                    tApiError2 = tApiName + "/" + tVersion;
                    tTotalApiErrorMap.put((String)tApiError2, tSetStdApiResult);
                    tApiSpecErrorExist = true;
                    continue;
                }
                if (tSetStdApiResult.size() != 0) {
                    tApiError2 = tApiName + "/" + tVersion;
                    tTotalApiErrorMap.put((String)tApiError2, tSetStdApiResult);
                    tApiSpecErrorExist = true;
                    continue;
                }
                for (StandardApiVersion tapiVersion : tStandardApi.getStandardApiVersions()) {
                    tapiVersion.setApprovedAcct(tUserId);
                    tapiVersion.setUserId(tUserId);
                }
                tStandardApi.setBuildAcct(tUserId);
                if (!this.apiVersionService.judgeNewBranch(tVersion).booleanValue()) {
                    String prevVersion = ApiVersionServiceUtil.getPreviousVersion(tVersion);
                    tPreviStandardApiVersions = this.standardApiVersionDao.getExistApiVersion(tApiName, tTenantId, prevVersion);
                    if (tPreviStandardApiVersions.isEmpty()) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PREVI_API_VERSION_IS_EXIST.toString(), null, null, 0, 0, tLocale);
                        tApiError = tApiName + "/" + tVersion;
                        tTotalApiErrorMap.put(tApiError, tSetStdApiResult);
                        tApiSpecErrorExist = true;
                        continue;
                    }
                    Long approvedStatus = Optional.ofNullable((StandardApiVersion)CollUtil.getFirst(tPreviStandardApiVersions)).map(StandardApiVersion::getApprovedStatus).map(ApprovedStatus::getId).orElse(null);
                    if (!Objects.equals(approvedStatus, 4L)) {
                        StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PREVI_IS_DEVELOPING.toString(), null, null, 0, 0, tLocale);
                        String tApiError4 = tApiName + "/" + tVersion;
                        tTotalApiErrorMap.put(tApiError4, tSetStdApiResult);
                        tApiSpecErrorExist = true;
                        continue;
                    }
                    List<StandardApi> tPreviStandardApis = this.standardApiDao.getListByNameAndBranchAndTenantId(tApiName, branch, tTenantId);
                    if (CollUtil.isNotEmpty(tPreviStandardApis)) {
                        boolean tBatchIsChanged = ValidateApiDataNameServiceUtil.checkBatchIsChanged(tPreviStandardApis.get(0).getIsBatch(), tStandardApi.getIsBatch());
                        if (tBatchIsChanged) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.IS_BATCH_CAN_NOT_CHANGE.toString(), null, null, 0, 0, tLocale);
                            String tApiError5 = tApiName + "/" + tVersion;
                            tTotalApiErrorMap.put(tApiError5, tSetStdApiResult);
                            tApiSpecErrorExist = true;
                            continue;
                        }
                        boolean tSyncTypeIsChanged = ValidateApiDataNameServiceUtil.checkSyncTypeIsChanged(tPreviStandardApis.get(0).getStandardApiSyncType().getId(), tStandardApi.getStandardApiSyncType().getId());
                        if (tSyncTypeIsChanged) {
                            StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.SYNC_TYPE_CAN_NOT_CHANGE.toString(), null, null, 0, 0, tLocale);
                            String tApiError6 = tApiName + "/" + tVersion;
                            tTotalApiErrorMap.put(tApiError6, tSetStdApiResult);
                            tApiSpecErrorExist = true;
                            continue;
                        }
                    }
                } else if (!"1.0".equals(tVersion) && (tPreviStandardApiVersions = this.standardApiVersionDao.getExistApiVersion(tApiName, tTenantId, prevBranch = ApiVersionServiceUtil.getPrevBranchByVersion(tVersion))).isEmpty()) {
                    StandardApiFileReadServiceUtil.uploadCheckResult(tSetStdApiResult, APIExportImportEnums.PREV_API_BRANCH_NOT_EXIST.toString(), null, null, 0, 0, tLocale);
                    tTotalApiErrorMap.put(tApiName + "/" + tVersion, tSetStdApiResult);
                    tApiSpecErrorExist = true;
                    continue;
                }
                if (!(tSetStdApiDataNameResult = StandardApiFileReadServiceUtil.setStandardApiDataName(tStandardApi, tAddDataName = new HashMap<String, StandardApiDataName>(), tSheet, true, tLocale, tSkipReview, tUserId)).isEmpty()) {
                    tApiError = tApiName + "/" + tVersion;
                    tTotalApiErrorMap.put(tApiError, tSetStdApiDataNameResult);
                    tApiSpecErrorExist = true;
                    continue;
                }
                this.standardApiDao.save(tStandardApi);
                this.productCategoryService.saveProductCategory(tStandardApi.getProvider());
            }
            if (tApiSpecErrorExist) {
                tStateCode = this.stateCodeDao.getStateCodeByCode(ValidateStateEnum.IMPORT_SPEC_FORMAT_ERROR.getCode());
                tDescription = tStateCode.getDescription();
                int tErrorSheetIndex = tWorkbook.getSheetIndex("\u932f\u8aa4\u660e\u7d30");
                if (tErrorSheetIndex >= 0) {
                    tWorkbook.removeSheetAt(tErrorSheetIndex);
                }
                Sheet tErrorSheet = tWorkbook.createSheet("\u932f\u8aa4\u660e\u7d30");
                StandardApiFileReadServiceUtil.writeImportErrorFile(tErrorSheet, tTotalApiErrorMap);
                String tDetailFilePath = ApiMgmtApplicationParameter._FILE_EXPORT_PATH + "/" + file.getFileName();
                String tDetailFileName = file.getFileName();
                FileOutputStream fileOut = new FileOutputStream(tDetailFilePath);
                tWorkbook.write((OutputStream)fileOut);
                fileOut.close();
                int pFailedNum = tTotalApiErrorMap.keySet().size();
                DmcFileServiceUtil.uploadFileAndGenerateDownloadLink(tResponseNode, tDetailFilePath, tDetailFileName, true, pFailedNum);
            }
        }
        catch (BaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            tStateCode = this.getStateCode(e.getStateEnum().getCode());
            tDescriptionBuilder.append(tStateCode.getDescription());
            if (!StringUtil.isEmptyOrSpace((Object)e.getMessage())) {
                tDescriptionBuilder.append(" ").append(e.getMessage());
            }
            tDescription = tDescriptionBuilder.toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            tStateCode = this.getStateCode(ValidateStateEnum.UNEXPECTED_ERROR.getCode());
            tDescriptionBuilder.append(tStateCode.getDescription()).append(" ").append(e.getClass().toString()).append(":").append(e.getMessage());
            tDescription = tDescriptionBuilder.toString();
        }
        tResponseNode.put("code", tStateCode.getCode());
        tResponseNode.put("description", tDescription);
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3\uff1a" + this.getClass() + "\uff0c\u56de\u50b3\u8a0a\u606f\uff1a" + tResponseNode.toString());
        return (Map)this.mapper.convertValue((Object)tResponseNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    protected StateCode getStateCode(String pStateCode) {
        return this.stateCodeDao.getStateCodeByCode(pStateCode);
    }
}

