/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class ApiListByStatusGetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiListByStatusGetService.class);
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

    public ArrayList<Map<String, Object>> execute(String validatorResult) throws Exception {
        log.info("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3\uff1a" + this.getClass() + "\uff0c\u539f\u59cb\u8a0a\u606f\uff1a" + validatorResult);
        ArrayList<Map<String, Object>> tResponse = new ArrayList<Map<String, Object>>();
        String tLocale = ApiMgmtServiceContextHolder.getLocale();
        tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
        String tUserId = ApiMgmtServiceContextHolder.getUserId();
        String tTenantId = ApiMgmtServiceContextHolder.getTenantId();
        JsonNode tRequestJsonNode = JsonLoader.fromString((String)validatorResult);
        String tReqStatus = tRequestJsonNode.get("statusId").asText();
        boolean tIsVerifyAcct = false;
        if (!StringUtil.isEmptyOrSpace((Object)tRequestJsonNode.get("verifyAcct").asText())) {
            tIsVerifyAcct = true;
        }
        log.info("search start: " + tReqStatus + "_" + tIsVerifyAcct);
        List<StandardApiVersion> tStandardApiVersionList = this.standardApiVersionDao.getByStatus(Long.valueOf(tReqStatus), tUserId, tTenantId, tIsVerifyAcct);
        log.info("tStandardApiVersionList: " + tStandardApiVersionList);
        if (tStandardApiVersionList != null) {
            for (StandardApiVersion tStandardApiVersion : tStandardApiVersionList) {
                String tCategory;
                String tSyncType;
                String tRemark;
                String tDescription;
                String tApprovedStatus;
                StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
                HashMap<String, Object> tApiMap = new HashMap<String, Object>();
                switch (tLocale) {
                    case "zh_CN": {
                        tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhCn();
                        tDescription = tStandardApi.getDescriptionZhCn();
                        tRemark = tStandardApi.getRemarkZhCn();
                        tSyncType = tStandardApi.getStandardApiSyncType().getNameZhCn();
                        tCategory = tStandardApi.getStandardApiCategory().getNameZhCn();
                        break;
                    }
                    case "zh_TW": {
                        tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameZhTw();
                        tDescription = tStandardApi.getDescriptionZhTw();
                        tRemark = tStandardApi.getRemarkZhTw();
                        tSyncType = tStandardApi.getStandardApiSyncType().getNameZhTw();
                        tCategory = tStandardApi.getStandardApiCategory().getNameZhTw();
                        break;
                    }
                    default: {
                        tApprovedStatus = tStandardApiVersion.getApprovedStatus().getNameEnUs();
                        tDescription = tStandardApi.getDescriptionEnUs();
                        tRemark = tStandardApi.getRemarkEnUs();
                        tSyncType = tStandardApi.getStandardApiSyncType().getNameEnUs();
                        tCategory = tStandardApi.getStandardApiCategory().getNameEnUs();
                    }
                }
                tApiMap.put("name", tStandardApi.getName());
                tApiMap.put("version", tStandardApiVersion.getVersion());
                tApiMap.put("approvedStatus", tApprovedStatus);
                tApiMap.put(ApiAttributeEnum.approvedTime.toString(), DateUtil.formatLocalDateTime((LocalDateTime)tStandardApiVersion.getApprovedTime()));
                tApiMap.put("description", tDescription);
                tApiMap.put("remark", tRemark);
                tApiMap.put("syncType", tSyncType);
                tApiMap.put("categoryId", tStandardApi.getStandardApiCategory().getId());
                tApiMap.put("categoryName", tCategory);
                tApiMap.put("msgFormat", tStandardApi.getMsgFormat());
                tApiMap.put("provider", tStandardApi.getProvider());
                tApiMap.put("tenantId", tStandardApi.getTenantId());
                tApiMap.put("statusId", tStandardApiVersion.getApprovedStatus().getId());
                tResponse.add(tApiMap);
            }
        }
        return tResponse;
    }
}

